/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class WirelessIOSlotConfigMessage
implements IMessage {
    private byte[] configData;
    private boolean isClose;

    public WirelessIOSlotConfigMessage() {
    }

    public WirelessIOSlotConfigMessage(byte[] configData, boolean isClose) {
        this.configData = configData;
        this.isClose = isClose;
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        this.configData = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.configData[i] = buf.readByte();
        }
        this.isClose = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.configData.length);
        for (byte configDatum : this.configData) {
            buf.writeByte((int)configDatum);
        }
        buf.writeBoolean(this.isClose);
    }

    public static class Handler
    implements IMessageHandler<WirelessIOSlotConfigMessage, IMessage> {
        public IMessage onMessage(WirelessIOSlotConfigMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
                        ItemWirelessIO.setSlotConfig(stack, message.configData);
                        if (!message.isClose) {
                            player.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.WIRELESS_IO.getId(), player.field_70170_p, 0, 0, 0);
                        }
                    }
                });
            }
            return null;
        }
    }
}

