/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect;

import io.netty.buffer.ByteBuf;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EffectData {
    private static final int MAX_DURATION = Short.MAX_VALUE;
    private byte effectId;
    private byte amplifier;
    private int duration;
    private byte showParticles;

    public EffectData(ByteBuf buf) {
        this.effectId = buf.readByte();
        this.amplifier = buf.readByte();
        this.duration = buf.readInt();
        this.showParticles = buf.readByte();
    }

    public EffectData(PotionEffect effect) {
        this.effectId = (byte)(Potion.func_188409_a((Potion)effect.func_188419_a()) & 0xFF);
        this.amplifier = (byte)(effect.func_76458_c() & 0xFF);
        this.duration = effect.func_76459_b() > Short.MAX_VALUE ? Short.MAX_VALUE : effect.func_76459_b();
        this.showParticles = 0;
        if (effect.func_82720_e()) {
            this.showParticles = (byte)(this.showParticles | 1);
        }
        if (effect.func_188418_e()) {
            this.showParticles = (byte)(this.showParticles | 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMaxDuration() {
        return this.duration == Short.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getEffectId() {
        return this.effectId;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getAmplifier() {
        return this.amplifier;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDuration() {
        return this.duration;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesShowParticles() {
        return (this.showParticles & 2) == 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getIsAmbient() {
        return (this.showParticles & 1) == 1;
    }

    public void write(ByteBuf buf) {
        buf.writeByte((int)this.effectId);
        buf.writeByte((int)this.amplifier);
        buf.writeInt(this.duration);
        buf.writeByte((int)this.showParticles);
    }
}

