/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect;

import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.EffectData;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EffectReply
implements IMessage {
    private int entityId;
    private int effectSize;
    private List<EffectData> effectList = Lists.newArrayList();

    public EffectReply() {
    }

    public EffectReply(int entityId, Collection<PotionEffect> potionEffects) {
        this.entityId = entityId;
        this.effectSize = potionEffects.size();
        for (PotionEffect effect : potionEffects) {
            this.effectList.add(new EffectData(effect));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.effectSize = buf.readInt();
        for (int i = 0; i < this.effectSize; ++i) {
            this.effectList.add(new EffectData(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.effectSize);
        for (EffectData data : this.effectList) {
            data.write(buf);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<EffectData> getEffectList() {
        return this.effectList;
    }
}

