/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.proxy;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.api.util.ItemDefinition;
import com.github.tartaricacid.touhoulittlemaid.bauble.DrownProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.ExplosionProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.ExtraLifeBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.FallProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.FireProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.ItemMagnetBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.MagicProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.MuteBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.NimbleFabricBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.ProjectileProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.TombstoneBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.UndyingTotemBauble;
import com.github.tartaricacid.touhoulittlemaid.bauble.WirelessIOBauble;
import com.github.tartaricacid.touhoulittlemaid.block.muiltblock.MuiltBlockAltar;
import com.github.tartaricacid.touhoulittlemaid.capability.HasGuideSerializer;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumSerializer;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerSerializer;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.command.MainCommand;
import com.github.tartaricacid.touhoulittlemaid.command.ReloadDrawCommand;
import com.github.tartaricacid.touhoulittlemaid.command.ReloadServerPackCommand;
import com.github.tartaricacid.touhoulittlemaid.command.ReloadSpellCardCommand;
import com.github.tartaricacid.touhoulittlemaid.compat.crafttweaker.AltarZen;
import com.github.tartaricacid.touhoulittlemaid.compat.neat.NeatCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.patchouli.MultiblockRegistry;
import com.github.tartaricacid.touhoulittlemaid.compat.theoneprobe.TheOneProbeInfo;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipesManager;
import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardManger;
import com.github.tartaricacid.touhoulittlemaid.draw.DrawManger;
import com.github.tartaricacid.touhoulittlemaid.draw.SendToClientDrawMessage;
import com.github.tartaricacid.touhoulittlemaid.draw.SendToServerDrawMessage;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMaidJoy;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMaidVehicle;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMarisaBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPortableAudio;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityScarecrow;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySuitcase;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityThrowPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTrolleyAudio;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityRinnosuke;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskAttack;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskAttackDanmaku;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskAttackRanged;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskBrewing;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskCocoa;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskExtinguishing;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskFarm;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskFeed;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskFeedAnimal;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskFurnace;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskGrass;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskHammer;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskMelon;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskMilk;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskShears;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskSnow;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskSugarCane;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskTorch;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaCocoaHandler;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaFeedHandler;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaGrassHandler;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaMelonHandler;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaNormalFarmHandler;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaSnowHandler;
import com.github.tartaricacid.touhoulittlemaid.internal.task.VanillaSugarCaneFarmHandler;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.GetServerPackMessage;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.SendClientPackMessage;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.ServerPackManager;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.SyncClientPackMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ApplyChairSkinDataMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ApplyMaidSkinDataMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.BeaconAbsorbMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ChangeMaidTaskMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ClearMaidPosMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.GoheiModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidHomeModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidPickupModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidShowHelmetMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.PortableAudioMessageToClient;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.PortableAudioMessageToServer;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.PotionGuideIndexMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SendNameTagMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SendNpcMaidModelMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetBeaconOverflowMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetBeaconPotionMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetCompassModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetMaidRidingMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetMaidSasimonoCRC32;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetScarecrowDataMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SwitchMaidGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncCustomSpellCardData;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncOwnerMaidNumMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncPowerMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncPowerPointEntityData;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.TrolleyAudioSoundMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.UpdateMaidSleepYawMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.WirelessIOGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.WirelessIOSlotConfigMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.ClientEffectHandler;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.EffectReply;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.EffectRequest;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.ServerEffectHandler;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.world.DungeonLootTable;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import crafttweaker.CraftTweakerAPI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;

public class CommonProxy {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    public static final Map<String, String> VANILLA_ID_NAME_MAP = Maps.newHashMap();
    private static final Pattern PATTERN = Pattern.compile("^\\d\\.\\d\\.\\d_(\\d+)$");
    public static final ScriptEngine NASHORN = CommonProxy.getScriptEngine();
    public static AltarRecipesManager ALTAR_RECIPES_MANAGER;
    public static SimpleNetworkWrapper INSTANCE;

    public static boolean isNpcModLoad() {
        return Loader.isModLoaded((String)"customnpcs");
    }

    private static ScriptEngine getScriptEngine() {
        int version;
        Matcher matcher = PATTERN.matcher(System.getProperty("java.version"));
        if (matcher.find() && (version = Integer.parseInt(matcher.group(1))) < 60) {
            return new ScriptEngineManager().getEngineByName("nashorn");
        }
        return new ScriptEngineManager(null).getEngineByName("nashorn");
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.initModelList();
        DrawManger.readDrawCsvFile(this);
        this.registerModEntity();
        this.registerEntitySpawns();
        this.registerMessage();
        if (Loader.isModLoaded((String)"theoneprobe")) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)TheOneProbeInfo.class.getName());
        }
    }

    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)TouhouLittleMaid.INSTANCE, (IGuiHandler)new MaidGuiHandler());
        PowerSerializer.register();
        MaidNumSerializer.register();
        HasGuideSerializer.register();
        CustomSpellCardManger.onCustomSpellCardReload();
        if (Loader.isModLoaded((String)"patchouli")) {
            MultiblockRegistry.init();
        }
        LootTableList.func_186375_a((ResourceLocation)DungeonLootTable.getPowerPointLoot());
        LootTableList.func_186375_a((ResourceLocation)DungeonLootTable.getSmartSlabLoot());
    }

    public void postInit(FMLPostInitializationEvent event) {
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.ULTRAMARINE_ORB_ELIXIR), new ExtraLifeBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(Items.field_190929_cY), new UndyingTotemBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.EXPLOSION_PROTECT_BAUBLE), new ExplosionProtectBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.FIRE_PROTECT_BAUBLE), new FireProtectBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.MAGIC_PROTECT_BAUBLE), new MagicProtectBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.PROJECTILE_PROTECT_BAUBLE), new ProjectileProtectBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.FALL_PROTECT_BAUBLE), new FallProtectBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.DROWN_PROTECT_BAUBLE), new DrownProtectBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.TOMBSTONE_BAUBLE), new TombstoneBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.NIMBLE_FABRIC), new NimbleFabricBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.WIRELESS_IO), new WirelessIOBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.ITEM_MAGNET_BAUBLE), new ItemMagnetBauble());
        LittleMaidAPI.registerBauble(ItemDefinition.of(MaidItems.MUTE_BAUBLE), new MuteBauble());
        LittleMaidAPI.registerTask(new TaskAttack());
        LittleMaidAPI.registerTask(new TaskAttackRanged());
        LittleMaidAPI.registerTask(new TaskAttackDanmaku());
        LittleMaidAPI.registerTask(new TaskFarm());
        LittleMaidAPI.registerTask(new TaskSugarCane());
        LittleMaidAPI.registerTask(new TaskMelon());
        LittleMaidAPI.registerTask(new TaskCocoa());
        LittleMaidAPI.registerTask(new TaskGrass());
        LittleMaidAPI.registerTask(new TaskSnow());
        LittleMaidAPI.registerTask(new TaskFeed());
        LittleMaidAPI.registerTask(new TaskIdle());
        LittleMaidAPI.registerTask(new TaskShears());
        LittleMaidAPI.registerTask(new TaskMilk());
        LittleMaidAPI.registerTask(new TaskTorch());
        LittleMaidAPI.registerTask(new TaskFeedAnimal());
        LittleMaidAPI.registerTask(new TaskExtinguishing());
        LittleMaidAPI.registerTask(new TaskHammer());
        LittleMaidAPI.registerTask(new TaskFurnace());
        LittleMaidAPI.registerTask(new TaskBrewing());
        LittleMaidAPI.registerFarmHandler(new VanillaNormalFarmHandler());
        VanillaNormalFarmHandler.readInnerCropFile();
        LittleMaidAPI.registerFarmHandler(new VanillaSugarCaneFarmHandler());
        LittleMaidAPI.registerFarmHandler(new VanillaMelonHandler());
        LittleMaidAPI.registerFarmHandler(new VanillaCocoaHandler());
        LittleMaidAPI.registerFarmHandler(new VanillaGrassHandler());
        LittleMaidAPI.registerFarmHandler(new VanillaSnowHandler());
        LittleMaidAPI.registerFeedHandler(new VanillaFeedHandler());
        LittleMaidAPI.registerMultiBlock(new MuiltBlockAltar());
        ALTAR_RECIPES_MANAGER = new AltarRecipesManager();
        if (Loader.isModLoaded((String)"neat")) {
            NeatCompat.init();
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            AltarZen.DELAYED_ACTIONS.forEach(CraftTweakerAPI::apply);
            AltarZen.DELAYED_ACTIONS.clear();
        }
        ServerPackManager.initCrc32Info();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        ConfigManager.sync((String)"touhou_little_maid", (Config.Type)Config.Type.INSTANCE);
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new MainCommand());
        event.registerServerCommand((ICommand)new ReloadSpellCardCommand());
        event.registerServerCommand((ICommand)new ReloadDrawCommand());
        event.registerServerCommand((ICommand)new ReloadServerPackCommand());
    }

    public void initModelList() {
        VANILLA_ID_NAME_MAP.clear();
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("assets/touhou_little_maid/maid_model.json");
        if (input != null) {
            try {
                CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
                pack.decorate();
                pack.getModelList().forEach(m -> VANILLA_ID_NAME_MAP.put(m.getModelId().toString(), ParseI18n.parse(m.getName())));
            }
            catch (JsonSyntaxException e) {
                TouhouLittleMaid.LOGGER.warn("Fail to parse model pack in domain {}", (Object)"touhou_little_maid");
            }
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    private void registerModEntity() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.passive.maid"), EntityMaid.class, (String)"touhou_little_maid.maid", (int)0, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)3, (boolean)true, (int)4874645, (int)0xFFFFFF);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.projectile.danmaku"), EntityDanmaku.class, (String)"touhou_little_maid.danmaku", (int)1, (Object)TouhouLittleMaid.INSTANCE, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.marisa_broom"), EntityMarisaBroom.class, (String)"touhou_little_maid.marisa_broom", (int)2, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.chair"), EntityChair.class, (String)"touhou_little_maid.chair", (int)3, (Object)TouhouLittleMaid.INSTANCE, (int)160, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.monster.rinnosuke"), EntityRinnosuke.class, (String)"touhou_little_maid.rinnosuke", (int)4, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)3, (boolean)true, (int)5331611, (int)0x535353);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.power_point"), EntityPowerPoint.class, (String)"touhou_little_maid.power_point", (int)5, (Object)TouhouLittleMaid.INSTANCE, (int)160, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.monster.fairy"), EntityFairy.class, (String)"touhou_little_maid.fairy", (int)6, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)3, (boolean)true, (int)1514528, (int)0xFFFFFF);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.box"), EntityBox.class, (String)"touhou_little_maid.box", (int)7, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.suitcase"), EntitySuitcase.class, (String)"touhou_little_maid.suitcase", (int)8, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.backpack"), EntityBackpack.class, (String)"touhou_little_maid.backpack", (int)9, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.trolley_audio"), EntityTrolleyAudio.class, (String)"touhou_little_maid.trolley_audio", (int)10, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.maid_vehicle"), EntityMaidVehicle.class, (String)"touhou_little_maid.maid_vehicle", (int)11, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.scarecrow"), EntityScarecrow.class, (String)"touhou_little_maid.scarecrow", (int)12, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.portable_audio"), EntityPortableAudio.class, (String)"touhou_little_maid.portable_audio", (int)13, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.extinguishing_agent"), EntityExtinguishingAgent.class, (String)"touhou_little_maid.extinguishing_agent", (int)14, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.throw_power_point"), EntityThrowPowerPoint.class, (String)"touhou_little_maid.throw_power_point", (int)15, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("touhou_little_maid", "entity.item.maid_joy"), EntityMaidJoy.class, (String)"touhou_little_maid.maid_joy", (int)16, (Object)TouhouLittleMaid.INSTANCE, (int)80, (int)10, (boolean)false);
    }

    private void registerEntitySpawns() {
        EntityRegistry.addSpawn(EntityRinnosuke.class, (int)GeneralConfig.MOB_CONFIG.rinnosukeSpawnProbability, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0]));
        EntityRegistry.addSpawn(EntityFairy.class, (int)GeneralConfig.MOB_CONFIG.maidFairySpawnProbability, (int)2, (int)6, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS).toArray(new Biome[0]));
    }

    private void registerMessage() {
        INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("touhou_little_maid");
        INSTANCE.registerMessage(SwitchMaidGuiMessage.Handler.class, SwitchMaidGuiMessage.class, 0, Side.SERVER);
        INSTANCE.registerMessage(MaidPickupModeMessage.Handler.class, MaidPickupModeMessage.class, 1, Side.SERVER);
        INSTANCE.registerMessage(ChangeMaidTaskMessage.Handler.class, ChangeMaidTaskMessage.class, 2, Side.SERVER);
        INSTANCE.registerMessage(MaidHomeModeMessage.Handler.class, MaidHomeModeMessage.class, 3, Side.SERVER);
        INSTANCE.registerMessage(GoheiModeMessage.Handler.class, GoheiModeMessage.class, 4, Side.SERVER);
        INSTANCE.registerMessage(ApplyMaidSkinDataMessage.Handler.class, ApplyMaidSkinDataMessage.class, 5, Side.SERVER);
        INSTANCE.registerMessage(ApplyChairSkinDataMessage.Handler.class, ApplyChairSkinDataMessage.class, 6, Side.SERVER);
        INSTANCE.registerMessage(SetMaidSasimonoCRC32.Handler.class, SetMaidSasimonoCRC32.class, 7, Side.SERVER);
        INSTANCE.registerMessage(SyncPowerMessage.Handler.class, SyncPowerMessage.class, 8, Side.CLIENT);
        INSTANCE.registerMessage(SyncPowerPointEntityData.Handler.class, SyncPowerPointEntityData.class, 9, Side.CLIENT);
        INSTANCE.registerMessage(StorageAndTakePowerMessage.Handler.class, StorageAndTakePowerMessage.class, 10, Side.SERVER);
        INSTANCE.registerMessage(SetBeaconPotionMessage.Handler.class, SetBeaconPotionMessage.class, 11, Side.SERVER);
        INSTANCE.registerMessage(ServerEffectHandler.class, EffectRequest.class, 12, Side.SERVER);
        INSTANCE.registerMessage(ClientEffectHandler.class, EffectReply.class, 13, Side.CLIENT);
        INSTANCE.registerMessage(BeaconAbsorbMessage.Handler.class, BeaconAbsorbMessage.class, 14, Side.CLIENT);
        INSTANCE.registerMessage(SyncCustomSpellCardData.Handler.class, SyncCustomSpellCardData.class, 15, Side.CLIENT);
        INSTANCE.registerMessage(SyncOwnerMaidNumMessage.Handler.class, SyncOwnerMaidNumMessage.class, 16, Side.CLIENT);
        if (CommonProxy.isNpcModLoad()) {
            INSTANCE.registerMessage(SendNpcMaidModelMessage.Handler.class, SendNpcMaidModelMessage.class, 17, Side.SERVER);
        }
        INSTANCE.registerMessage(TrolleyAudioSoundMessage.Handler.class, TrolleyAudioSoundMessage.class, 18, Side.CLIENT);
        INSTANCE.registerMessage(SetCompassModeMessage.Handler.class, SetCompassModeMessage.class, 19, Side.SERVER);
        INSTANCE.registerMessage(SendNameTagMessage.Handler.class, SendNameTagMessage.class, 20, Side.SERVER);
        INSTANCE.registerMessage(ClearMaidPosMessage.Handler.class, ClearMaidPosMessage.class, 21, Side.SERVER);
        INSTANCE.registerMessage(SetMaidRidingMessage.Handler.class, SetMaidRidingMessage.class, 22, Side.SERVER);
        INSTANCE.registerMessage(SetScarecrowDataMessage.Handler.class, SetScarecrowDataMessage.class, 23, Side.SERVER);
        INSTANCE.registerMessage(PortableAudioMessageToServer.Handler.class, PortableAudioMessageToServer.class, 24, Side.SERVER);
        INSTANCE.registerMessage(PortableAudioMessageToClient.Handler.class, PortableAudioMessageToClient.class, 25, Side.CLIENT);
        INSTANCE.registerMessage(UpdateMaidSleepYawMessage.Handler.class, UpdateMaidSleepYawMessage.class, 26, Side.CLIENT);
        INSTANCE.registerMessage(SyncClientPackMessage.Handler.class, SyncClientPackMessage.class, 27, Side.CLIENT);
        INSTANCE.registerMessage(GetServerPackMessage.Handler.class, GetServerPackMessage.class, 28, Side.SERVER);
        INSTANCE.registerMessage(SendClientPackMessage.Handler.class, SendClientPackMessage.class, 29, Side.CLIENT);
        INSTANCE.registerMessage(SendToClientDrawMessage.Handler.class, SendToClientDrawMessage.class, 30, Side.CLIENT);
        INSTANCE.registerMessage(SendToServerDrawMessage.Handler.class, SendToServerDrawMessage.class, 31, Side.SERVER);
        INSTANCE.registerMessage(WirelessIOGuiMessage.Handler.class, WirelessIOGuiMessage.class, 32, Side.SERVER);
        INSTANCE.registerMessage(WirelessIOSlotConfigMessage.Handler.class, WirelessIOSlotConfigMessage.class, 33, Side.SERVER);
        INSTANCE.registerMessage(SetBeaconOverflowMessage.Handler.class, SetBeaconOverflowMessage.class, 34, Side.SERVER);
        INSTANCE.registerMessage(MaidShowHelmetMessage.Handler.class, MaidShowHelmetMessage.class, 35, Side.SERVER);
        INSTANCE.registerMessage(PotionGuideIndexMessage.Handler.class, PotionGuideIndexMessage.class, 36, Side.SERVER);
    }

    public String translate(String key, Object ... format) {
        return I18n.func_74837_a((String)key, (Object[])format);
    }

    static {
        INSTANCE = null;
    }
}

