/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityMaidBeacon
extends TileEntity
implements ITickable {
    public static final String POTION_INDEX_TAG = "PotionIndex";
    public static final String STORAGE_POWER_TAG = "StoragePower";
    public static final String OVERFLOW_DELETE_TAG = "OverflowDelete";
    private int potionIndex = -1;
    private float storagePower;
    private boolean overflowDelete = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 80L == 0L) {
            if (this.potionIndex != -1 && this.storagePower >= this.getEffectCost()) {
                this.storagePower -= this.getEffectCost();
                this.updateBeaconEffect(Effect.getEffectByIndex(this.potionIndex).potion);
            }
            this.updateAbsorbPower();
        }
    }

    private void updateBeaconEffect(Potion potion) {
        List list = this.field_145850_b.func_72872_a(EntityMaid.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(8.0, 8.0, 8.0));
        for (EntityMaid maid : list) {
            if (!maid.func_70089_S()) continue;
            maid.func_70690_d(new PotionEffect(potion, 100, 1, true, true));
        }
    }

    private void updateAbsorbPower() {
        int range = GeneralConfig.MISC_CONFIG.shrineLampMaxRange;
        List list = this.field_145850_b.func_72872_a(EntityPowerPoint.class, new AxisAlignedBB(this.field_174879_c).func_72314_b((double)range, (double)range, (double)range));
        for (EntityPowerPoint powerPoint : list) {
            if (!powerPoint.func_70089_S()) continue;
            float addNum = this.getStoragePower() + (float)powerPoint.powerValue / 100.0f;
            if (addNum <= this.getMaxStorage()) {
                this.setStoragePower(addNum);
                powerPoint.spawnExplosionParticle();
                powerPoint.func_70106_y();
                continue;
            }
            if (!this.overflowDelete) continue;
            powerPoint.spawnExplosionParticle();
            powerPoint.func_70106_y();
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189515_b(new NBTTagCompound()));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readBeaconNBT(this.getTileData());
    }

    public void readBeaconNBT(NBTTagCompound compound) {
        if (compound.func_74764_b(POTION_INDEX_TAG)) {
            this.potionIndex = compound.func_74762_e(POTION_INDEX_TAG);
        }
        if (compound.func_74764_b(STORAGE_POWER_TAG)) {
            this.storagePower = compound.func_74760_g(STORAGE_POWER_TAG);
        }
        if (compound.func_74764_b(OVERFLOW_DELETE_TAG)) {
            this.overflowDelete = compound.func_74767_n(OVERFLOW_DELETE_TAG);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeBeaconNBT(this.getTileData());
        return super.func_189515_b(compound);
    }

    public NBTTagCompound writeBeaconNBT(NBTTagCompound compound) {
        compound.func_74768_a(POTION_INDEX_TAG, this.potionIndex);
        compound.func_74776_a(STORAGE_POWER_TAG, this.storagePower);
        compound.func_74757_a(OVERFLOW_DELETE_TAG, this.overflowDelete);
        return compound;
    }

    public int getPotionIndex() {
        return this.potionIndex;
    }

    public void setPotionIndex(int potionIndex) {
        this.potionIndex = potionIndex;
        this.func_70296_d();
    }

    public float getStoragePower() {
        return this.storagePower;
    }

    public void setStoragePower(float storagePower) {
        this.storagePower = storagePower;
        this.func_70296_d();
    }

    public boolean isOverflowDelete() {
        return this.overflowDelete;
    }

    public void setOverflowDelete(boolean overflowDelete) {
        this.overflowDelete = overflowDelete;
        this.func_70296_d();
    }

    public float getEffectCost() {
        return (float)(GeneralConfig.MISC_CONFIG.shrineLampEffectCost / 900.0);
    }

    public float getMaxStorage() {
        return (float)GeneralConfig.MISC_CONFIG.shrineLampMaxStorage;
    }

    public static enum Effect {
        SPEED(MobEffects.field_76424_c),
        FIRE_RESISTANCE(MobEffects.field_76426_n),
        STRENGTH(MobEffects.field_76420_g),
        RESISTANCE(MobEffects.field_76429_m),
        REGENERATION(MobEffects.field_76428_l);

        public static final Effect[] VALUES;
        private final Potion potion;

        private Effect(Potion potion) {
            this.potion = potion;
        }

        public static Effect getEffectByIndex(int index) {
            for (Effect effect : VALUES) {
                if (index != effect.ordinal()) continue;
                return effect;
            }
            return SPEED;
        }

        static {
            VALUES = Effect.values();
        }
    }
}

