/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMaidJoy
extends TileEntity {
    private static final String TYPE = "MaidJoyBlockType";
    private static final String CORE_BLOCK_TAG = "CoreBlock";
    private static final String CORE_BLOCK_POS_TAG = "CoreBlockPos";
    private static final String ALL_BLOCKS_TAG = "AllBlocks";
    private String type = "reading";
    private boolean isCoreBlock = false;
    private BlockPos coreBlockPos = BlockPos.field_177992_a;
    private List<BlockPos> allBlocks = Lists.newArrayList();

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189515_b(new NBTTagCompound()));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.type = compound.func_74779_i(TYPE);
        this.isCoreBlock = compound.func_74767_n(CORE_BLOCK_TAG);
        this.coreBlockPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(CORE_BLOCK_POS_TAG));
        this.allBlocks.clear();
        NBTTagList blockList = compound.func_150295_c(ALL_BLOCKS_TAG, 10);
        for (int i = 0; i < blockList.func_74745_c(); ++i) {
            this.allBlocks.add(NBTUtil.func_186861_c((NBTTagCompound)blockList.func_150305_b(i)));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a(TYPE, this.type);
        compound.func_74757_a(CORE_BLOCK_TAG, this.isCoreBlock);
        compound.func_74782_a(CORE_BLOCK_POS_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.coreBlockPos));
        NBTTagList blockList = new NBTTagList();
        for (BlockPos pos : this.allBlocks) {
            blockList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a(ALL_BLOCKS_TAG, (NBTBase)blockList);
        return super.func_189515_b(compound);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    public void setForgeData(String type, boolean isCoreBlock, BlockPos coreBlockPos, List<BlockPos> allBlocks) {
        this.type = type;
        this.isCoreBlock = isCoreBlock;
        this.coreBlockPos = coreBlockPos;
        this.allBlocks = allBlocks;
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public BlockPos getCoreBlockPos() {
        return this.coreBlockPos;
    }

    public List<BlockPos> getAllBlocks() {
        return this.allBlocks;
    }
}

