/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class TileEntityStatue
extends TileEntity {
    private static final String STATUE_SIZE_TAG = "StatueSize";
    private static final String CORE_BLOCK_TAG = "CoreBlock";
    private static final String CORE_BLOCK_POS_TAG = "CoreBlockPos";
    private static final String STATUE_FACING_TAG = "StatueFacing";
    private static final String ALL_BLOCKS_TAG = "AllBlocks";
    private static final String EXTRA_MAID_DATA = "ExtraMaidData";
    private Size size = Size.SMALL;
    private boolean isCoreBlock = false;
    private BlockPos coreBlockPos = BlockPos.field_177992_a;
    private EnumFacing facing = EnumFacing.NORTH;
    private List<BlockPos> allBlocks = Lists.newArrayList();
    @Nullable
    private NBTTagCompound extraMaidData = null;

    public void setForgeData(Size size, boolean isCoreBlock, BlockPos coreBlockPos, EnumFacing facing, List<BlockPos> allBlocks, @Nullable NBTTagCompound extraData) {
        this.size = size;
        this.isCoreBlock = isCoreBlock;
        this.coreBlockPos = coreBlockPos;
        this.facing = facing;
        this.allBlocks = allBlocks;
        this.extraMaidData = extraData;
        this.refresh();
    }

    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        this.getTileData().func_74768_a(STATUE_SIZE_TAG, this.size.ordinal());
        this.getTileData().func_74757_a(CORE_BLOCK_TAG, this.isCoreBlock);
        this.getTileData().func_74782_a(CORE_BLOCK_POS_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.coreBlockPos));
        this.getTileData().func_74768_a(STATUE_FACING_TAG, this.facing.func_176736_b());
        NBTTagList blockList = new NBTTagList();
        for (BlockPos pos : this.allBlocks) {
            blockList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        this.getTileData().func_74782_a(ALL_BLOCKS_TAG, (NBTBase)blockList);
        if (this.extraMaidData != null) {
            this.getTileData().func_74782_a(EXTRA_MAID_DATA, (NBTBase)this.extraMaidData);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.size = Size.getSizeByIndex(this.getTileData().func_74762_e(STATUE_SIZE_TAG));
        this.isCoreBlock = this.getTileData().func_74767_n(CORE_BLOCK_TAG);
        this.coreBlockPos = NBTUtil.func_186861_c((NBTTagCompound)this.getTileData().func_74775_l(CORE_BLOCK_POS_TAG));
        this.facing = EnumFacing.func_176731_b((int)this.getTileData().func_74762_e(STATUE_FACING_TAG));
        this.allBlocks.clear();
        NBTTagList blockList = this.getTileData().func_150295_c(ALL_BLOCKS_TAG, 10);
        for (int i = 0; i < blockList.func_74745_c(); ++i) {
            this.allBlocks.add(NBTUtil.func_186861_c((NBTTagCompound)blockList.func_150305_b(i)));
        }
        if (this.getTileData().func_150297_b(EXTRA_MAID_DATA, 10)) {
            this.extraMaidData = this.getTileData().func_74775_l(EXTRA_MAID_DATA);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -1, -5), this.field_174879_c.func_177982_a(5, 10, 5));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public Size getSize() {
        return this.size;
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public BlockPos getCoreBlockPos() {
        return this.coreBlockPos;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public List<BlockPos> getAllBlocks() {
        return this.allBlocks;
    }

    @Nullable
    public NBTTagCompound getExtraMaidData() {
        return this.extraMaidData;
    }

    public static enum Size {
        TINY(0.5f, new Vec3i(1, 1, 1)),
        SMALL(1.0f, new Vec3i(1, 2, 1)),
        MIDDLE(2.0f, new Vec3i(2, 4, 2)),
        BIG(3.0f, new Vec3i(3, 6, 3));

        private final float scale;
        private final Vec3i dimension;

        private Size(float scale, Vec3i dimension) {
            this.scale = scale;
            this.dimension = dimension;
        }

        public static Size getSizeByIndex(int index) {
            return Size.values()[MathHelper.func_76125_a((int)index, (int)0, (int)(Size.values().length - 1))];
        }

        public float getScale() {
            return this.scale;
        }

        public Vec3i getDimension() {
            return this.dimension;
        }
    }
}

