/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.client.event.BakeModelEvent;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ItemRenderRegisterUtils {
    private ItemRenderRegisterUtils() {
    }

    public static ModelResourceLocation getModelRl(Item item, int textureIndex) {
        return new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()) + "_" + textureIndex);
    }

    public static ModelResourceLocation getModelRl(String namespace, String path) {
        return new ModelResourceLocation(new ResourceLocation(namespace, path), null);
    }

    public static ModelResourceLocation getModelRl(Item item) {
        return ItemRenderRegisterUtils.getModelRl(item, null);
    }

    public static ModelResourceLocation getModelRl(Item item, String variant) {
        return new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), variant);
    }

    public static void registerRender(Block block) {
        ItemRenderRegisterUtils.registerRender(Item.func_150898_a((Block)block));
    }

    public static void registerRender(Item item) {
        ItemRenderRegisterUtils.registerRender(item, 0);
    }

    public static void registerRender(Item item, int meta) {
        ItemRenderRegisterUtils.registerRender(item, meta, "inventory");
    }

    public static void registerRender(Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemRenderRegisterUtils.getModelRl(item, variant));
    }

    public static void registerReplaceRender(Item item, ModelResourceLocation rawModel, ModelResourceLocation replaceModel, Supplier<Boolean> isReplace) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)rawModel);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{replaceModel});
        BakeModelEvent.addReplaceableModel(rawModel, replaceModel, isReplace);
    }

    public static void register2d3dRender(Item item) {
        ModelResourceLocation model2d = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()) + "_2d");
        ModelResourceLocation model3d = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()) + "_3d");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)model2d);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{model3d});
        BakeModelEvent.addPerspectiveModel(model2d, model3d);
    }
}

