/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Cylinder;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public final class RenderHelper {
    public static int SPHERE_OUT_INDEX;
    public static int SPHERE_IN_INDEX;
    public static int SPHERE_LINE;
    public static int CYLINDER_OUT_INDEX;
    public static int CYLINDER_IN_INDEX;

    private RenderHelper() {
    }

    private static void genSphere() {
        Sphere sphere = new Sphere();
        sphere.setDrawStyle(100012);
        sphere.setNormals(100000);
        sphere.setOrientation(100020);
        SPHERE_OUT_INDEX = GlStateManager.func_187442_t((int)1);
        GlStateManager.func_187423_f((int)SPHERE_OUT_INDEX, (int)4864);
        sphere.draw(1.0f, 10, 10);
        GlStateManager.func_187415_K();
        sphere.setOrientation(100021);
        SPHERE_IN_INDEX = GlStateManager.func_187442_t((int)1);
        GlStateManager.func_187423_f((int)SPHERE_IN_INDEX, (int)4864);
        sphere.draw(1.0f, 10, 10);
        GlStateManager.func_187415_K();
    }

    private static void gen() {
    }

    private static void genCylinder() {
        Cylinder cylinder = new Cylinder();
        cylinder.setDrawStyle(100012);
        cylinder.setNormals(100000);
        cylinder.setOrientation(100020);
        CYLINDER_OUT_INDEX = GlStateManager.func_187442_t((int)1);
        GlStateManager.func_187423_f((int)CYLINDER_OUT_INDEX, (int)4864);
        cylinder.draw(1.0f, 1.0f, 1.0f, 16, 16);
        GlStateManager.func_187415_K();
        cylinder.setOrientation(100021);
        CYLINDER_IN_INDEX = GlStateManager.func_187442_t((int)1);
        GlStateManager.func_187423_f((int)CYLINDER_IN_INDEX, (int)4864);
        cylinder.draw(1.0f, 1.0f, 1.0f, 16, 16);
        GlStateManager.func_187415_K();
    }

    private static void genSphereLine() {
        Sphere sphere = new Sphere();
        sphere.setDrawStyle(100011);
        sphere.setNormals(100000);
        sphere.setOrientation(100020);
        SPHERE_LINE = GlStateManager.func_187442_t((int)1);
        GlStateManager.func_187423_f((int)SPHERE_LINE, (int)4864);
        sphere.draw(1.0f, 32, 32);
        GlStateManager.func_187415_K();
    }

    public static void drawSector(int x, int y, int r, double startAngle, double endAngle, int precision, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        double precisionAngle = Math.PI * 2 / (double)precision;
        for (int i = (int)(endAngle / precisionAngle); i >= (int)(startAngle / precisionAngle); --i) {
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos((double)i * precisionAngle), (double)y + (double)r * Math.sin((double)i * precisionAngle), 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircle(int x, int y, int r, int precision, int color) {
        RenderHelper.drawSector(x, y, r, 0.0, Math.PI * 2, precision, color);
    }

    public static void renderBackground(int x, int y, int width, int height) {
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        GuiUtils.drawGradientRect((int)300, (int)((x -= width) - 3), (int)((y -= height) - 4), (int)(x + width + 3), (int)(y - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y + height + 3), (int)(x + width + 3), (int)(y + height + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 4), (int)(y - 3), (int)(x - 3), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x + width + 3), (int)(y - 3), (int)(x + width + 4), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)300, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)borderColorEnd, (int)borderColorEnd);
    }

    static {
        RenderHelper.genSphere();
        RenderHelper.genCylinder();
        RenderHelper.genSphereLine();
    }
}

