/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.world;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="touhou_little_maid")
public class DungeonLootTable {
    private static final ResourceLocation POWER_POINT_LOOT = new ResourceLocation("touhou_little_maid", "power_point");
    private static final ResourceLocation SMART_SLAB_LOOT = new ResourceLocation("touhou_little_maid", "smart_slab");

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (event.getName().func_110623_a().startsWith("chests")) {
            LootPool powerPointPool = event.getLootTableManager().func_186521_a(POWER_POINT_LOOT).getPool("power_point");
            event.getTable().addPool(powerPointPool);
            if (GeneralConfig.MAID_CONFIG.spawnSlabInLootChest) {
                LootPool smartSlabPool = event.getLootTableManager().func_186521_a(SMART_SLAB_LOOT).getPool("smart_slab");
                event.getTable().addPool(smartSlabPool);
            }
        }
    }

    public static ResourceLocation getPowerPointLoot() {
        return POWER_POINT_LOOT;
    }

    public static ResourceLocation getSmartSlabLoot() {
        return SMART_SLAB_LOOT;
    }
}

