/*
 * Decompiled with CFR 0.152.
 */
package bullfighter.randomore;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.joml.Random;
import org.slf4j.Logger;

@Mod(value="randomore")
public class ExampleMod {
    public static final String MODID = "randomore";
    private static final Logger LOGGER = LogUtils.getLogger();
    public final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"randomore");
    public final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"randomore");
    public final DeferredBlock<Block> RANDOMOREBLOCK_RegistryObject = this.BLOCKS.register("random_ore", () -> new RandomOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public final DeferredItem<Item> RANDOMORE_RegistryObject = this.ITEMS.register("random_ore", () -> new BlockItem((Block)this.RANDOMOREBLOCK_RegistryObject.get(), new Item.Properties()));
    public final DeferredBlock<Block> DEEPSLATERANDOMOREBLOCK_RegistryObject = this.BLOCKS.register("deepslate_random_ore", () -> new RandomOreBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)this.RANDOMOREBLOCK_RegistryObject.get())).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE)));
    public final DeferredItem<Item> DEEPSLATERANDOMORE_RegistryObject = this.ITEMS.register("deepslate_random_ore", () -> new BlockItem((Block)this.DEEPSLATERANDOMOREBLOCK_RegistryObject.get(), new Item.Properties()));

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public ExampleMod(IEventBus modEventBus) {
        this.BLOCKS.register(modEventBus);
        this.ITEMS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private static int getEnchantmentLevel(ResourceKey<Enchantment> enchantment, ItemStack tool) {
        Set enchantments = tool.getEnchantments().keySet();
        for (Holder enchantmentIterator : enchantments) {
            if (enchantmentIterator.unwrapKey().get() != enchantment) continue;
            return EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentIterator, (ItemStack)tool);
        }
        return 0;
    }

    public Item getRandomOreDrop() {
        RandomSource random = RandomSource.create();
        Optional whitelist = BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"randomore_whitelist")));
        if (whitelist.isPresent() && ((HolderSet.Named)whitelist.get()).size() > 0) {
            return (Item)((Holder)((HolderSet.Named)whitelist.get()).getRandomElement(random).get()).value();
        }
        Optional blacklist = BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"randomore_blacklist")));
        if (blacklist.isPresent() && ((HolderSet.Named)blacklist.get()).size() > 0) {
            List<Holder.Reference> itemlist = BuiltInRegistries.ITEM.holders().filter(f -> !((HolderSet.Named)blacklist.get()).contains((Holder)f)).toList();
            return (Item)itemlist.get(new Random().nextInt(itemlist.size())).value();
        }
        return (Item)((Holder.Reference)BuiltInRegistries.ITEM.getRandom(random).get()).value();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.accept(this.RANDOMORE_RegistryObject);
            event.accept(this.DEEPSLATERANDOMORE_RegistryObject);
        }
    }

    public class RandomOreBlock
    extends Block {
        public RandomOreBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean popExperience) {
            if (ExampleMod.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, tool) == 0) {
                this.popExperience(world, pos, new Random().nextInt(11));
                int fortune = new Random().nextInt(ExampleMod.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.FORTUNE, tool) + 1) + 1;
                try {
                    for (int r = 0; r < fortune; ++r) {
                        ItemStack randomItemStack;
                        Item randomItem = ExampleMod.this.getRandomOreDrop();
                        if (randomItem == Items.POTION || randomItem == Items.SPLASH_POTION || randomItem == Items.LINGERING_POTION || randomItem == Items.TIPPED_ARROW) {
                            Potion randomPotion = (Potion)((Holder.Reference)BuiltInRegistries.POTION.getRandom(RandomSource.create()).get()).value();
                            randomItemStack = PotionContents.createItemStack((Item)randomItem, (Holder)BuiltInRegistries.POTION.wrapAsHolder((Object)randomPotion));
                        } else {
                            randomItemStack = randomItem == Items.ENCHANTED_BOOK ? EnchantmentHelper.enchantItem((RandomSource)RandomSource.create(), (ItemStack)new ItemStack((ItemLike)Items.BOOK), (int)new Random().nextInt(31), (Stream)HolderSet.direct(world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().toList()).stream()) : new ItemStack((ItemLike)randomItem);
                        }
                        world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, randomItemStack));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error on getting drop from random ore!");
                }
            } else {
                world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)state.getBlock())));
            }
        }
    }
}

