/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.the_mangle.entities.goals;

import de.cadentem.the_mangle.entities.TheMangleEntity;
import de.cadentem.the_mangle.entities.goals.Roll;
import de.cadentem.the_mangle.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class TheMangleStareGoal
extends Goal {
    private final TheMangleEntity theMangle;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public TheMangleStareGoal(TheMangleEntity theMangle) {
        this.theMangle = theMangle;
        this.lookedAtMax = theMangle.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.theMangle.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.theMangle.m_5448_())) {
            return false;
        }
        return this.theMangle.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.theMangle.m_5448_())) {
            return false;
        }
        return this.theMangle.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.theMangle.pleaseStopMoving = false;
        this.theMangle.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.theMangle.m_5448_();
        if (target == null) {
            this.theMangle.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.theMangle.targetIsFacingMe && target.m_142582_((Entity)this.theMangle);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.theMangle.m_217043_().m_188500_() < 0.1) {
                this.theMangle.disappear();
            } else if (this.theMangle.m_217043_().m_188500_() < 0.3) {
                this.theMangle.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.theMangle.pleaseStopMoving = false;
            this.theMangle.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.theMangle.pleaseStopMoving = true;
            this.theMangle.m_21573_().m_26573_();
            this.theMangle.m_20256_(Vec3.f_82478_);
        }
        this.theMangle.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

