/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.block.component.ParticleDropBlockComponent;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockUndeadLeavesConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;

public class BlockUndeadLeaves
extends LeavesBlock {
    private ParticleDropBlockComponent particleDropBlockComponent;

    public BlockUndeadLeaves(BlockBehaviour.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            this.particleDropBlockComponent = new ParticleDropBlockComponent(1.0f, 0.0f, 0.0f);
            this.particleDropBlockComponent.setOffset(0);
            this.particleDropBlockComponent.setChance(50);
        }
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        this.particleDropBlockComponent.randomDisplayTick(stateIn, worldIn, pos, rand);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this);
    }

    protected boolean canFormBloodStains(BlockState state) {
        return BlockUndeadLeavesConfig.maxBloodStainAmount > 0 && (Boolean)state.getValue((Property)PERSISTENT) == false && (Integer)state.getValue((Property)DISTANCE) == 2;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) || this.canFormBloodStains(state);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.randomTick(state, worldIn, pos, random);
        if (this.canFormBloodStains(state)) {
            int attempts = 20;
            BlockPos itPos = pos.relative(Direction.DOWN);
            while (attempts-- > 0) {
                if (worldIn.getBlockState(itPos).getBlock() instanceof BlockBloodStain || worldIn.isEmptyBlock(itPos) && ((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState().canSurvive((LevelReader)worldIn, itPos)) {
                    BlockState blockState = worldIn.getBlockState(itPos);
                    if (worldIn.isEmptyBlock(itPos)) {
                        blockState = ((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState();
                        worldIn.setBlockAndUpdate(itPos, blockState);
                    }
                    if (!(blockState.getBlock() instanceof BlockBloodStain)) break;
                    BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)itPos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(1 + worldIn.random.nextInt(BlockUndeadLeavesConfig.maxBloodStainAmount)));
                    break;
                }
                if (!worldIn.isEmptyBlock(itPos)) break;
                itPos = itPos.relative(Direction.DOWN);
            }
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }
}

