/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import net.minecraft.core.Holder;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.item.ItemVengeancePickaxe;

public class ToolBadEnchantPurifyAction
implements IPurifierAction {
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canWork(BlockEntityPurifier tile) {
        Wrapper<Boolean> done = new Wrapper<Boolean>(false);
        if (!tile.getPurifyItem().isEmpty() && tile.getBucketsFloored() > 0) {
            ItemStack purifyItem = tile.getPurifyItem();
            EnchantmentHelpers.runIterationOnItem((ItemStack)purifyItem, (enchantment, level) -> {
                if (enchantment.is(EnchantmentTags.CURSE) && !(purifyItem.getItem() instanceof ItemVengeancePickaxe)) {
                    done.set(true);
                }
            });
        }
        return done.get();
    }

    protected boolean removeEnchant(Level world, BlockEntityPurifier tile, ItemStack purifyItem, int tick, Holder<Enchantment> enchant, int level) {
        if (tick >= 60) {
            if (!world.isClientSide()) {
                EnchantmentHelpers.setEnchantmentLevel((ItemStack)purifyItem, enchant, (int)(level - 1));
            }
            tile.setBuckets(tile.getBucketsFloored() - 1, tile.getBucketsRest());
            return true;
        }
        if (world.isClientSide()) {
            tile.showEffect();
        }
        return false;
    }

    @Override
    public boolean work(BlockEntityPurifier tile) {
        Wrapper<Boolean> done = new Wrapper<Boolean>(false);
        ItemStack purifyItem = tile.getPurifyItem();
        Level world = tile.getLevel();
        int tick = tile.getTick();
        EnchantmentHelpers.runIterationOnItem((ItemStack)purifyItem, (enchantment, level) -> {
            if (enchantment.is(EnchantmentTags.CURSE) && !(purifyItem.getItem() instanceof ItemVengeancePickaxe) && this.removeEnchant(world, tile, purifyItem, tick, (Holder<Enchantment>)enchantment, level)) {
                done.set(true);
            }
        });
        return done.get();
    }
}

