/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.RegistryEntries;

@OnlyIn(value=Dist.CLIENT)
public class ParticleBloodSplash
extends WaterDropParticle {
    public ParticleBloodSplash(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.gravity = 0.04f;
        if (ySpeedIn == 0.0 && (xSpeedIn != 0.0 || zSpeedIn != 0.0)) {
            this.xd = xSpeedIn;
            this.yd = 0.1;
            this.zd = zSpeedIn;
        }
    }

    public static void spawnParticles(Level world, BlockPos blockPos, int velocity, int amount) {
        RandomSource random = world.getRandom();
        for (int i = 0; i < amount; ++i) {
            float x_r = (float)blockPos.getX() + random.nextFloat();
            float y_r = (float)blockPos.getY() + random.nextFloat();
            float z_r = (float)blockPos.getZ() + random.nextFloat();
            Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_SPLASH.get(), false, (double)x_r, (double)y_r, (double)z_r, velocity == 0 ? 0.0 : (double)random.nextInt(velocity), velocity == 0 ? 0.0 : (double)random.nextInt(velocity), velocity == 0 ? 0.0 : (double)random.nextInt(velocity));
        }
    }
}

