/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class BlockEntityTankInventory
extends CyclopsBlockEntity {
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    protected final int tankSize;

    public BlockEntityTankInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize, int tankSize, @Nullable Fluid acceptedFluid) {
        super(type, blockPos, blockState);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.tank = this.createTank(tankSize);
        this.tankSize = tankSize;
        if (acceptedFluid != null) {
            this.tank.setAcceptedFluid(acceptedFluid);
        }
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize);
    }

    protected SingleUseTank createTank(int tankSize) {
        return new SingleUseTank(tankSize);
    }

    public void read(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        super.read(tag, holderLookupProvider);
        this.inventory.readFromNBT(holderLookupProvider, tag, "inventory");
        this.tank.readFromNBT(holderLookupProvider, tag, "tank");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.inventory.writeToNBT(holderLookupProvider, tag, "inventory");
        this.tank.writeToNBT(holderLookupProvider, tag, "tank");
        super.saveAdditional(tag, holderLookupProvider);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void onTankChanged() {
        this.setChanged();
        this.getInventory().setChanged();
    }

    public static class CapabilityRegistrar<T extends BlockEntityTankInventory>
    extends BlockEntityCapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.registerTankInventoryCapabilitiesItem();
            this.registerTankInventoryCapabilitiesFluid();
        }

        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> blockEntity.getInventory().getItemHandlerSided(direction));
        }

        public void registerTankInventoryCapabilitiesFluid() {
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> blockEntity.getTank());
        }
    }
}

