/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartModelBaked
extends DynamicItemAndBlockModel {
    private final Map<IBroomPart, BakedModel> broomPartModels = Maps.newHashMap();
    private final List<BakedQuad> quads;
    private final RandomSource rand = RandomSource.create();

    public BroomPartModelBaked() {
        super(true, false);
        this.quads = Collections.emptyList();
    }

    public BroomPartModelBaked(List<BakedQuad> quads) {
        super(false, true);
        this.quads = Objects.requireNonNull(quads);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.quads;
    }

    public void addBroomPartModel(IBroomPart part, BakedModel bakedModel) {
        this.broomPartModels.put(part, bakedModel);
    }

    public boolean usesBlockLight() {
        return true;
    }

    public BakedModel handleBlockState(@Nullable BlockState blockState, @Nullable Direction direction, @Nonnull RandomSource random, @Nonnull ModelData iModelData, @Nullable RenderType renderType) {
        throw new UnsupportedOperationException();
    }

    public BakedModel handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        Object part = BroomParts.REGISTRY.getPartFromItem(itemStack);
        BakedModel model = this.broomPartModels.get(part);
        if (model != null) {
            quads.addAll(this.color(model.getQuads(null, this.getRenderingSide(), this.rand), part.getModelColor()));
        }
        return new BroomPartModelBaked(quads);
    }

    private Collection<? extends BakedQuad> color(List<BakedQuad> quads, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.getVertices(), quad.getVertices().length);
            for (int i = 0; i < vertexData.length / 8; ++i) {
                vertexData[i * 8 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.getTintIndex(), quad.getDirection(), quad.getSprite(), false));
        }
        return offsetQuads;
    }

    public TextureAtlasSprite getParticleIcon() {
        return null;
    }

    public ItemTransforms getTransforms() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }
}

