/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.api.degradation.IDegradationEffect;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;

public class ParticleDegradation
implements IDegradationEffect {
    public ParticleDegradation(DegradationEffectConfig eConfig) {
    }

    @Override
    public boolean canRun(IDegradable degradable) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void runClientSide(IDegradable degradable) {
        BlockPos center = degradable.getLocation();
        Level world = degradable.getDegradationWorld();
        int radius = degradable.getRadius();
        double xCoord = (float)(center.getX() - radius) + (float)(2 * radius) * world.random.nextFloat();
        double yCoord = (float)(center.getY() - radius) + (float)(2 * radius) * world.random.nextFloat();
        double zCoord = (float)(center.getZ() - radius) + (float)(2 * radius) * world.random.nextFloat();
        double particleX = xCoord;
        double particleY = yCoord;
        double particleZ = zCoord;
        float particleMotionX = world.random.nextFloat() * 1.4f - 0.7f;
        float particleMotionY = -0.2f;
        float particleMotionZ = world.random.nextFloat() * 1.4f - 0.7f;
        Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)RegistryEntries.PARTICLE_DEGRADE.get(), false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
    }

    @Override
    public void runServerSide(IDegradable degradable) {
    }
}

