/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.inventory.container.ContainerInventoryTickingTank;

public abstract class ContainerTileWorking<T extends BlockEntityWorking<T, ?>>
extends ContainerInventoryTickingTank<T> {
    public ContainerTileWorking(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, Optional<T> tileSupplier, int tickers, int upgradeSlots) {
        super(type, id, playerInventory, inventory, tileSupplier, tickers);
        this.offsetX = 28;
    }

    public boolean isUpgradeSlotEnabled(int slot) {
        return this.getTileWorkingMetadata().isUpgradeSlotEnabled(this.inventory, this.getTileWorkingMetadata().getBasicInventorySize() + slot);
    }

    public abstract BlockEntityWorking.Metadata getTileWorkingMetadata();

    public void addUpgradeInventory(int offsetX, int offsetY, int slotStart) {
        int upgradeSlots = 4;
        int amount = 0;
        for (int i = slotStart; i < slotStart + upgradeSlots; ++i) {
            this.addSlot((Slot)new SlotExtended(this.inventory, i, offsetX, offsetY + amount * 18){
                private ItemStack lastSlotContents;
                {
                    this.lastSlotContents = this.getItem();
                }

                public boolean mayPlace(ItemStack itemStack) {
                    return super.mayPlace(itemStack) && ContainerTileWorking.this.getTileWorkingMetadata().canInsertItem(this.container, this.getSlotIndex(), itemStack);
                }

                public boolean mayPickup(Player playerIn) {
                    return super.mayPickup(ContainerTileWorking.this.player) && ContainerTileWorking.this.getTileWorkingMetadata().canExtractItem(this.container, this.getSlotIndex(), this.getItem(), ContainerTileWorking.this.getCarried());
                }

                public void setChanged() {
                    if (!ItemStack.matches((ItemStack)this.lastSlotContents, (ItemStack)this.getItem())) {
                        ContainerTileWorking.this.getTileSupplier().ifPresent(tile -> tile.onUpgradeSlotChanged(this.getSlotIndex(), this.lastSlotContents, this.getItem()));
                    }
                    this.lastSlotContents = this.getItem();
                    if (!this.lastSlotContents.isEmpty()) {
                        this.lastSlotContents = this.lastSlotContents.copy();
                    }
                }
            });
            ++amount;
        }
    }
}

