/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.algorithm.OrganicSpread;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.ItemBiomeExtract;
import org.cyclops.evilcraft.network.packet.ResetChunkColorsPacket;

public class EntityBiomeExtract
extends EntityThrowable {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK_INDEX = SynchedEntityData.defineId(EntityBiomeExtract.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public EntityBiomeExtract(EntityType<? extends EntityThrowable> type, Level world) {
        super(type, world);
    }

    public EntityBiomeExtract(Level world) {
        this((EntityType<? extends EntityThrowable>)((EntityType)RegistryEntries.ENTITY_BIOME_EXTRACT.get()), world);
    }

    public EntityBiomeExtract(Level world, LivingEntity entity) {
        this(world, entity, new ItemStack(RegistryEntries.ITEM_BIOME_EXTRACT));
    }

    public EntityBiomeExtract(Level world, LivingEntity entity, ItemStack stack) {
        super((EntityType<? extends EntityThrowable>)((EntityType)RegistryEntries.ENTITY_BIOME_EXTRACT.get()), world, entity);
        this.setItemStack(stack);
    }

    protected void onHit(final HitResult movingobjectposition) {
        if (!this.level().isClientSide() && movingobjectposition.getType() == HitResult.Type.BLOCK) {
            ItemStack itemStack = this.getItem();
            final Holder<Biome> biome = ItemBiomeExtract.getBiome(itemStack);
            if (biome != null) {
                final HashSet updatedChunks = Sets.newHashSet();
                OrganicSpread spread = new OrganicSpread(this.level(), 2, 5, new OrganicSpread.IOrganicSpreadable(){

                    @Override
                    public boolean isDone(Level world, BlockPos location) {
                        return world.getBiome(location).is(biome);
                    }

                    @Override
                    public void spreadTo(Level world, BlockPos location) {
                        EntityBiomeExtract.setBiome((ServerLevel)world, location, (Holder<Biome>)biome);
                        updatedChunks.add(new ChunkPos(location));
                        int color = ((Biome)biome.value()).getFoliageColor();
                        EntityBiomeExtract.this.showChangedBiome((ServerLevel)world, new BlockPos(location.getX(), ((BlockHitResult)movingobjectposition).getBlockPos().getY(), location.getZ()), color);
                    }
                });
                BlockPos pos = BlockPos.containing((Position)movingobjectposition.getLocation());
                for (int i = 0; i < 50; ++i) {
                    spread.spreadTick(pos);
                }
                if (!this.level().isClientSide()) {
                    for (ChunkPos chunkPos : updatedChunks) {
                        EntityBiomeExtract.updateChunkAfterBiomeChange(this.level(), chunkPos);
                    }
                }
            }
            this.level().globalLevelEvent(2002, this.blockPosition(), 16428);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void setBiome(ServerLevel world, BlockPos posIn, Holder<Biome> biome) {
        BiomeManager biomeManager = world.getBiomeManager();
        int i = posIn.getX() - 2;
        int j = posIn.getY() - 2;
        int k = posIn.getZ() - 2;
        int l = i >> 2;
        int i1 = j >> 2;
        int j1 = k >> 2;
        double d0 = (double)(i & 3) / 4.0;
        double d1 = (double)(j & 3) / 4.0;
        double d2 = (double)(k & 3) / 4.0;
        int k1 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        for (int l1 = 0; l1 < 8; ++l1) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int k2;
            boolean flag1;
            int j2;
            boolean flag = (l1 & 4) == 0;
            int i2 = flag ? l : l + 1;
            double d7 = BiomeManager.getFiddledDistance((long)biomeManager.biomeZoomSeed, (int)i2, (int)(j2 = (flag1 = (l1 & 2) == 0) ? i1 : i1 + 1), (int)(k2 = (flag2 = (l1 & 1) == 0) ? j1 : j1 + 1), (double)(d4 = flag ? d0 : d0 - 1.0), (double)(d5 = flag1 ? d1 : d1 - 1.0), (double)(d6 = flag2 ? d2 : d2 - 1.0));
            if (!(d3 > d7)) continue;
            k1 = l1;
            d3 = d7;
        }
        int l2 = (k1 & 4) == 0 ? l : l + 1;
        int i3 = (k1 & 2) == 0 ? i1 : i1 + 1;
        int j3 = (k1 & 1) == 0 ? j1 : j1 + 1;
        ChunkAccess chunk = world.getChunk(QuartPos.toSection((int)l2), QuartPos.toSection((int)j3), ChunkStatus.BIOMES, false);
        if (chunk instanceof ImposterProtoChunk) {
            chunk = ((ImposterProtoChunk)chunk).getWrapped();
        }
        if (chunk != null) {
            int minBuildHeight = QuartPos.fromBlock((int)chunk.getMinBuildHeight());
            int maxHeight = minBuildHeight + QuartPos.fromBlock((int)chunk.getHeight()) - 1;
            int dummyY = Mth.clamp((int)i3, (int)minBuildHeight, (int)maxHeight);
            int sectionIndex = chunk.getSectionIndex(QuartPos.toBlock((int)dummyY));
            ((PalettedContainer)chunk.sections[sectionIndex].getBiomes()).set(l2 & 3, dummyY & 3, j3 & 3, biome);
            chunk.setUnsaved(true);
        } else {
            CyclopsCore.clog((org.apache.logging.log4j.Level)org.apache.logging.log4j.Level.WARN, (String)("Tried changing biome at non-existing chunk for position " + String.valueOf(posIn)));
        }
    }

    public static void updateChunkAfterBiomeChange(Level world, ChunkPos chunkPos) {
        LevelChunk chunkSafe = world.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
        ((ServerChunkCache)world.getChunkSource()).chunkMap.getPlayers(chunkPos, false).forEach(player -> {
            player.connection.send((Packet)new ClientboundLevelChunkWithLightPacket(chunkSafe, (LevelLightEngine)((ServerChunkCache)world.getChunkSource()).chunkMap.getLightEngine(), null, null));
            EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new ResetChunkColorsPacket(chunkPos.x, chunkPos.z), player);
        });
    }

    private void showChangedBiome(ServerLevel world, BlockPos pos, int color) {
        Triple c = Helpers.intToRGB((int)color);
        RandomSource rand = world.random;
        for (int j = 0; j < 2 + rand.nextInt(5); ++j) {
            float x = (float)pos.getX() + -0.5f + rand.nextFloat();
            float y = (float)pos.getY() + -0.5f + rand.nextFloat();
            float z = (float)pos.getZ() + -0.5f + rand.nextFloat();
            float scale = 0.2f - rand.nextFloat() * 0.2f;
            float red = ((Float)c.getLeft()).floatValue() + rand.nextFloat() * 0.1f;
            float green = ((Float)c.getMiddle()).floatValue() + rand.nextFloat() * 0.1f;
            float blue = ((Float)c.getRight()).floatValue() + rand.nextFloat() * 0.1f;
            float ageMultiplier = 10 + rand.nextInt(15);
            double motionX = -0.1f + rand.nextFloat() * 0.2f;
            double motionY = 0.1f + rand.nextFloat() * 0.2f;
            double motionZ = -0.1f + rand.nextFloat() * 0.2f;
            world.sendParticles((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), (double)x, (double)y, (double)z, 1, motionX, motionY, motionZ, 0.1);
        }
    }

    protected double getDefaultGravity() {
        return 0.1;
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEMSTACK_INDEX);
    }

    private void setItemStack(ItemStack stack) {
        this.entityData.set(ITEMSTACK_INDEX, (Object)stack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEMSTACK_INDEX, (Object)new ItemStack(RegistryEntries.ITEM_BIOME_EXTRACT));
    }
}

