/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.event.RenderOverlayEventHook;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class ItemBroom
extends ItemBloodContainer
implements IBroom {
    protected static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/overlay.png");
    private static final float Y_SPAWN_OFFSET = 1.5f;

    public ItemBroom(Item.Properties properties) {
        super(properties, 10000);
        if (MinecraftHelpers.isClientSide()) {
            NeoForge.EVENT_BUS.addListener(this::onFovEvent);
            NeoForge.EVENT_BUS.addListener(this::onRenderOverlayEvent);
        }
    }

    @Override
    public boolean isPlaceFluids() {
        return false;
    }

    @Override
    public boolean isPickupFluids() {
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide() && player.getVehicle() == null && !player.isCrouching()) {
            player.setPos(player.getX(), player.getY() + 1.5, player.getZ());
            EntityBroom entityBroom = new EntityBroom(world, player.getX(), player.getY(), player.getZ());
            entityBroom.setBroomStack(stack);
            entityBroom.setYRot(player.getYRot());
            world.addFreshEntity((Entity)entityBroom);
            player.startRiding((Entity)entityBroom);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return MinecraftHelpers.successAction((Object)stack);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!context.getLevel().isClientSide() && context.getPlayer().isCrouching()) {
            BlockPos blockPos = context.getClickedPos();
            if (!BlockEntityHelpers.getCapability((ILevelExtension)context.getLevel(), (BlockPos)blockPos, (Object)context.getClickedFace(), (BlockCapability)Capabilities.FluidHandler.BLOCK).isPresent() && context.getLevel().isEmptyBlock(blockPos.offset(0, 1, 0))) {
                EntityBroom entityBroom = new EntityBroom(context.getLevel(), (double)blockPos.getX() + 0.5, (float)blockPos.getY() + 1.5f, (double)blockPos.getZ() + 0.5);
                entityBroom.setBroomStack(stack);
                entityBroom.setYRot(context.getPlayer().getYRot());
                context.getLevel().addFreshEntity((Entity)entityBroom);
                if (!context.getPlayer().isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack itemStack) {
        return BroomParts.REGISTRY.getBroomParts(itemStack);
    }

    @Override
    public Map<BroomModifier, Float> getBroomModifiers(ItemStack itemStack) {
        return BroomModifiers.REGISTRY.getModifiers(itemStack);
    }

    @Override
    public boolean canConsumeBroomEnergy(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return this.canConsume(amount, itemStack, entityLiving instanceof Player ? (Player)entityLiving : null);
    }

    @Override
    public int consumeBroom(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return FluidHelpers.getAmount((FluidStack)this.consume(amount, itemStack, entityLiving instanceof Player ? (Player)entityLiving : null));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        if (MinecraftHelpers.isShifted()) {
            list.add((Component)Component.translatable((String)"broom.parts.evilcraft.types").withStyle(ChatFormatting.ITALIC));
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(itemStack);
            Map<BroomModifier, Float> modifiers = this.getBroomModifiers(itemStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(baseModifiers.keySet());
            modifierTypes.addAll(modifiers.keySet());
            for (IBroomPart part : this.getBroomParts(itemStack)) {
                Component line = part.getTooltipLine("  ");
                if (line == null) continue;
                list.add(line);
            }
            Pair<Integer, Integer> modifiersAndMax = this.getModifiersAndMax(modifiers, baseModifiers);
            int modifierCount = (Integer)modifiersAndMax.getLeft();
            int maxModifiers = (Integer)modifiersAndMax.getRight();
            list.add((Component)Component.translatable((String)"broom.modifiers.evilcraft.types.nameparam", (Object[])new Object[]{modifierCount, maxModifiers}).withStyle(ChatFormatting.ITALIC));
            for (BroomModifier modifier : modifierTypes) {
                if (!modifier.showTooltip()) continue;
                Float value = modifiers.get(modifier);
                Float baseValue = baseModifiers.get(modifier);
                list.add(modifier.getTooltipLine("  ", value == null ? 0.0f : value.floatValue(), baseValue == null ? 0.0f : baseValue.floatValue()));
            }
        } else {
            list.add((Component)Component.translatable((String)"broom.evilcraft.shiftinfo").withStyle(ChatFormatting.ITALIC));
        }
    }

    private Pair<Integer, Integer> getModifiersAndMax(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        return Pair.of((Object)modifiers, (Object)maxModifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onFovEvent(ComputeFovModifierEvent event) {
        if (event.getPlayer().getVehicle() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)event.getPlayer().getVehicle();
            double speed = broom.getLastPlayerSpeed();
            event.setNewFovModifier((float)((double)event.getNewFovModifier() + speed / 10.0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRenderOverlayEvent(RenderGuiEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getVehicle() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)player.getVehicle();
            ItemStack broomStack = broom.getBroomStack();
            Window resolution = Minecraft.getInstance().getWindow();
            int height = 21;
            int width = 21;
            RenderOverlayEventHook.OverlayPosition overlayPosition = RenderOverlayEventHook.OverlayPosition.values()[Mth.clamp((int)ItemBroomConfig.guiOverlayPosition, (int)0, (int)(RenderOverlayEventHook.OverlayPosition.values().length - 1))];
            int x = overlayPosition.getX(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetX;
            int y = overlayPosition.getY(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetY;
            event.getGuiGraphics().pose().pushPose();
            GlStateManager._enableBlend();
            GlStateManager._blendFunc((int)770, (int)771);
            event.getGuiGraphics().blit(OVERLAY, x, y, 11, 0, 24, 24);
            Lighting.setupFor3DItems();
            event.getGuiGraphics().renderItem(broomStack, x + 3, y + 3);
            event.getGuiGraphics().renderItemDecorations(Minecraft.getInstance().gui.getFont(), broomStack, x + 3, y + 3, "");
            Lighting.setupForFlatItems();
            GlStateManager._disableBlend();
            event.getGuiGraphics().pose().popPose();
        }
    }
}

