/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedEntityData;
import org.cyclops.evilcraft.client.particle.ParticleDistortData;
import org.cyclops.evilcraft.client.particle.ParticleExplosionExtendedData;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public abstract class ItemMace
extends ItemBloodContainer {
    private final int hitUsage;
    private final int maximumCharge;
    private final int powerLevels;
    private final float meleeDamage;

    public ItemMace(Item.Properties builder, int containerSize, int hitUsage, int maximumCharge, int powerLevels, float meleeDamage) {
        super(builder, containerSize);
        this.hitUsage = hitUsage;
        this.maximumCharge = maximumCharge;
        this.powerLevels = powerLevels;
        this.meleeDamage = meleeDamage;
    }

    protected boolean isUsable(ItemStack itemStack, Player player) {
        return this.canConsume(1, itemStack, player);
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity attacked, LivingEntity attacker) {
        if (attacker instanceof Player && this.isUsable(itemStack, (Player)attacker)) {
            ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElseGet(null)).drain(this.hitUsage, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, Player player, Entity entity) {
        return !this.isUsable(itemStack, player);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return this.maximumCharge * (this.powerLevels - this.getPower(itemStack));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, this.powerLevels, true)) {
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        if (this.isUsable(itemStack, player)) {
            player.startUsingItem(hand);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        if (world.isClientSide()) {
            this.animateOutOfEnergy(world, (LivingEntity)player);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack itemStack, int duration) {
        Level world = player.level();
        if (world.isClientSide() && duration % 2 == 0) {
            this.showUsingItemTick(world, itemStack, player, duration);
        }
        super.onUseTick(level, player, itemStack, duration);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showUsingItemTick(Level world, ItemStack itemStack, LivingEntity entity, int duration) {
        int itemUsedCount = this.getUseDuration(itemStack, entity) - duration;
        double area = this.getArea(itemUsedCount);
        int points = (int)Math.pow(area, 0.55) * 2 + 1;
        int particleChance = 5 * (this.powerLevels - this.getPower(itemStack));
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            for (double pointHeight = (double)(-points); pointHeight <= (double)points; pointHeight += 0.5) {
                if (world.random.nextInt(particleChance) != 0) continue;
                double u = Math.PI * (point / (double)points);
                double v = Math.PI * -2 * (pointHeight / (double)points);
                double xOffset = Math.cos(u) * Math.sin(v) * area;
                double yOffset = Math.sin(u) * area;
                double zOffset = Math.cos(v) * area;
                double xCoord = entity.getX();
                double yCoord = entity.getY() + (double)entity.getEyeHeight() - (Minecraft.getInstance().player == entity ? 0.5 : 1.5);
                double zCoord = entity.getZ();
                double particleX = xCoord + xOffset - (double)world.random.nextFloat() * area / 4.0 - 0.5;
                double particleY = yCoord + yOffset - (double)world.random.nextFloat() * area / 4.0 - 0.5;
                double particleZ = zCoord + zOffset - (double)world.random.nextFloat() * area / 4.0 - 0.5;
                float particleMotionX = (float)(xOffset * 10.0);
                float particleMotionY = (float)(yOffset * 10.0);
                float particleMotionZ = (float)(zOffset * 10.0);
                Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleDistortData((float)area * 3.0f), false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
                if (world.random.nextInt(10) != 0) continue;
                int spread = 10;
                float scale2 = 0.3f - world.random.nextFloat() * 0.2f;
                float r = 1.0f * world.random.nextFloat();
                float g = 0.2f + 0.01f * world.random.nextFloat();
                float b = 0.1f + 0.5f * world.random.nextFloat();
                float ageMultiplier2 = 20.0f;
                double motionX = (double)spread - world.random.nextDouble() * 2.0 * (double)spread;
                double motionY = (double)spread - world.random.nextDouble() * 2.0 * (double)spread;
                double motionZ = (double)spread - world.random.nextDouble() * 2.0 * (double)spread;
                Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleBlurTargettedEntityData(r, g, b, scale2, ageMultiplier2, entity.getId()), false, particleX, particleY, particleZ, motionX, motionY, motionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showUsedItemTick(Level world, LivingEntity player, int power) {
        int particles = (power + 1) * (power + 1) * (power + 1) * 10;
        for (int i = 0; i < particles; ++i) {
            double x = player.getX() - 0.5 + world.random.nextDouble();
            double y = player.getY() + (double)player.getEyeHeight() - 1.0 + world.random.nextDouble();
            double z = player.getZ() - 0.5 + world.random.nextDouble();
            double particleMotionX = (-1.0 + world.random.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionY = (-1.0 + world.random.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionZ = (-1.0 + world.random.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            float r = 1.0f * world.random.nextFloat();
            float g = 0.2f + 0.01f * world.random.nextFloat();
            float b = 0.1f + 0.5f * world.random.nextFloat();
            Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleExplosionExtendedData(r, g, b, 0.3f), false, x, y, z, particleMotionX, particleMotionY, particleMotionZ);
        }
    }

    protected double getArea(int itemUsedCount) {
        return (double)(itemUsedCount / 5) + 2.0;
    }

    public void releaseUsing(ItemStack itemStack, Level world, LivingEntity entity, int itemInUseCount) {
        if (entity instanceof Player) {
            IFluidHandlerItemCapacity fluidHandler = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack).orElse(null);
            Player player = (Player)entity;
            int itemUsedCount = this.getUseDuration(itemStack, entity) - itemInUseCount;
            int toDrain = itemUsedCount * fluidHandler.getCapacity() * (this.getPower(itemStack) + 1) / (this.getUseDuration(itemStack, entity) * this.powerLevels);
            FluidStack consumed = this.consume(toDrain, itemStack, player);
            int consumedAmount = consumed == null ? 0 : consumed.getAmount();
            itemUsedCount = consumedAmount * this.getUseDuration(itemStack, entity) / fluidHandler.getCapacity();
            if (consumedAmount > 0) {
                this.use(world, entity, itemUsedCount, this.getPower(itemStack));
                if (world.isClientSide()) {
                    this.showUsedItemTick(world, entity, this.getPower(itemStack));
                }
            } else if (world.isClientSide()) {
                this.animateOutOfEnergy(world, entity);
            }
        }
    }

    protected abstract void use(Level var1, LivingEntity var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    protected void animateOutOfEnergy(Level world, LivingEntity entity) {
        double xCoord = entity.getX();
        double yCoord = entity.getY();
        double zCoord = entity.getZ();
        float particleMotionX = world.random.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.random.nextFloat() * 0.2f - 0.1f;
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack itemStack) {
        return new ItemAttributeModifiers((List)Lists.newArrayList((Object[])new ItemAttributeModifiers.Entry[]{new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"add_mace_damage"), (double)this.meleeDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)}), true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        ItemPowerableHelpers.addPreInformation(itemStack, list);
        super.appendHoverText(itemStack, context, list, flag);
        ItemPowerableHelpers.addPostInformation(itemStack, list);
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }
}

