/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.world.gen.structure.WorldStructurePieceQuarterSymmetrical;

public class WorldStructureDarkTemple
extends Structure {
    public static final MapCodec<WorldStructureDarkTemple> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WorldStructureDarkTemple.settingsCodec((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("minHeight").forGetter(instance -> instance.minHeight), (App)Codec.INT.fieldOf("maxHeight").forGetter(instance -> instance.maxHeight)).apply((Applicative)builder, WorldStructureDarkTemple::new));
    private final int minHeight;
    private final int maxHeight;

    public WorldStructureDarkTemple(Structure.StructureSettings structureSettings, int minHeight, int maxHeight) {
        super(structureSettings);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return WorldStructureDarkTemple.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int y = 9 + Mth.clamp((int)context.chunkGenerator().getFirstFreeHeight(context.chunkPos().getMiddleBlockX(), context.chunkPos().getMiddleBlockZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), (int)this.minHeight, (int)this.maxHeight);
        builder.addPiece((StructurePiece)new Piece((RandomSource)context.random(), context.chunkPos().getMinBlockX(), y, context.chunkPos().getMinBlockZ()));
    }

    public StructureType<?> type() {
        return (StructureType)RegistryEntries.STRUCTURE_TYPE_DARK_TEMPLE.get();
    }

    public static class Piece
    extends WorldStructurePieceQuarterSymmetrical {
        public Piece(RandomSource random, int minX, int minY, int minZ) {
            super((StructurePieceType)RegistryEntries.STRUCTURE_PIECE_DARK_TEMPLE.get(), minX, minY, minZ, 9, 9, 9, Piece.getRandomHorizontalDirection((RandomSource)random));
        }

        public Piece(CompoundTag tag) {
            super((StructurePieceType)RegistryEntries.STRUCTURE_PIECE_DARK_TEMPLE.get(), tag);
        }

        @Override
        protected int getQuarterWidth() {
            return 6;
        }

        @Override
        protected int getQuarterHeight() {
            return 6;
        }

        @Override
        protected void generateLayers() {
            WorldStructurePieceQuarterSymmetrical.BlockWrapper us = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, (BlockState)Blocks.STONE_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper rs = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, (BlockState)Blocks.STONE_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper ds = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, (BlockState)Blocks.STONE_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE));
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cb = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.CHISELED_STONE_BRICKS);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper sb = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.STONE_BRICKS);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cs = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.COBBLESTONE_SLAB);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper co = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.COBBLESTONE);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper wa = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.WATER);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper fe = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.DARK_OAK_FENCE);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper to = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.TORCH);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper cw = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, Blocks.COBBLESTONE_WALL);
            WorldStructurePieceQuarterSymmetrical.BlockWrapper lc = new WorldStructurePieceQuarterSymmetrical.BlockWrapper(this, Blocks.CHEST.defaultBlockState(), (float)GeneralConfig.darkTempleChestChance);
            lc.action = (world, pos) -> {
                RandomSource rand = RandomSource.create();
                RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)rand, (BlockPos)pos, (ResourceKey)BuiltInLootTables.JUNGLE_TEMPLE);
            };
            WorldStructurePieceQuarterSymmetrical.BlockWrapper vi = new WorldStructurePieceQuarterSymmetrical.BlockWrapper(this, Blocks.VINE.defaultBlockState(), 0.3f);
            vi.action = (world, pos) -> {
                boolean atLeastOne = false;
                for (Direction side : Direction.Plane.HORIZONTAL) {
                    if (!world.getBlockState(pos.relative(side)).isFaceSturdy((BlockGetter)world, pos.relative(side), side.getOpposite())) continue;
                    world.setBlock(pos, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.PROPERTY_BY_DIRECTION.get(side), (Comparable)Boolean.valueOf(true)), 2);
                    atLeastOne = true;
                }
                if (!atLeastOne) {
                    world.removeBlock(pos, true);
                }
            };
            WorldStructurePieceQuarterSymmetrical.BlockWrapper ea = new WorldStructurePieceQuarterSymmetrical.BlockWrapper((WorldStructurePieceQuarterSymmetrical)this, (Block)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get());
            Object o = null;
            this.addLayer(1, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, us, ds, vi, us, us, us, us, us, o, us, us, us, us, o, o, us, us, us, us, o, o, us, us, us, us, o, o});
            this.addLayer(2, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, vi, vi, o, o, o, o, cb, cb, vi, sb, sb, sb, sb, cb, vi, ds, co, wa, sb, o, o, co, co, co, sb, o, o, co, co, ds, sb, o, o});
            this.addLayer(3, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, lc, sb, vi, o, o, o, fe, lc, o, rs, o, o, o, o, o, cs, rs, o, o, o, o, ea, cs, rs, o, o, o});
            this.addLayer(4, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, vi, cb, vi, o, o, o, to, vi, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o});
            this.addLayer(5, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{us, o, o, o, cw, o, o, o, o, o, sb, cw, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, us});
            this.addLayer(6, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{cb, ds, rs, rs, rs, o, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, ds, o, co, co, co, co, cb});
            this.addLayer(7, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{rs, o, o, o, o, o, cw, o, o, o, o, o, cs, cs, cs, o, o, o, co, co, cs, cs, o, o, co, co, co, cs, o, o, o, co, co, cs, cw, rs});
            this.addLayer(8, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, cs, cw, o, o, o, o, o, cs, o, o, o, o});
            this.addLayer(9, new WorldStructurePieceQuarterSymmetrical.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o});
        }

        @Override
        protected void postBuildCorner(LevelAccessor world, BlockPos blockPos, int incX, int incZ) {
            world.setBlock(blockPos.offset(3 * incX, 5, 4 * incZ), (BlockState)((BlockState)((BlockState)Blocks.STONE_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)DirectionHelpers.getEnumFacingFromXSign((int)incX))).setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.STRAIGHT), 2);
            world.setBlock(blockPos.offset(4 * incX, 5, 3 * incZ), (BlockState)((BlockState)((BlockState)Blocks.STONE_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)DirectionHelpers.getEnumFacingFromZSing((int)incZ))).setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.STRAIGHT), 2);
            int xx = 4 * incX;
            int zz = 4 * incZ;
            int pillarHeight = this.getPillarHeightForCornerAt(world, blockPos, incX, incZ);
            for (int yOffset = 0; yOffset < pillarHeight; ++yOffset) {
                world.setBlock(blockPos.offset(xx, -yOffset, zz), Blocks.COBBLESTONE.defaultBlockState(), 2);
            }
        }

        private int getPillarHeightForCornerAt(LevelAccessor world, BlockPos blockPos, int incX, int incZ) {
            BlockPos loopPos = blockPos.offset(4 * incX, 0, 4 * incZ);
            int res = 0;
            while (!this.isSolidBlock(world, loopPos)) {
                if ((loopPos = loopPos.offset(0, -1, 0)).getY() <= world.getMinBuildHeight()) {
                    return res;
                }
                ++res;
            }
            return res;
        }

        private boolean isSolidBlock(LevelAccessor world, BlockPos blockPos) {
            return this.isSolidBlock(world.getBlockState(blockPos));
        }

        private boolean isSolidBlock(BlockState blockState) {
            return blockState.isSolid();
        }
    }
}

