/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei;

import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenBloodInfuser;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenExaltedCrafter;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenOriginsOfDarkness;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSpiritFurnace;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSpiritReanimator;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;
import org.cyclops.evilcraftcompat.RegistryEntriesCompat;
import org.cyclops.evilcraftcompat.modcompat.jei.SubtypeInterpreterActivatableFluidContainer;
import org.cyclops.evilcraftcompat.modcompat.jei.SubtypeInterpreterBoxOfEternalClosure;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace.SpiritFurnaceRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace.SpiritFurnaceRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeJEI;

@JeiPlugin
public class JEIEvilCraftConfig
implements IModPlugin {
    public static Consumer<List<SpiritFurnaceRecipeJEI>> SPIRIT_FURNACE_RECIPES_REGISTRAR;

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        SubtypeInterpreterActivatableFluidContainer subtypeInterpreter = new SubtypeInterpreterActivatableFluidContainer();
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_BLOOD_EXTRACTOR.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_BLOOD_PEARL_OF_TELEPORTATION.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_DARK_TANK.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_INVIGORATING_PENDANT.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_PRIMED_PENDANT.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_KINETICATOR.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_KINETICATOR_REPELLING.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_MACE_OF_DISTORTION.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_MACE_OF_DESTRUCTION.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_NECROMANCER_STAFF.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_FLESH_REJUVENATED.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_ENTANGLED_CHALICE.get()), (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE.get()), (IIngredientSubtypeInterpreter)new SubtypeInterpreterBoxOfEternalClosure());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BloodInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SanguinaryEnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritReanimatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritFurnaceRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(BloodInfuserRecipeCategory.TYPE, BloodInfuserRecipeJEI.getAllRecipes());
        registry.addRecipes(EnvironmentalAccumulatorRecipeCategory.TYPE, EnvironmentalAccumulatorRecipeJEI.getAllRecipes());
        registry.addRecipes(SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, SanguinaryEnvironmentalAccumulatorRecipeJEI.getAllRecipes());
        registry.addRecipes(SpiritReanimatorRecipeCategory.TYPE, SpiritReanimatorRecipeJEI.getAllRecipes());
        SPIRIT_FURNACE_RECIPES_REGISTRAR = recipes -> registry.addRecipes(SpiritFurnaceRecipeCategory.TYPE, recipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_BLOOD_INFUSER.get()), new RecipeType[]{BloodInfuserRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get()), new RecipeType[]{EnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get()), new RecipeType[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get()), new RecipeType[]{SpiritReanimatorRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_SPIRIT_FURNACE.get()), new RecipeType[]{SpiritFurnaceRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED), new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerBloodInfuser.class, null, BloodInfuserRecipeCategory.TYPE, 1, 1, 7, 36);
        registry.addRecipeTransferHandler(ContainerSanguinaryEnvironmentalAccumulator.class, null, SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, 0, 1, 6, 36);
        registry.addRecipeTransferHandler(ContainerSpiritReanimator.class, null, SpiritReanimatorRecipeCategory.TYPE, 1, 2, 8, 36);
        registry.addRecipeTransferHandler(ContainerSpiritFurnace.class, null, SpiritFurnaceRecipeCategory.TYPE, 1, 1, BlockEntitySpiritFurnace.SLOTS + 4, 36);
        registry.addRecipeTransferHandler(ContainerExaltedCrafter.class, null, RecipeTypes.CRAFTING, 0, 9, 10, 63);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ContainerScreenBloodInfuser.class, 130, 36, 24, 16, new RecipeType[]{BloodInfuserRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSanguinaryEnvironmentalAccumulator.class, 105, 36, 24, 16, new RecipeType[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSpiritReanimator.class, 147, 26, 10, 24, new RecipeType[]{SpiritReanimatorRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSpiritFurnace.class, 130, 36, 24, 16, new RecipeType[]{SpiritFurnaceRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenExaltedCrafter.class, 88, 32, 28, 23, new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addGuiScreenHandler(ContainerScreenOriginsOfDarkness.class, screen -> null);
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"main");
    }

    public static MutableComponent getDurationSecondsTextComponent(int durationTicks) {
        String seconds = new DecimalFormat("#.##").format((double)durationTicks / 20.0);
        return Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{seconds});
    }
}

