/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritReanimatorConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeJEI;

public class SpiritReanimatorRecipeCategory
implements IRecipeCategory<SpiritReanimatorRecipeJEI> {
    public static final RecipeType<SpiritReanimatorRecipeJEI> TYPE = RecipeType.create((String)"evilcraftcompat", (String)"spirit_reanimator", SpiritReanimatorRecipeJEI.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public SpiritReanimatorRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"textures/gui/spirit_reanimator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get()));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 10, 24);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    public RecipeType<SpiritReanimatorRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)((Block)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get()).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxTankSize() {
        return BlockSpiritReanimatorConfig.mBPerTick * BlockSpiritReanimatorConfig.requiredTicks;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritReanimatorRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 17).addItemStack(recipe.getInputItem());
        builder.addSlot(RecipeIngredientRole.INPUT, 88, 17).addItemStack(new ItemStack((ItemLike)Items.EGG));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 6, 6).setOverlay(this.tankOverlay, 0, 0).setFluidRenderer((long)this.getMaxTankSize(), true, 16, 58).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getInputFluid());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 69, 47).addItemStack(recipe.getOutputItem());
    }

    public void draw(SpiritReanimatorRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 72, 21);
        Font fontRenderer = Minecraft.getInstance().font;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.drawInBatch((Component)duration, (float)((this.background.getWidth() - fontRenderer.width((FormattedText)duration)) / 2 + 46), 50.0f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

