/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IGuiHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiHelpersCommon
implements IGuiHelpers {
    protected final IModHelpers modHelpers;
    private static final List<Pair<Long, String>> COUNT_SCALES = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1000000000000000000L, (Object)"E"), Pair.of((Object)1000000000000000L, (Object)"P"), Pair.of((Object)1000000000000L, (Object)"T"), Pair.of((Object)1000000000L, (Object)"G"), Pair.of((Object)1000000L, (Object)"M"), Pair.of((Object)1000L, (Object)"K")});

    public GuiHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public int getSlotSize() {
        return 18;
    }

    @Override
    public int getSlotSizeInner() {
        return 16;
    }

    @Override
    public void renderProgressBar(GuiGraphics gui, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, IGuiHelpers.ProgressDirection direction, int progress, int progressMax) {
        if (progressMax > 0 && progress > 0) {
            int offset;
            int scaledWidth = width;
            int scaledHeight = height;
            if (direction.getIncrementX() != 0) {
                scaledWidth = (int)((double)scaledWidth * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementY() != 0) {
                scaledHeight = (int)((double)scaledHeight * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementX() < 0) {
                offset = width - scaledWidth;
                x += offset;
                textureX += offset;
            }
            if (direction.getIncrementY() < 0) {
                offset = height - scaledHeight;
                y += offset;
                textureY += offset;
            }
            gui.blit(texture, x, y, textureX, textureY, scaledWidth, scaledHeight);
        }
    }

    @Override
    public void drawTooltip(AbstractContainerScreen gui, PoseStack poseStack, List<Component> lines, int x, int y) {
        int guiLeft = gui.leftPos;
        int guiTop = gui.topPos;
        int width = gui.width;
        int height = gui.height;
        Minecraft mc = Minecraft.getInstance();
        GL11.glDisable((int)2929);
        int tooltipWidth = 0;
        for (Component line : lines) {
            int tempWidth = mc.font.width(line.getString());
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (guiLeft + xStart + tooltipWidth + 6 > width) {
            xStart = width - tooltipWidth - guiLeft - 6;
        }
        if (guiTop + yStart + tooltipHeight + 6 > height) {
            yStart = height - tooltipHeight - guiTop - 6;
        }
        this.drawTooltipBackground(poseStack, xStart, yStart, tooltipWidth, tooltipHeight);
        PoseStack matrixstack = new PoseStack();
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        matrixstack.translate(0.0, 0.0, 300.0);
        Matrix4f matrix4f = matrixstack.last().pose();
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            Component line = lines.get(stringIndex);
            line = stringIndex == 0 ? Component.literal((String)("\u00a7" + Integer.toHexString(15))).append(line) : Component.literal((String)"\u00a77").append(line);
            mc.font.drawInBatch(line.getVisualOrderText(), (float)(xStart + guiLeft), (float)(yStart + guiTop), -1, true, matrix4f, (MultiBufferSource)irendertypebuffer$impl, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        irendertypebuffer$impl.endBatch();
        GL11.glEnable((int)2929);
    }

    @Override
    public void drawTooltipBackground(PoseStack poseStack, int xStart, int yStart, int tooltipWidth, int tooltipHeight) {
        float zLevel = 300.0f;
        int color1 = -267386864;
        this.fillGradient(poseStack, xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        this.fillGradient(poseStack, xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1, zLevel);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.fillGradient(poseStack, xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        this.fillGradient(poseStack, xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2, zLevel);
        this.fillGradient(poseStack, xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3, zLevel);
    }

    @Override
    public void fillGradient(PoseStack poseStack, int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.last().pose();
        bufferbuilder.addVertex(matrix, (float)right, (float)top, zLevel).setColor(f1, f2, f3, f);
        bufferbuilder.addVertex(matrix, (float)left, (float)top, zLevel).setColor(f1, f2, f3, f);
        bufferbuilder.addVertex(matrix, (float)left, (float)bottom, zLevel).setColor(f5, f6, f7, f4);
        bufferbuilder.addVertex(matrix, (float)right, (float)bottom, zLevel).setColor(f5, f6, f7, f4);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    @Override
    public void renderTooltipOptional(AbstractContainerScreen gui, PoseStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<Optional<List<Component>>> linesSupplier) {
        if (this.modHelpers.getRenderHelpers().isPointInRegion(x, y, width, height, mouseX - gui.leftPos, mouseY - gui.topPos)) {
            linesSupplier.get().ifPresent(lines -> this.drawTooltip(gui, poseStack, (List<Component>)lines, mouseX - gui.leftPos, mouseY - gui.topPos));
        }
    }

    @Override
    public void renderTooltip(AbstractContainerScreen gui, PoseStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<List<Component>> linesSupplier) {
        this.renderTooltipOptional(gui, poseStack, x, y, width, height, mouseX, mouseY, () -> Optional.of((List)linesSupplier.get()));
    }

    @Override
    public String quantityToScaledString(long quantity) {
        for (Pair<Long, String> countScale : COUNT_SCALES) {
            long mod;
            long scale = (Long)countScale.getLeft();
            if (quantity < scale) continue;
            long division = quantity / scale;
            Object divisionString = String.valueOf(division);
            if (division < 10L) {
                long mod2 = quantity % scale;
                if (mod2 > 0L) {
                    long digits = mod2 * 100L / scale;
                    divisionString = (String)divisionString + "." + (digits < 10L ? "0" : "") + String.valueOf(digits);
                }
            } else if (division < 100L && (mod = quantity % scale) > 0L) {
                long digits = mod * 10L / scale;
                divisionString = (String)divisionString + "." + String.valueOf(digits);
            }
            return (String)divisionString + (String)countScale.getRight();
        }
        return String.valueOf(quantity);
    }
}

