/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;

public interface INBTSerializable {
    public CompoundTag toNBT(HolderLookup.Provider var1);

    public void fromNBT(HolderLookup.Provider var1, CompoundTag var2);

    public static class SelfNBTClassType
    extends NBTClassType<INBTSerializable> {
        private final Class<?> fieldType;

        public SelfNBTClassType(Class<?> fieldType) {
            this.fieldType = fieldType;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        @Override
        public void writePersistedField(String name, INBTSerializable object, CompoundTag tag, HolderLookup.Provider provider) {
            try {
                Method method = this.fieldType.getMethod("toNBT", HolderLookup.Provider.class);
                tag.put(name, (Tag)method.invoke((Object)object, provider));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method toNBT for field " + name + " of class " + String.valueOf(this.fieldType) + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in toNBT for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke toNBT for " + name + ".");
            }
        }

        @Override
        public INBTSerializable readPersistedField(String name, CompoundTag tag, HolderLookup.Provider provider) {
            try {
                Constructor<?> constructor = this.fieldType.getConstructor(new Class[0]);
                if (constructor == null) {
                    throw new RuntimeException("The NBT serializable " + name + " of class " + String.valueOf(this.fieldType) + " must have a constructor without parameters.");
                }
                Method method = this.fieldType.getMethod("fromNBT", HolderLookup.Provider.class, CompoundTag.class);
                INBTSerializable obj = (INBTSerializable)constructor.newInstance(new Object[0]);
                if (tag.contains(name)) {
                    method.invoke((Object)obj, provider, tag.get(name));
                } else {
                    System.out.println(String.format("The tag %s did not contain the key %s, skipping reading.", tag, name));
                }
                return obj;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method fromNBT for field " + name + " of class " + String.valueOf(this.fieldType) + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in fromNBT for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke fromNBT for " + name + ".");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException("Something went wrong while calling the empty constructor for " + name + "of class " + String.valueOf(this.fieldType) + ".");
            }
        }

        @Override
        public INBTSerializable getDefaultValue() {
            return null;
        }
    }
}

