/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.caribou;

import com.dragn0007.dragnlivestock.entities.caribou.Caribou;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class CaribouModel
extends DefaultedEntityGeoModel<Caribou> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_horse.animation.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/baby_caribou.geo.json");
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/caribou.geo.json");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public CaribouModel() {
        super(new ResourceLocation("dragnlivestock", "caribou"), true);
    }

    public void setCustomAnimations(Caribou animatable, long instanceId, AnimationState<Caribou> animationState) {
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        if (neck != null && animatable.m_20096_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            float maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Caribou object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        return MODEL;
    }

    public ResourceLocation getTextureResource(Caribou object) {
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(Caribou animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BAY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/bay.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/blue.png")),
        CHAMPAGNE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/champagne.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/chestnut.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/chocolate.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/cream.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/grey.png")),
        IVORY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/ivory.png")),
        LIGHT_GREY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/light_grey.png")),
        LIVER(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/liver_chestnut.png")),
        PALAMINO(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/palamino.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/red.png")),
        SEAL(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/seal.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/strawberry.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

