/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.cow.moobloom;

import com.dragn0007.dragnlivestock.entities.cow.OCow;
import com.dragn0007.dragnlivestock.entities.cow.mooshroom.OMooshroomModel;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class AbstractMoobloom
extends OCow
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_cow");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/cow");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/cow");
    public int regrowPlantsCounter = 0;
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HORN_TYPE = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> MILKED = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HARNESSED = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BELLED = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(AbstractMoobloom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractMoobloom(EntityType<? extends OCow> type, Level level) {
        super(type, level);
    }

    @Override
    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public boolean m_6785_(double v) {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (damageSource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!(!itemStack.m_150930_(Items.f_42574_) || this.isSheared() && this.regrowPlantsCounter < (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get() || player.m_6144_())) {
            this.setSheared(true);
            this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            if (this.f_19796_.m_188500_() < 0.4) {
                this.m_19998_((ItemLike)Items.f_41952_);
                this.m_19998_((ItemLike)Items.f_41952_);
                this.m_19998_((ItemLike)Items.f_41952_);
                this.m_19998_((ItemLike)Items.f_41952_);
            } else {
                this.m_19998_((ItemLike)Items.f_41952_);
                this.m_19998_((ItemLike)Items.f_41952_);
                this.m_19998_((ItemLike)Items.f_41952_);
            }
            this.regrowPlantsCounter = 0;
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.regrowPlantsCounter;
        if (this.regrowPlantsCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()) {
            this.setSheared(false);
        }
    }

    @Override
    public boolean m_30628_() {
        return false;
    }

    @Override
    public boolean m_7848_(Animal animal) {
        return false;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return OMooshroomModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("HornType")) {
            this.setHornVariant(tag.m_128451_("HornType"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("MilkedTime")) {
            this.replenishMilkCounter = tag.m_128451_("MilkedTime");
        }
        if (tag.m_128441_("Milked")) {
            this.setMilked(tag.m_128471_("Milked"));
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
        if (tag.m_128441_("Harnessed")) {
            this.setHarnessed(tag.m_128471_("Harnessed"));
        }
        if (tag.m_128441_("Belled")) {
            this.setBelled(tag.m_128471_("Belled"));
        }
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
        }
        if (tag.m_128441_("ShearedTime")) {
            this.regrowPlantsCounter = tag.m_128451_("ShearedTime");
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("HornType", this.getHornVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Milked", this.wasMilked());
        tag.m_128405_("MilkedTime", this.replenishMilkCounter);
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
        tag.m_128379_("Harnessed", this.isHarnessed());
        tag.m_128379_("Belled", this.isBelled());
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128405_("ShearedTime", this.regrowPlantsCounter);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(HORN_TYPE, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
        this.f_19804_.m_135372_(MILKED, (Object)false);
        this.f_19804_.m_135372_(HARNESSED, (Object)false);
        this.f_19804_.m_135372_(BELLED, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }
}

