/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.cow.mooshroom;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.cow.CowBreed;
import com.dragn0007.dragnlivestock.entities.cow.OCow;
import com.dragn0007.dragnlivestock.entities.cow.mooshroom.OMooshroomModel;
import com.dragn0007.dragnlivestock.entities.cow.mooshroom.OMooshroomMushroomLayer;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.BovineMarkingOverlay;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class OMooshroom
extends OCow
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_mooshroom");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/mooshroom");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/cow");
    public int regrowPlantsCounter = 0;
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HORN_TYPE = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> MILKED = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HARNESSED = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BELLED = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MUSHROOMS = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OMooshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OMooshroom(EntityType<? extends OCow> type, Level level) {
        super(type, level);
    }

    @Override
    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public float m_5610_(BlockPos p_28933_, LevelReader p_28934_) {
        return p_28934_.m_8055_(p_28933_.m_7495_()).m_60713_(Blocks.f_50195_) ? 10.0f : p_28934_.m_220419_(p_28933_);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!(!itemStack.m_150930_(Items.f_42574_) || this.isSheared() && this.regrowPlantsCounter < (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get() || player.m_6144_())) {
            this.setSheared(true);
            this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            if (this.getMushroomVariant() == 0) {
                if (this.f_19796_.m_188500_() < 0.4) {
                    this.m_19998_((ItemLike)Items.f_41952_);
                    this.m_19998_((ItemLike)Items.f_41952_);
                    this.m_19998_((ItemLike)Items.f_41952_);
                    this.m_19998_((ItemLike)Items.f_41952_);
                } else {
                    this.m_19998_((ItemLike)Items.f_41952_);
                    this.m_19998_((ItemLike)Items.f_41952_);
                    this.m_19998_((ItemLike)Items.f_41952_);
                }
            } else if (this.getMushroomVariant() == 1) {
                if (this.f_19796_.m_188500_() < 0.4) {
                    this.m_19998_((ItemLike)Items.f_41953_);
                    this.m_19998_((ItemLike)Items.f_41953_);
                    this.m_19998_((ItemLike)Items.f_41953_);
                    this.m_19998_((ItemLike)Items.f_41953_);
                } else {
                    this.m_19998_((ItemLike)Items.f_41953_);
                    this.m_19998_((ItemLike)Items.f_41953_);
                    this.m_19998_((ItemLike)Items.f_41953_);
                }
            }
            this.regrowPlantsCounter = 0;
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42399_) && !this.m_6162_()) {
            if (!this.wasMilked() || this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get() && !this.isDairyBreed() && (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale())) {
                player.m_5496_(SoundEvents.f_12073_, 1.0f, 1.0f);
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42400_.m_7968_());
                player.m_21008_(hand, itemstack1);
                this.replenishMilkCounter = 0;
                this.setMilked(true);
            } else if (!this.wasMilked() || this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.DAIRY_MILKING_COOLDOWN.get() && this.isDairyBreed() && (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale())) {
                player.m_5496_(SoundEvents.f_12073_, 1.0f, 1.0f);
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42400_.m_7968_());
                player.m_21008_(hand, itemstack1);
                this.replenishMilkCounter = 0;
                this.setMilked(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.regrowPlantsCounter;
        if (this.regrowPlantsCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()) {
            this.setSheared(false);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return OMooshroomModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getMushroomLocation() {
        return OMooshroomMushroomLayer.MushroomOverlay.overlayFromOrdinal((int)this.getMushroomVariant()).resourceLocation;
    }

    public int getMushroomVariant() {
        return (Integer)this.f_19804_.m_135370_(MUSHROOMS);
    }

    public void setMushroomVariant(int mushroomVariant) {
        this.f_19804_.m_135381_(MUSHROOMS, (Object)mushroomVariant);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Mushrooms")) {
            this.setMushroomVariant(tag.m_128451_("Mushrooms"));
        }
        if (tag.m_128441_("HornType")) {
            this.setHornVariant(tag.m_128451_("HornType"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("MilkedTime")) {
            this.replenishMilkCounter = tag.m_128451_("MilkedTime");
        }
        if (tag.m_128441_("Milked")) {
            this.setMilked(tag.m_128471_("Milked"));
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
        if (tag.m_128441_("Harnessed")) {
            this.setHarnessed(tag.m_128471_("Harnessed"));
        }
        if (tag.m_128441_("Belled")) {
            this.setBelled(tag.m_128471_("Belled"));
        }
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
        }
        if (tag.m_128441_("ShearedTime")) {
            this.regrowPlantsCounter = tag.m_128451_("ShearedTime");
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Mushrooms", this.getMushroomVariant());
        tag.m_128405_("HornType", this.getHornVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Milked", this.wasMilked());
        tag.m_128405_("MilkedTime", this.replenishMilkCounter);
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
        tag.m_128379_("Harnessed", this.isHarnessed());
        tag.m_128379_("Belled", this.isBelled());
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128405_("ShearedTime", this.regrowPlantsCounter);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setBreed(random.nextInt(CowBreed.Breed.values().length));
        this.setGender(random.nextInt(OCow.Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setMarkingByBreed();
            this.setHornsByBreed();
        } else {
            this.setVariant(random.nextInt(OMooshroomModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(BovineMarkingOverlay.values().length));
            this.setHornVariant(random.nextInt(OCow.BreedHorns.values().length));
        }
        this.setMushroomVariant(OMooshroomMushroomLayer.MushroomOverlay.values().length);
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(MUSHROOMS, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(HORN_TYPE, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
        this.f_19804_.m_135372_(MILKED, (Object)false);
        this.f_19804_.m_135372_(HARNESSED, (Object)false);
        this.f_19804_.m_135372_(BELLED, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    @Override
    public boolean m_30628_() {
        return !this.m_6162_() && this.m_27593_();
    }

    @Override
    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OMooshroom)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.m_30628_() && ((OMooshroom)animal).m_30628_();
        }
        OMooshroom partner = (OMooshroom)animal;
        if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OMooshroom partner = (OMooshroom)ageableMob;
        OMooshroom calf = (OMooshroom)((EntityType)EntityTypes.O_MOOSHROOM_ENTITY.get()).m_20615_((Level)serverLevel);
        int breedChance = this.f_19796_.m_188503_(5);
        int breed = breedChance == 0 ? this.f_19796_.m_188503_(CowBreed.Breed.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed());
        calf.setBreed(breed);
        int variantChance = this.f_19796_.m_188503_(14);
        int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OMooshroomModel.Variant.values().length));
        calf.setVariant(variant);
        if (breedChance != 0) {
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            calf.setOverlayVariant(overlay);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            calf.setMarkingByBreed();
        }
        int mushroomChance = this.f_19796_.m_188503_(10);
        int mushrooms = mushroomChance < 4 ? this.getMushroomVariant() : (mushroomChance < 8 ? partner.getMushroomVariant() : this.f_19796_.m_188503_(OMooshroomMushroomLayer.MushroomOverlay.values().length));
        calf.setMushroomVariant(mushrooms);
        if (breedChance != 0) {
            int hornsChance = this.f_19796_.m_188503_(10);
            int hornType = hornsChance < 4 ? this.getHornVariant() : (hornsChance < 8 ? partner.getHornVariant() : this.f_19796_.m_188503_(OCow.BreedHorns.values().length));
            calf.setHornVariant(hornType);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            calf.setHornsByBreed();
        }
        int gender = this.f_19796_.m_188503_(OCow.Gender.values().length);
        calf.setGender(gender);
        return calf;
    }

    @Override
    public void setColorByBreed() {
        if (this.f_19796_.m_188500_() < 0.05) {
            this.setVariant(this.f_19796_.m_188503_(OMooshroomModel.Variant.values().length));
        } else if (this.f_19796_.m_188500_() > 0.05) {
            int[] variants = new int[]{0, 7, 9, 10, 11};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }
}

