/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.farm_goat;

import com.dragn0007.dragnlivestock.entities.farm_goat.FarmGoat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class FarmGoatModel
extends DefaultedEntityGeoModel<FarmGoat> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_goat.animation.json");
    public static final ResourceLocation FEMALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/o_doe.geo.json");
    public static final ResourceLocation MALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/o_buck.geo.json");
    public static final ResourceLocation MEAT_FEMALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/meat_doe.geo.json");
    public static final ResourceLocation MEAT_MALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/meat_buck.geo.json");
    public static final ResourceLocation NUBIAN_FEMALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/nubian_doe.geo.json");
    public static final ResourceLocation NUBIAN_MALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/nubian_buck.geo.json");
    public static final ResourceLocation WARM_FEMALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/warm_doe.geo.json");
    public static final ResourceLocation WARM_MALE = new ResourceLocation("dragnlivestock", "geo/farm_goat/warm_buck.geo.json");

    public FarmGoatModel() {
        super(new ResourceLocation("dragnlivestock", "o_goat"), true);
    }

    public void setCustomAnimations(FarmGoat animatable, long instanceId, AnimationState<FarmGoat> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(FarmGoat object) {
        if (object.getBreed() == 1) {
            if (object.isMale()) {
                return MEAT_MALE;
            }
            return MEAT_FEMALE;
        }
        if (object.getBreed() == 2) {
            if (object.isMale()) {
                return NUBIAN_MALE;
            }
            return NUBIAN_FEMALE;
        }
        if (object.getBreed() == 3) {
            if (object.isMale()) {
                return WARM_MALE;
            }
            return WARM_FEMALE;
        }
        if (object.isMale()) {
            return MALE;
        }
        return FEMALE;
    }

    public ResourceLocation getTextureResource(FarmGoat object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(FarmGoat animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BAY(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/bay.png")),
        BEIGE(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/beige.png")),
        BEZOAR(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/bezoar.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/black.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/brown.png")),
        CARAMEL(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/caramel.png")),
        CHAMOISEE(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/chamoisee.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/chocolate.png")),
        COU_BLANC(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/cou_blanc.png")),
        COU_NOIR(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/cou_noir.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/cream.png")),
        GOLD(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/gold.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/grey.png")),
        LILAC(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/lilac.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/mahogany.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/red.png")),
        SILVER(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/silver.png")),
        SILVER_BEZOAR(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/silver_bezoar.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/tan.png")),
        TWO_TONED(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/two_toned.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/farm_goat/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

