/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.horse;

import com.dragn0007.dragnlivestock.client.event.LivestockOverhaulClientEvent;
import com.dragn0007.dragnlivestock.common.gui.OHorseMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.GroundTieGoal;
import com.dragn0007.dragnlivestock.entities.ai.HorseFollowHerdLeaderGoal;
import com.dragn0007.dragnlivestock.entities.ai.MountLookAtPlayerGoal;
import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.ai.ORunAroundLikeCrazyGoal;
import com.dragn0007.dragnlivestock.entities.donkey.ODonkey;
import com.dragn0007.dragnlivestock.entities.horse.HorseBreed;
import com.dragn0007.dragnlivestock.entities.horse.OHorseModel;
import com.dragn0007.dragnlivestock.entities.mule.OMule;
import com.dragn0007.dragnlivestock.entities.mule.OMuleModel;
import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.EquineEyeColorOverlay;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.EquineMarkingOverlay;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.LightHorseArmorItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulClientConfig;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OHorse
extends AbstractOMount
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_horse");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/horse");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/horse");
    public OHorse leader;
    public int herdSize = 1;
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int maxSprint;
    public int sprintTick = this.maxSprint = 20 * (Integer)LivestockOverhaulCommonConfig.BASE_HORSE_SPRINT_TIME.get();
    public int warmbloodSprintAddition = 1200;
    public int stockSprintAddition = 800;
    public int draftSprintAddition = 400;
    public int ponySprintAddition = 200;
    public int maneGrowthTick;
    public int tailGrowthTick;
    public int decompTick;
    public int trainStatsTick;
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> REINDEER_VARIANT = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FEATHERING = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> UNDEAD = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HALLOW = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DECOMP = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DECOMPOSE = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> FLOWER_ITEM = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Integer> FLOWER_TYPE = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> BRANDED = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> SPEED_TRAINED = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> JUMP_TRAINED = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HEALTH_TRAINED = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MANE_TYPE = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TAIL_TYPE = SynchedEntityData.m_135353_(OHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    @Override
    public boolean hasGrowableHair() {
        return true;
    }

    public OHorse(EntityType<? extends OHorse> type, Level level) {
        super(type, level);
        this.setCanDecompose(true);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 1.2f));
    }

    public static AttributeSupplier.Builder createBaseOHorseAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 53.0).m_22268_(Attributes.f_22279_, (double)0.255f).m_22268_(Attributes.f_22281_, 1.0);
    }

    public void randomizeOHorseAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomOHorseMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomOHorseSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.generateRandomOHorseJumpStrength());
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new GroundTieGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new ORunAroundLikeCrazyGoal(this, 1.3f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new HorseFollowHerdLeaderGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0, AbstractOMount.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new MountLookAtPlayerGoal(this, Player.class, 12.0f));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && !this.m_30614_() || entity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() && this.m_30614_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HORSES) && livingEntity instanceof AbstractHorse && livingEntity.m_20160_() && !this.m_21523_() && (Boolean)LivestockOverhaulCommonConfig.HORSE_HERD_ANIMALS.get() != false && (this.isWearingRodeoHarness() || !this.m_30614_())));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.3f, 1.3f, livingEntity -> livingEntity instanceof OMule && livingEntity.m_20160_() && ((OMule)((Object)livingEntity)).m_6254_() && (this.isWearingRodeoHarness() || !this.m_30614_())));
    }

    public float generateRandomOHorseMaxHealth() {
        switch (this.getBreed()) {
            default: {
                float baseHealth = 16.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 1: 
            case 11: {
                float baseHealth = 20.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 3: {
                float baseHealth = 14.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 4: {
                float baseHealth = 13.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 5: 
            case 6: 
            case 10: 
            case 15: {
                float baseHealth = 18.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 8: 
            case 12: {
                float baseHealth = 24.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 9: {
                float baseHealth = 17.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 13: {
                float baseHealth = 15.0f;
                return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
            }
            case 14: 
        }
        float baseHealth = 28.0f;
        return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
    }

    public double generateRandomOHorseJumpStrength() {
        double baseStrength = 0.4f;
        double multiplier = this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.25;
        switch (this.getBreed()) {
            default: {
                baseStrength = 0.5;
                return baseStrength + multiplier;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                baseStrength = 0.3f;
                return baseStrength + multiplier;
            }
            case 2: 
            case 7: 
            case 10: {
                baseStrength = 0.4f;
                return baseStrength + multiplier;
            }
            case 3: 
            case 4: 
            case 5: {
                baseStrength = 0.35f;
                return baseStrength + multiplier;
            }
            case 8: {
                baseStrength = 0.25;
                return baseStrength + multiplier;
            }
            case 9: {
                baseStrength = 0.55f;
                return baseStrength + multiplier;
            }
            case 12: 
            case 14: 
        }
        baseStrength = 0.2f;
        return baseStrength + multiplier;
    }

    public double generateRandomOHorseSpeed() {
        double baseSpeed = 0.0;
        double multiplier = (this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1) * 0.3;
        switch (this.getBreed()) {
            default: {
                baseSpeed = 0.2f;
                return baseSpeed + multiplier;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                baseSpeed = 0.15f;
                return baseSpeed + multiplier;
            }
            case 4: {
                baseSpeed = 0.28f;
                return baseSpeed + multiplier;
            }
            case 13: 
        }
        baseSpeed = 0.3f;
        return baseSpeed + multiplier;
    }

    public boolean isDraftBreed() {
        return this.getBreed() == 1 || this.getBreed() == 5 || this.getBreed() == 8 || this.getBreed() == 12 || this.getBreed() == 14;
    }

    public boolean isPonyBreed() {
        return this.getBreed() == 3 || this.getBreed() == 6 || this.getBreed() == 11 || this.getBreed() == 15;
    }

    public boolean isStockBreed() {
        return this.getBreed() == 0 || this.getBreed() == 7;
    }

    public boolean isWarmbloodedBreed() {
        return this.getBreed() == 2 || this.getBreed() == 9 || this.getBreed() == 10;
    }

    public boolean isRacingBreed() {
        return this.getBreed() == 4 || this.getBreed() == 13;
    }

    @Override
    public boolean m_7310_(Entity entity) {
        if (!this.isDraftBreed()) {
            return this.m_20197_().isEmpty();
        }
        if (this.isDraftBreed()) {
            return this.m_20197_().size() < 2;
        }
        return false;
    }

    public LivingEntity m_6688_() {
        LivingEntity firstPassenger = (LivingEntity)this.m_146895_();
        if (firstPassenger != null && this.m_6254_()) {
            return firstPassenger;
        }
        return null;
    }

    public int m_7506_() {
        if (this.m_30502_()) {
            if (this.isDraftBreed()) {
                return 18;
            }
            if (this.isPonyBreed()) {
                return 15;
            }
            if (this.isStockBreed() || this.isWarmbloodedBreed()) {
                return 12;
            }
            if (this.isRacingBreed()) {
                return 6;
            }
            return 18;
        }
        return 3;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            LocalDate date = LocalDate.now();
            Month month = date.getMonth();
            int day = date.getDayOfMonth();
            double offsetX = 0.0;
            double offsetY = 1.0;
            double offsetZ = -0.055;
            int passengers = this.m_20197_().indexOf(entity);
            if (this.getBreed() == 0) {
                offsetY = 1.03;
            }
            if (this.getBreed() == 1) {
                switch (passengers) {
                    case 0: {
                        offsetY = 1.05;
                        break;
                    }
                    case 1: {
                        offsetY = 1.05;
                        offsetZ = -0.7;
                    }
                }
            }
            if (this.getBreed() == 2) {
                offsetY = 1.2;
            }
            if (this.getBreed() == 3) {
                offsetY = 0.9;
            }
            if (this.getBreed() == 4) {
                offsetY = 1.2;
            }
            if (this.getBreed() == 5) {
                switch (passengers) {
                    case 0: {
                        offsetY = 1.3;
                        break;
                    }
                    case 1: {
                        offsetY = 1.25;
                        offsetZ = -0.7;
                    }
                }
            }
            if (this.getBreed() == 6) {
                switch (passengers) {
                    case 0: {
                        offsetY = 0.97;
                        break;
                    }
                    case 1: {
                        offsetY = 0.97;
                        offsetZ = -0.7;
                    }
                }
            }
            if (this.getBreed() == 7) {
                offsetY = 1.05;
            }
            if (this.getBreed() == 8) {
                switch (passengers) {
                    case 0: {
                        offsetY = 1.4;
                        break;
                    }
                    case 1: {
                        offsetY = 1.4;
                        offsetZ = -0.7;
                    }
                }
            }
            if (this.getBreed() == 9) {
                offsetY = 1.05;
            }
            if (this.getBreed() == 10) {
                offsetY = 1.05;
            }
            if (this.getBreed() == 11) {
                offsetY = 0.8;
            }
            if (this.getBreed() == 12) {
                switch (passengers) {
                    case 0: {
                        offsetY = 1.45;
                        break;
                    }
                    case 1: {
                        offsetY = 1.45;
                        offsetZ = -0.7;
                    }
                }
            }
            if (this.getBreed() == 13) {
                offsetY = 1.1;
            }
            if (this.getBreed() == 14) {
                switch (passengers) {
                    case 0: {
                        offsetY = 1.33;
                        break;
                    }
                    case 1: {
                        offsetY = 1.33;
                        offsetZ = -0.7;
                    }
                }
            }
            if (this.getBreed() == 15) {
                offsetY = 0.62;
            }
            if (month == Month.DECEMBER && (day == 24 || day == 25)) {
                offsetY = 1.0;
                offsetZ = -0.01;
            }
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    @Override
    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_() && (this.isOwnedBy((LivingEntity)player) && this.isLocked() || !this.isLocked())) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new OHorseMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public boolean m_245259_() {
        return false;
    }

    public boolean m_275843_() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "emoteController", 5, this::emotePredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.025;
        double speedRunThreshold = 0.02;
        double speedTrotThreshold = 0.015;
        boolean isMoving = x * x + z * z > 1.0E-4;
        double movementSpeed = this.m_21172_(Attributes.f_22279_);
        double animationSpeed = Math.max(0.1, movementSpeed);
        AnimationController controller = tAnimationState.getController();
        if ((!this.m_30614_() || this.isWearingRodeoHarness()) && this.m_20160_() && !this.m_30616_()) {
            controller.setAnimation(RawAnimation.begin().then("buck", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.3);
        } else if (this.m_30616_()) {
            controller.setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE));
            controller.setAnimationSpeed(1.0);
        } else if (isMoving) {
            if (!LivestockOverhaulClientEvent.HORSE_WALK_BACKWARDS.m_90857_()) {
                if (this.m_5912_() || this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) || !this.m_20160_() && currentSpeed > speedThreshold) {
                    controller.setAnimation(RawAnimation.begin().then("sprint", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
                } else if (this.m_20160_() && !this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(TROT_SPEED_MOD) || !this.m_20160_() && currentSpeed > speedRunThreshold && currentSpeed < speedThreshold) {
                    if (this.isOnSand()) {
                        controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.75 * controller.getAnimationSpeed() + animationSpeed));
                    } else {
                        controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.78 * controller.getAnimationSpeed() + animationSpeed));
                    }
                } else if (this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD)) {
                    if (LivestockOverhaulClientEvent.HORSE_SPANISH_WALK_TOGGLE.m_90857_()) {
                        controller.setAnimation(RawAnimation.begin().then("spanish_walk", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.78 * controller.getAnimationSpeed() + animationSpeed));
                    } else {
                        controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.83 * controller.getAnimationSpeed() + animationSpeed));
                    }
                } else {
                    controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.8 * controller.getAnimationSpeed() + animationSpeed));
                }
            } else if (this.m_20160_() && LivestockOverhaulClientEvent.HORSE_WALK_BACKWARDS.m_90857_()) {
                if (this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD)) {
                    controller.setAnimation(RawAnimation.begin().then("walk_back", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.76 * controller.getAnimationSpeed() + animationSpeed));
                } else {
                    controller.setAnimation(RawAnimation.begin().then("walk_back", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.83 * controller.getAnimationSpeed() + animationSpeed));
                }
            }
        } else {
            if (this.m_20160_() || !((Boolean)LivestockOverhaulCommonConfig.GROUND_TIE.get()).booleanValue()) {
                controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("ground_tie", Animation.LoopType.LOOP));
            }
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
        AnimationController controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).getAnimationControllers().get("emoteController");
        controller.forceAnimationReset();
        controller.stop();
        controller.setAnimation(RawAnimation.begin().then(emoteName, Animation.LoopType.fromString((String)loopType)));
        this.shouldEmote = true;
    }

    protected <T extends GeoAnimatable> PlayState emotePredicate(AnimationState<T> tAnimationState) {
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving() || !this.shouldEmote) {
            controller.forceAnimationReset();
            controller.stop();
            this.shouldEmote = false;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_() && !this.m_6254_() && !this.m_21523_() && !this.isGroundTied();
    }

    public void startFollowing(OHorse horse) {
        this.leader = horse;
        horse.addFollower();
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    public void addFollower() {
        ++this.herdSize;
    }

    public void removeFollower() {
        --this.herdSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.herdSize < this.getMaxHerdSize() && !this.m_6254_() && !this.m_21523_() && !this.isGroundTied();
    }

    public int getMaxHerdSize() {
        return (Integer)LivestockOverhaulCommonConfig.HORSE_HERD_MAX.get();
    }

    public boolean hasFollowers() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0 && !this.m_6254_() && !this.m_21523_() && !this.isGroundTied();
    }

    public void pathToLeader() {
        if (this.isFollower() && !this.m_6254_() && !this.m_21523_() && !this.isGroundTied()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends OHorse> stream) {
        stream.limit(this.getMaxHerdSize() - this.herdSize).filter(horse -> horse != this).forEach(horse -> horse.startFollowing(this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isUndead() && !this.isHallow()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        } else if (this.isHallow()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        Entity entity = damageSource.m_7639_();
        if (entity != null && !(entity instanceof Player) && !this.isUndead() && this.f_19796_.m_188500_() <= (Double)LivestockOverhaulCommonConfig.UNDEAD_HORSE_CHANCE.get() && ((Boolean)LivestockOverhaulCommonConfig.UNDEAD_HORSE_DEATH.get()).booleanValue() && this.m_21223_() <= 4.0f) {
            if (((Boolean)LivestockOverhaulCommonConfig.DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[DragN's Livestock Overhaul!]: An O-Horse has turned undead at: " + this.m_20097_());
            }
            this.m_5634_(20.0f);
            this.setUndead(true);
            this.m_9236_().m_6269_(null, (Entity)this, this.m_5592_(), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12605_, SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
            return false;
        }
        if (this.isUndead() && (damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268722_) || damageSource.m_276093_(DamageTypes.f_268565_))) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    public MobType m_6336_() {
        if (this.isUndead()) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    public void m_8119_() {
        double z;
        boolean isMoving;
        LivingEntity controllingPassenger;
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.herdSize = 1;
        }
        if (this.m_20160_() && this.m_6688_() == this.m_269323_() && ((Object)((Object)this)).getClass() == OHorse.class && this.m_30614_() && this.m_6254_() && (this.getSpeedTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get() || this.getJumpTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get() || this.getHealthTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get())) {
            ++this.trainStatsTick;
            if (this.trainStatsTick >= (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_TIME.get()) {
                AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
                assert (speedAttribute != null);
                double speedValue = speedAttribute.m_22115_();
                if (speedValue < (double)0.284f && this.getSpeedTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get()) {
                    speedAttribute.m_22100_(speedValue + 0.005);
                    this.setSpeedTrained(this.getSpeedTrained() + 1);
                } else if (speedValue > (double)0.284f) {
                    this.setSpeedTrained((Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get());
                }
                AttributeInstance jumpAttribute = this.m_21051_(Attributes.f_22288_);
                assert (jumpAttribute != null);
                double jumpValue = jumpAttribute.m_22115_();
                if (jumpValue < 1.0 && this.getJumpTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get()) {
                    jumpAttribute.m_22100_(jumpValue + 0.005);
                    this.setJumpTrained(this.getJumpTrained() + 1);
                } else if (jumpValue > 1.0) {
                    this.setJumpTrained((Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get());
                }
                AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
                assert (healthAttribute != null);
                double healthValue = healthAttribute.m_22115_();
                if (healthValue < 40.0 && this.getHealthTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get()) {
                    healthAttribute.m_22100_(healthValue + 1.0);
                    this.setHealthTrained(this.getHealthTrained() + 1);
                } else if (healthValue > 40.0) {
                    this.setHealthTrained((Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get());
                }
                this.trainStatsTick = 0;
            }
        }
        List armorSlots = (List)this.m_6168_();
        ItemStack armorItemStack = (ItemStack)armorSlots.get(2);
        if (this.isOnSand()) {
            if (!this.hasSlownessEffect()) {
                this.applySlownessEffect();
            }
        } else if (!(!this.isDraftBreed() && armorItemStack.m_41720_() instanceof HorseArmorItem && this.isRacingBreed() && armorItemStack.m_41720_() instanceof LightHorseArmorItem || !this.hasSlownessEffect())) {
            this.removeSlownessEffect();
        }
        if (armorItemStack.m_41720_() instanceof HorseArmorItem) {
            if (!this.isDraftBreed()) {
                if (!this.hasSlownessEffect()) {
                    this.applySlownessEffect();
                }
            } else if (!this.isOnSand() && this.hasSlownessEffect()) {
                this.removeSlownessEffect();
            }
        } else if (armorItemStack.m_41720_() instanceof LightHorseArmorItem) {
            if (this.isRacingBreed()) {
                if (!this.hasSlownessEffect()) {
                    this.applySlownessEffect();
                }
            } else if (!this.isOnSand() && this.hasSlownessEffect()) {
                this.removeSlownessEffect();
            }
        }
        if (!this.m_6162_() && ((Boolean)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH.get()).booleanValue()) {
            ++this.maneGrowthTick;
            ++this.tailGrowthTick;
            if (this.maneGrowthTick >= (Integer)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH_TIME.get() && this.getManeType() > 1) {
                this.setManeType(this.getManeType() - 1);
                this.maneGrowthTick = 0;
            }
            if (this.tailGrowthTick >= (Integer)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH_TIME.get() && this.getTailType() > 1) {
                this.setTailType(this.getTailType() - 1);
                this.tailGrowthTick = 0;
            }
        }
        if (this.isUndead() && this.getDecompVariant() < 4 && this.canDecompose() && !this.isHallow()) {
            ++this.decompTick;
            if (this.decompTick >= (Integer)LivestockOverhaulCommonConfig.DECOMPISITION_STAGE_TIME.get()) {
                if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_HOT_NETHER)) {
                    this.setDecompVariant(5);
                } else if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD)) {
                    this.setDecompVariant(6);
                } else if (this.m_20069_()) {
                    this.setDecompVariant(7);
                } else if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_DESERT)) {
                    this.setDecompVariant(8);
                } else {
                    this.setDecompVariant(this.getDecompVariant() + 1);
                }
                this.decompTick = 0;
            }
        }
        LivingEntity entity = controllingPassenger = this.m_6688_();
        int sprintLeftInSeconds = this.sprintTick / 20;
        double x = this.m_20185_() - this.f_19854_;
        boolean bl = isMoving = x * x + (z = this.m_20189_() - this.f_19856_) * z > 1.0E-4;
        if (this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) && this.sprintTick > 0 && this.m_217005_() && isMoving) {
            --this.sprintTick;
            if (controllingPassenger != null && this.sprintTick > 0 && controllingPassenger instanceof Player) {
                Player player = (Player)controllingPassenger;
                if (((Boolean)LivestockOverhaulClientConfig.HORSE_SPRINT_TIMER.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)("Sprint Left: " + sprintLeftInSeconds + "s")).m_130940_(ChatFormatting.GOLD), true);
                }
            }
        }
        if (!this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) || !isMoving) {
            if ((this.isWarmbloodedBreed() && this.sprintTick < this.maxSprint + this.warmbloodSprintAddition || this.isStockBreed() && this.sprintTick < this.maxSprint + this.stockSprintAddition || this.isDraftBreed() && this.sprintTick < this.maxSprint + this.draftSprintAddition || this.isPonyBreed() && this.sprintTick < this.maxSprint + this.ponySprintAddition || this.isRacingBreed() && this.sprintTick < this.maxSprint) && isMoving) {
                ++this.sprintTick;
            } else if ((this.isWarmbloodedBreed() && this.sprintTick < this.maxSprint + this.warmbloodSprintAddition || this.isStockBreed() && this.sprintTick < this.maxSprint + this.stockSprintAddition || this.isDraftBreed() && this.sprintTick < this.maxSprint + this.draftSprintAddition || this.isPonyBreed() && this.sprintTick < this.maxSprint + this.ponySprintAddition || this.isRacingBreed() && this.sprintTick < this.maxSprint) && !isMoving) {
                ++this.sprintTick;
                ++this.sprintTick;
            }
        }
        if (this.sprintTick <= 0 && controllingPassenger != null) {
            AttributeInstance movementSpeed = this.m_21051_(Attributes.f_22279_);
            this.handleSpeedRequest(-1);
            movementSpeed.m_22130_(SPRINT_SPEED_MOD);
            if (controllingPassenger != null && controllingPassenger instanceof Player) {
                Player player = (Player)controllingPassenger;
                if (((Boolean)LivestockOverhaulClientConfig.HORSE_SPRINT_TIMER.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"Sprint Depleted").m_130940_(ChatFormatting.DARK_RED), true);
                }
            }
        }
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        if (this.isUndead()) {
            return SoundEvents.f_12605_;
        }
        return SoundEvents.f_11971_;
    }

    public SoundEvent m_5592_() {
        if (this.isUndead()) {
            return SoundEvents.f_12606_;
        }
        return SoundEvents.f_11975_;
    }

    @Nullable
    public SoundEvent m_7872_() {
        return SoundEvents.f_11976_;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        super.m_7975_(damageSource);
        if (this.isUndead()) {
            return SoundEvents.f_12607_;
        }
        return SoundEvents.f_11978_;
    }

    public SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_11972_;
    }

    @Override
    public ResourceLocation getModelResource() {
        return HorseBreed.breedFromOrdinal((int)this.getBreed()).resourceLocation;
    }

    @Override
    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    @Override
    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)OHorseModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    @Override
    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    @Override
    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    @Override
    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)EquineMarkingOverlay.overlayFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    @Override
    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public int getEyeVariant() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    public void setEyeVariant(int eyeVariant) {
        this.f_19804_.m_135381_(EYES, (Object)eyeVariant);
    }

    public ResourceLocation getReindeerTextureResource() {
        return OHorseModel.ReindeerVariant.reindeerVariantFromOrdinal((int)this.getReindeerVariant()).resourceLocation;
    }

    public int getReindeerVariant() {
        return (Integer)this.f_19804_.m_135370_(REINDEER_VARIANT);
    }

    public void setReindeerVariant(int reindeerVariant) {
        this.f_19804_.m_135381_(REINDEER_VARIANT, (Object)reindeerVariant);
    }

    public int getFeathering() {
        return (Integer)this.f_19804_.m_135370_(FEATHERING);
    }

    public void setFeathering(int feathering) {
        this.f_19804_.m_135381_(FEATHERING, (Object)feathering);
    }

    public boolean isUndead() {
        return (Boolean)this.f_19804_.m_135370_(UNDEAD);
    }

    public void setUndead(boolean undead) {
        this.f_19804_.m_135381_(UNDEAD, (Object)undead);
    }

    public boolean isHallow() {
        return (Boolean)this.f_19804_.m_135370_(HALLOW);
    }

    public void setHallow(boolean hallow) {
        this.f_19804_.m_135381_(HALLOW, (Object)hallow);
    }

    public int getDecompVariant() {
        return (Integer)this.f_19804_.m_135370_(DECOMP);
    }

    public void setDecompVariant(int decompVariant) {
        this.f_19804_.m_135381_(DECOMP, (Object)decompVariant);
    }

    public boolean canDecompose() {
        return (Boolean)this.f_19804_.m_135370_(DECOMPOSE);
    }

    public void setCanDecompose(boolean canDecompose) {
        this.f_19804_.m_135381_(DECOMPOSE, (Object)canDecompose);
    }

    @Override
    public ItemStack getFlowerItem() {
        return (ItemStack)this.f_19804_.m_135370_(FLOWER_ITEM);
    }

    @Override
    public void setFlowerItem(ItemStack decorItem) {
        this.f_19804_.m_135381_(FLOWER_ITEM, (Object)decorItem);
    }

    @Override
    public int getFlowerType() {
        return (Integer)this.f_19804_.m_135370_(FLOWER_TYPE);
    }

    @Override
    public void setFlowerType(int decompVariant) {
        this.f_19804_.m_135381_(FLOWER_TYPE, (Object)decompVariant);
    }

    @Override
    public boolean isBranded() {
        return (Boolean)this.f_19804_.m_135370_(BRANDED);
    }

    @Override
    public void setIsBranded(boolean canBeBranded) {
        this.f_19804_.m_135381_(BRANDED, (Object)canBeBranded);
    }

    public int getSpeedTrained() {
        return (Integer)this.f_19804_.m_135370_(SPEED_TRAINED);
    }

    public void setSpeedTrained(int trained) {
        this.f_19804_.m_135381_(SPEED_TRAINED, (Object)trained);
    }

    public int getJumpTrained() {
        return (Integer)this.f_19804_.m_135370_(JUMP_TRAINED);
    }

    public void setJumpTrained(int trained) {
        this.f_19804_.m_135381_(JUMP_TRAINED, (Object)trained);
    }

    public int getHealthTrained() {
        return (Integer)this.f_19804_.m_135370_(HEALTH_TRAINED);
    }

    public void setHealthTrained(int trained) {
        this.f_19804_.m_135381_(HEALTH_TRAINED, (Object)trained);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Variant_Texture")) {
            this.setVariantTexture(tag.m_128461_("Variant_Texture"));
        }
        if (tag.m_128441_("Overlay_Texture")) {
            this.setOverlayVariantTexture(tag.m_128461_("Overlay_Texture"));
        }
        if (tag.m_128441_("Reindeer_Variant")) {
            this.setReindeerVariant(tag.m_128451_("Reindeer_Variant"));
        }
        if (tag.m_128441_("Decomp_Stage")) {
            this.setDecompVariant(tag.m_128451_("Decomp_Stage"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Mane")) {
            this.setManeType(tag.m_128451_("Mane"));
        }
        if (tag.m_128441_("Tail")) {
            this.setTailType(tag.m_128451_("Tail"));
        }
        if (tag.m_128441_("Feathering")) {
            this.setFeathering(tag.m_128451_("Feathering"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyeVariant(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("SprintTime")) {
            this.sprintTick = tag.m_128451_("SprintTime");
        }
        if (tag.m_128441_("ManeGrowthTime")) {
            this.maneGrowthTick = tag.m_128451_("ManeGrowthTime");
        }
        if (tag.m_128441_("TailGrowthTime")) {
            this.tailGrowthTick = tag.m_128451_("TailGrowthTime");
        }
        if (tag.m_128441_("Undead")) {
            this.setUndead(tag.m_128471_("Undead"));
        }
        if (tag.m_128441_("CanDecompose")) {
            this.setCanDecompose(tag.m_128471_("CanDecompose"));
        }
        if (tag.m_128441_("Flower_Type")) {
            this.setFlowerType(tag.m_128451_("Flower_Type"));
        }
        if (tag.m_128441_("FlowerItem")) {
            ItemStack decorItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("FlowerItem"));
            this.setFlowerItem(decorItem);
        }
        if (tag.m_128441_("IsBranded")) {
            this.setIsBranded(tag.m_128471_("IsBranded"));
        }
        if (tag.m_128441_("TrainingTime")) {
            this.trainStatsTick = tag.m_128451_("TrainingTime");
        }
        if (tag.m_128441_("SpeedTrained")) {
            this.setSpeedTrained(tag.m_128451_("SpeedTrained"));
        }
        if (tag.m_128441_("JumpTrained")) {
            this.setJumpTrained(tag.m_128451_("JumpTrained"));
        }
        if (tag.m_128441_("HealthTrained")) {
            this.setHealthTrained(tag.m_128451_("HealthTrained"));
        }
        if (tag.m_128441_("IsHallow")) {
            this.setHallow(tag.m_128471_("IsHallow"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128359_("Variant_Texture", this.getTextureResource().toString());
        tag.m_128359_("Overlay_Texture", this.getOverlayLocation().toString());
        tag.m_128405_("Reindeer_Variant", this.getReindeerVariant());
        tag.m_128405_("Decomp_Stage", this.getDecompVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Mane", this.getManeType());
        tag.m_128405_("Tail", this.getTailType());
        tag.m_128405_("Feathering", this.getFeathering());
        tag.m_128405_("Eyes", this.getEyeVariant());
        tag.m_128405_("SprintTime", this.sprintTick);
        tag.m_128405_("ManeGrowthTime", this.maneGrowthTick);
        tag.m_128405_("TailGrowthTime", this.tailGrowthTick);
        tag.m_128379_("Undead", this.isUndead());
        tag.m_128379_("CanDecompose", this.canDecompose());
        tag.m_128405_("Flower_Type", this.getFlowerType());
        if (!this.getFlowerItem().m_41619_()) {
            tag.m_128365_("FlowerItem", (Tag)this.getFlowerItem().m_41739_(new CompoundTag()));
        }
        tag.m_128379_("IsBranded", this.isBranded());
        tag.m_128405_("TrainingTime", this.trainStatsTick);
        tag.m_128405_("SpeedTrained", this.getSpeedTrained());
        tag.m_128405_("JumpTrained", this.getJumpTrained());
        tag.m_128405_("HealthTrained", this.getHealthTrained());
        tag.m_128379_("IsHallow", this.isHallow());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        if (spawnType == MobSpawnType.SPAWN_EGG || ((Boolean)LivestockOverhaulCommonConfig.NATURAL_HORSE_BREEDS.get()).booleanValue()) {
            if (!ModList.get().isLoaded("deadlydinos")) {
                int[] breeds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
                int randomIndex = new Random().nextInt(breeds.length);
                this.setBreed(breeds[randomIndex]);
            } else {
                this.setBreed(random.nextInt(HorseBreed.values().length));
            }
        }
        this.setReindeerVariant(random.nextInt(OHorseModel.ReindeerVariant.values().length));
        this.setGender(random.nextInt(AbstractOMount.Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setMarkingByBreed();
            this.setFeatheringByBreed();
        } else {
            this.setVariant(random.nextInt(OHorseModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(EquineMarkingOverlay.values().length));
            this.setFeathering(random.nextInt(Feathering.values().length));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.EYES_BY_COLOR.get()).booleanValue()) {
            this.setEyeColorByChance();
        } else {
            this.setEyeVariant(random.nextInt(EquineMarkingOverlay.values().length));
        }
        int randomMane = 1 + this.m_217043_().m_188503_(3);
        this.setManeType(randomMane);
        int randomTail = 1 + this.m_217043_().m_188503_(3);
        this.setTailType(randomTail);
        this.randomizeOHorseAttributes();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)OHorseModel.Variant.BAY.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)EquineMarkingOverlay.NONE.resourceLocation.toString());
        this.f_19804_.m_135372_(REINDEER_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DECOMP, (Object)0);
        this.f_19804_.m_135372_(MANE_TYPE, (Object)0);
        this.f_19804_.m_135372_(TAIL_TYPE, (Object)0);
        this.f_19804_.m_135372_(FEATHERING, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(UNDEAD, (Object)false);
        this.f_19804_.m_135372_(DECOMPOSE, (Object)false);
        this.f_19804_.m_135372_(FLOWER_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FLOWER_TYPE, (Object)0);
        this.f_19804_.m_135372_(BRANDED, (Object)false);
        this.f_19804_.m_135372_(SPEED_TRAINED, (Object)0);
        this.f_19804_.m_135372_(JUMP_TRAINED, (Object)0);
        this.f_19804_.m_135372_(HEALTH_TRAINED, (Object)0);
        this.f_19804_.m_135372_(HALLOW, (Object)false);
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof ODonkey) && !(animal instanceof OHorse)) {
            return false;
        }
        if (!this.isSnipped() && !((AbstractOMount)animal).isSnipped()) {
            if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
                return this.m_30628_() && ((AbstractOMount)animal).m_30628_();
            }
            AbstractOMount partner = (AbstractOMount)animal;
            if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
                return this.isFemale();
            }
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        AbstractOMount foal;
        if (ageableMob instanceof ODonkey) {
            ODonkey partnerDonkey = (ODonkey)ageableMob;
            foal = (AbstractOMount)((EntityType)EntityTypes.O_MULE_ENTITY.get()).m_20615_((Level)serverLevel);
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partnerDonkey.getOverlayVariant() : this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            ((OMule)foal).setVariant(overlay);
            ((OMule)foal).setOverlayVariant(overlay);
            ((OMule)foal).setVariant(this.f_19796_.m_188503_(OMuleModel.Variant.values().length));
            if (this.isStockBreed() || this.isWarmbloodedBreed() || this.isRacingBreed()) {
                ((OMule)foal).setBreed(0);
            }
            if (this.isPonyBreed()) {
                ((OMule)foal).setBreed(1);
            }
            if (this.isDraftBreed()) {
                ((OMule)foal).setBreed(2);
            }
        } else {
            int breed;
            OHorse partner = (OHorse)ageableMob;
            foal = (AbstractOMount)((EntityType)EntityTypes.O_HORSE_ENTITY.get()).m_20615_((Level)serverLevel);
            int breedChance = this.f_19796_.m_188503_(5);
            if (breedChance == 0) {
                if (!ModList.get().isLoaded("deadlydinos")) {
                    int[] breeds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
                    int randomIndex = new Random().nextInt(breeds.length);
                    breed = breeds[randomIndex];
                } else {
                    breed = this.f_19796_.m_188503_(HorseBreed.values().length);
                }
            } else {
                breed = this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed();
            }
            ((OHorse)foal).setBreed(breed);
            if (breedChance != 0) {
                int variantChance = this.f_19796_.m_188503_(14);
                int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OHorseModel.Variant.values().length));
                ((OHorse)foal).setVariant(variant);
            } else if (breedChance == 0 && this.f_19796_.m_188500_() < 0.5) {
                ((OHorse)foal).setColorByBreed();
            }
            if (breedChance != 0) {
                int overlayChance = this.f_19796_.m_188503_(10);
                int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
                ((OHorse)foal).setOverlayVariant(overlay);
            } else if (breedChance == 0 && this.f_19796_.m_188500_() < 0.5) {
                ((OHorse)foal).setMarkingByBreed();
            }
            int eyeColorChance = this.f_19796_.m_188503_(11);
            int eyes = eyeColorChance < 5 ? this.getEyeVariant() : (eyeColorChance < 10 ? partner.getEyeVariant() : this.f_19796_.m_188503_(EquineEyeColorOverlay.values().length));
            ((OHorse)foal).setEyeVariant(eyes);
            int gender = this.f_19796_.m_188503_(AbstractOMount.Gender.values().length);
            foal.setGender(gender);
            ((OHorse)foal).setFeatheringByBreed();
            ((OHorse)foal).setManeType(3);
            ((OHorse)foal).setTailType(2);
            if (this.f_19796_.m_188503_(3) >= 1) {
                ((OHorse)foal).generateRandomOHorseJumpStrength();
                int betterSpeed = (int)Math.max(partner.m_6113_(), (float)(this.f_19796_.m_188503_(10) + 20));
                foal.m_7910_(betterSpeed);
                int betterHealth = (int)Math.max(partner.m_21223_(), (float)(this.f_19796_.m_188503_(20) + 40));
                foal.m_21153_(betterHealth);
            } else if (breedChance == 0) {
                ((OHorse)foal).randomizeOHorseAttributes();
            }
        }
        this.m_149508_(ageableMob, (AbstractHorse)foal);
        return foal;
    }

    public int getManeType() {
        return (Integer)this.f_19804_.m_135370_(MANE_TYPE);
    }

    public void setManeType(int mane) {
        this.f_19804_.m_135381_(MANE_TYPE, (Object)mane);
    }

    public int getTailType() {
        return (Integer)this.f_19804_.m_135370_(TAIL_TYPE);
    }

    public void setTailType(int tail) {
        this.f_19804_.m_135381_(TAIL_TYPE, (Object)tail);
    }

    public void setFeatheringByBreed() {
        if (this.isWarmbloodedBreed()) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() < 0.5 && this.f_19796_.m_188500_() > 0.05) {
                this.setFeathering(1);
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setFeathering(0);
            } else {
                this.setFeathering(0);
            }
        }
        if (this.isDraftBreed()) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setFeathering(0);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.05) {
                this.setFeathering(1);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setFeathering(2);
            } else {
                this.setFeathering(2);
            }
        }
        if (this.isPonyBreed()) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setFeathering(0);
            } else if (this.f_19796_.m_188500_() < 0.5 && this.f_19796_.m_188500_() > 0.15) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setFeathering(1);
            } else {
                this.setFeathering(1);
            }
        }
        if (this.isRacingBreed()) {
            if (this.f_19796_.m_188500_() < 0.03) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() < 0.08 && this.f_19796_.m_188500_() > 0.03) {
                this.setFeathering(1);
            } else if (this.f_19796_.m_188500_() > 0.08) {
                this.setFeathering(0);
            } else {
                this.setFeathering(0);
            }
        }
        if (this.isStockBreed()) {
            if (this.f_19796_.m_188500_() < 0.03) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() < 0.2 && this.f_19796_.m_188500_() > 0.03) {
                this.setFeathering(1);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setFeathering(0);
            } else {
                this.setFeathering(0);
            }
        }
    }

    public void setEyeColorByChance() {
        if (this.getVariant() == 24 || this.getVariant() == 25 || this.getOverlayVariant() == 2 || this.getOverlayVariant() == 8 || this.getOverlayVariant() == 9 || this.getOverlayVariant() == 10 || this.getOverlayVariant() == 15 || this.getOverlayVariant() == 17 || this.getOverlayVariant() == 20 || this.getOverlayVariant() == 24 || this.getOverlayVariant() == 26 || this.getOverlayVariant() == 32 || this.getOverlayVariant() == 34 || this.getOverlayVariant() == 36 || this.getOverlayVariant() == 37 || this.getOverlayVariant() == 38 || this.getOverlayVariant() == 39) {
            if (this.f_19796_.m_188500_() < 0.005) {
                this.setEyeVariant(7 + this.m_217043_().m_188503_(9));
            } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.005) {
                this.setEyeVariant(6);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.1) {
                this.setEyeVariant(5);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setEyeVariant(this.m_217043_().m_188503_(4));
            } else {
                this.setEyeVariant(0);
            }
        } else if (this.f_19796_.m_188500_() < 0.005) {
            this.setEyeVariant(7 + this.m_217043_().m_188503_(9));
        } else if (this.f_19796_.m_188500_() < 0.03 && this.f_19796_.m_188500_() > 0.005) {
            this.setEyeVariant(6);
        } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.03) {
            this.setEyeVariant(5);
        } else if (this.f_19796_.m_188500_() > 0.1) {
            this.setEyeVariant(this.m_217043_().m_188503_(4));
        } else {
            this.setEyeVariant(0);
        }
    }

    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
            randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                variants = new int[]{4, 5, 8, 11, 19, 25, 26, 27, 28, 29, 30, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 2, 3, 7, 9, 16, 17, 18, 20, 21};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                variants = new int[]{0, 6, 10, 12, 13, 15, 22, 23, 24, 31, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.02) {
                variants = new int[]{8, 11, 25, 31, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() < 0.2 && this.f_19796_.m_188500_() > 0.02) {
                variants = new int[]{0, 1, 3, 6, 7, 10, 12, 13, 16, 17, 18, 19, 20, 21, 26, 27, 28, 29, 30};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                variants = new int[]{2, 4, 5, 9, 15, 22, 23, 24, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OHorseModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{14};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.4) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.4) {
                variants = new int[]{0, 1, 2, 3, 6, 10, 12, 13, 17, 20, 21, 22, 26};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.02) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.02) {
                this.setVariant(2);
            }
        }
        if (this.getBreed() == 6) {
            variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
            randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
        if (this.getBreed() == 7) {
            variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
            randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() < 0.1) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{2, 4, 5, 9, 15, 22, 23, 24, 29, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 9) {
            if (this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                variants = new int[]{0, 1, 2, 3, 6, 10, 12, 13, 17, 20, 21, 22, 26, 31};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 10) {
            variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
            randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
        if (this.getBreed() == 11) {
            if (this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                variants = new int[]{0, 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 17, 25, 26, 27, 28, 29, 30};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 12) {
            if (this.f_19796_.m_188500_() < 0.1) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{0, 2, 4, 6, 10, 12, 13, 15, 17, 21, 22, 23, 24, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 13) {
            if (this.f_19796_.m_188500_() < 0.1) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{7, 8, 11, 15, 16, 18, 19, 23, 24, 25, 26, 27, 19, 30, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 14) {
            if (this.f_19796_.m_188500_() < 0.4) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.4) {
                variants = new int[]{2, 4, 5, 9, 15, 22, 23, 24, 29, 31, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 15) {
            if (this.f_19796_.m_188500_() < 0.05) {
                variants = new int[]{4, 5, 8, 11, 19, 25, 26, 27, 28, 29, 30, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 2, 3, 7, 9, 16, 17, 18, 20, 21};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                variants = new int[]{0, 6, 10, 12, 13, 15, 22, 23, 24, 31, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
    }

    public void setMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.2) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.2) {
                variants = new int[]{0, 4, 6, 7, 11, 12, 13, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.3) {
                variants = new int[]{0, 4, 14, 19, 21, 22, 23, 29, 33, 35, 38, 41, 42};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{0, 4, 14, 19, 21, 22, 23, 29, 33, 35, 39, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.3) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 6) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                variants = new int[]{1, 3, 6, 8, 9, 10, 12, 15, 16, 17, 20, 24, 25, 27, 28, 30, 31, 34, 36, 37, 40};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 7) {
            this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                variants = new int[]{0, 2, 4, 5, 6, 7, 11, 12, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 9) {
            if (this.f_19796_.m_188500_() < 0.2) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.2) {
                variants = new int[]{0, 4, 6, 7, 14, 19, 21, 22, 23, 29, 32, 33, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 10) {
            if (this.f_19796_.m_188500_() < 0.2) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 11) {
            if (this.f_19796_.m_188500_() < 0.5) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 12) {
            if (this.f_19796_.m_188500_() < 0.07) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.07) {
                variants = new int[]{0, 2, 4, 5, 6, 7, 11, 12, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 13) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 14) {
            if (this.f_19796_.m_188500_() < 0.3) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.3) {
                variants = new int[]{0, 2, 4, 5, 6, 7, 11, 12, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 15) {
            if (this.f_19796_.m_188500_() < 0.2) {
                this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.2) {
                variants = new int[]{0, 4, 6, 7, 11, 12, 13, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            if (this.isDraftBreed()) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)LOItems.HORSE.get(), 2);
                    this.m_20000_((ItemLike)LOItems.HORSE_RIB_STEAK.get(), 2);
                    this.m_20000_((ItemLike)LOItems.HORSE_SIRLOIN_STEAK.get(), 2);
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)LOItems.HORSE.get());
                    this.m_19998_((ItemLike)LOItems.HORSE_RIB_STEAK.get());
                    this.m_19998_((ItemLike)LOItems.HORSE_SIRLOIN_STEAK.get());
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            }
            if (this.isWarmbloodedBreed() && random.nextDouble() < 0.2) {
                this.m_19998_((ItemLike)LOItems.HORSE.get());
                this.m_19998_((ItemLike)LOItems.HORSE_RIB_STEAK.get());
                this.m_19998_((ItemLike)LOItems.HORSE_SIRLOIN_STEAK.get());
                this.m_19998_((ItemLike)Items.f_42454_);
            }
            if (this.isStockBreed() && random.nextDouble() < 0.1) {
                this.m_19998_((ItemLike)LOItems.HORSE.get());
                this.m_19998_((ItemLike)LOItems.HORSE_RIB_STEAK.get());
                this.m_19998_((ItemLike)LOItems.HORSE_SIRLOIN_STEAK.get());
                this.m_19998_((ItemLike)Items.f_42454_);
            }
            if (ModList.get().isLoaded("create")) {
                ResourceLocation resourceLocation = new ResourceLocation("create", "superglue");
                Item createSuperglue = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (random.nextDouble() < 0.25) {
                    this.m_19983_(createSuperglue.m_7968_());
                }
            }
        }
    }

    public static enum Feathering {
        NONE,
        HALF,
        FULL;


        public Feathering next() {
            return Feathering.values()[(this.ordinal() + 1) % Feathering.values().length];
        }
    }

    public static enum Tail {
        TIED,
        LONG,
        AVERAGE,
        SHORT,
        TUCKED;


        public Tail next() {
            return Tail.values()[(this.ordinal() + 1) % Tail.values().length];
        }
    }

    public static enum Mane {
        BUTTONS,
        LONG,
        ROACHED,
        SHORT,
        NONE;


        public Mane next() {
            return Mane.values()[(this.ordinal() + 1) % Mane.values().length];
        }
    }
}

