/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.horse;

import com.dragn0007.dragnlivestock.entities.horse.HorseBreed;
import com.dragn0007.dragnlivestock.entities.horse.OHorse;
import com.dragn0007.dragnlivestock.entities.horse.OHorseDecompLayer;
import java.time.LocalDate;
import java.time.Month;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OHorseModel
extends DefaultedEntityGeoModel<OHorse> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_horse.animation.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/horse/baby_o_horse.geo.json");
    public static final ResourceLocation REINDEER_MODEL = new ResourceLocation("dragnlivestock", "geo/caribou.geo.json");
    LocalDate date = LocalDate.now();
    Month month = this.date.getMonth();
    int day = this.date.getDayOfMonth();
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public OHorseModel() {
        super(new ResourceLocation("dragnlivestock", "o_horse"), true);
    }

    public void setCustomAnimations(OHorse animatable, long instanceId, AnimationState<OHorse> animationState) {
        float maxYaw;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone reins = this.getAnimationProcessor().getBone("reins");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (animatable.isWearingMartingale() && animatable.m_6254_()) {
            neck.setRotX(neck.getRotX() + (entityData.headPitch() * ((float)Math.PI / 180) - 0.2f));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        } else if (animatable.m_20096_()) {
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (animatable.isWearingMartingale() && animatable.m_6254_()) {
            head.setRotX(head.getRotX() + (entityData.headPitch() * ((float)Math.PI / 180) - 0.2f));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
            reins.setRotX(0.61745334f);
        }
    }

    public ResourceLocation getModelResource(OHorse object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        if (!(object.m_6162_() || this.month != Month.DECEMBER || this.day != 24 && this.day != 25)) {
            return REINDEER_MODEL;
        }
        return HorseBreed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(OHorse object) {
        if (!object.isUndead() && object.getDecompVariant() < 3) {
            if (this.month == Month.DECEMBER && (this.day == 24 || this.day == 25)) {
                return object.getReindeerTextureResource();
            }
            return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
        }
        if (object.getDecompVariant() == 4) {
            return OHorseDecompLayer.UndeadStage.SKELETAL.resourceLocation;
        }
        if (object.getDecompVariant() == 5) {
            return OHorseDecompLayer.UndeadStage.WITHER.resourceLocation;
        }
        if (object.getDecompVariant() == 6) {
            return OHorseDecompLayer.UndeadStage.STRAY.resourceLocation;
        }
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(OHorse animatable) {
        return ANIMATION;
    }

    public static enum ReindeerVariant {
        BAY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/bay.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/blue.png")),
        CHAMPAGNE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/champagne.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/chestnut.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/chocolate.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/cream.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/grey.png")),
        IVORY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/ivory.png")),
        LIGHT_GREY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/light_grey.png")),
        LIVER(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/liver_chestnut.png")),
        PALAMINO(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/palamino.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/red.png")),
        SEAL(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/seal.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/strawberry.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/reindeer/white.png"));

        public final ResourceLocation resourceLocation;

        private ReindeerVariant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static ReindeerVariant reindeerVariantFromOrdinal(int christmasVariant) {
            return ReindeerVariant.values()[christmasVariant % ReindeerVariant.values().length];
        }
    }

    public static enum Variant {
        BAY(new ResourceLocation("dragnlivestock", "textures/entity/horse/bay.png")),
        BAY_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/horse/bay_roan.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/horse/black.png")),
        BLOOD_BAY(new ResourceLocation("dragnlivestock", "textures/entity/horse/blood_bay.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/horse/blue.png")),
        BLUE_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/horse/blue_roan.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/horse/brown.png")),
        BUCKSKIN(new ResourceLocation("dragnlivestock", "textures/entity/horse/buckskin.png")),
        CHAMPAGNE(new ResourceLocation("dragnlivestock", "textures/entity/horse/champagne.png")),
        CHOCOLATE_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/horse/chocolate_roan.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/horse/chestnut.png")),
        CREAMY(new ResourceLocation("dragnlivestock", "textures/entity/horse/creamy.png")),
        DARK_BAY(new ResourceLocation("dragnlivestock", "textures/entity/horse/dark_bay.png")),
        DARK_BROWN(new ResourceLocation("dragnlivestock", "textures/entity/horse/dark_brown.png")),
        FJORD(new ResourceLocation("dragnlivestock", "textures/entity/horse/fjord.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/horse/grey.png")),
        IVORY(new ResourceLocation("dragnlivestock", "textures/entity/horse/ivory.png")),
        LIVER_CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/horse/liver_chestnut.png")),
        PALAMINO(new ResourceLocation("dragnlivestock", "textures/entity/horse/palamino.png")),
        PALAMINO_ORANGE(new ResourceLocation("dragnlivestock", "textures/entity/horse/palamino_orange.png")),
        SEAL_BAY(new ResourceLocation("dragnlivestock", "textures/entity/horse/seal_bay.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/horse/strawberry.png")),
        WARM_BLACK(new ResourceLocation("dragnlivestock", "textures/entity/horse/warm_black.png")),
        WARM_GREY(new ResourceLocation("dragnlivestock", "textures/entity/horse/warm_grey.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/horse/white.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/horse/cream.png")),
        RED_DUN(new ResourceLocation("dragnlivestock", "textures/entity/horse/red_dun.png")),
        BAY_DUN(new ResourceLocation("dragnlivestock", "textures/entity/horse/bay_dun.png")),
        GRULLA(new ResourceLocation("dragnlivestock", "textures/entity/horse/grulla.png")),
        BLUE_DUN(new ResourceLocation("dragnlivestock", "textures/entity/horse/blue_dun.png")),
        CINNAMON(new ResourceLocation("dragnlivestock", "textures/entity/horse/cinnamon.png")),
        STRAWBERRY_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/horse/strawberry_roan.png")),
        GOLD(new ResourceLocation("dragnlivestock", "textures/entity/horse/gold.png")),
        SILVER(new ResourceLocation("dragnlivestock", "textures/entity/horse/silver.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

