/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.unicorn;

import com.dragn0007.dragnlivestock.entities.horse.OHorseModel;
import com.dragn0007.dragnlivestock.entities.unicorn.Unicorn;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class UnicornModel
extends DefaultedEntityGeoModel<Unicorn> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/unicorn.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_horse.animation.json");
    public static final ResourceLocation BABY = new ResourceLocation("dragnlivestock", "geo/horse/baby_o_horse.geo.json");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public UnicornModel() {
        super(new ResourceLocation("dragnlivestock", "unicorn"), true);
    }

    public void setCustomAnimations(Unicorn animatable, long instanceId, AnimationState<Unicorn> animationState) {
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        if (neck != null && animatable.m_20096_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            float maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Unicorn object) {
        if (object.m_6162_()) {
            return BABY;
        }
        return MODEL;
    }

    public ResourceLocation getTextureResource(Unicorn object) {
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(Unicorn animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BAY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/bay.png")),
        BAY_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/bay_roan.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/black.png")),
        BLOOD_BAY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/blood_bay.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/blue.png")),
        BLUE_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/blue_roan.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/brown.png")),
        BUCKSKIN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/buckskin.png")),
        CHAMPAGNE(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/champagne.png")),
        CHOCOLATE_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/chocolate_roan.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/chestnut.png")),
        CREAMY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/creamy.png")),
        DARK_BAY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/dark_bay.png")),
        DARK_BROWN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/dark_brown.png")),
        FJORD(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/fjord.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/grey.png")),
        IVORY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/ivory.png")),
        LIVER_CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/liver_chestnut.png")),
        PALAMINO(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/palamino.png")),
        PALAMINO_ORANGE(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/palamino_orange.png")),
        SEAL_BAY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/seal_bay.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/strawberry.png")),
        WARM_BLACK(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/warm_black.png")),
        WARM_GREY(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/warm_grey.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/white.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/cream.png")),
        RED_DUN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/red_dun.png")),
        BAY_DUN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/bay_dun.png")),
        GRULLA(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/grulla.png")),
        BLUE_DUN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/blue_dun.png")),
        CINNAMON(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/cinnamon.png")),
        END(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/end.png")),
        STRAWBERRY_ROAN(new ResourceLocation("dragnlivestock", "textures/entity/unicorn/strawberry_roan.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % OHorseModel.Variant.values().length];
        }
    }
}

