/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.util;

import com.dragn0007.dragnlivestock.common.gui.OMountMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.camel.CamelBreed;
import com.dragn0007.dragnlivestock.entities.camel.OCamel;
import com.dragn0007.dragnlivestock.entities.cow.OCow;
import com.dragn0007.dragnlivestock.entities.farm_goat.FarmGoat;
import com.dragn0007.dragnlivestock.entities.farm_goat.GoatBreed;
import com.dragn0007.dragnlivestock.entities.goat.OGoat;
import com.dragn0007.dragnlivestock.entities.horse.HorseBreed;
import com.dragn0007.dragnlivestock.entities.horse.OHorse;
import com.dragn0007.dragnlivestock.entities.horse.OHorseModel;
import com.dragn0007.dragnlivestock.entities.mule.MuleBreed;
import com.dragn0007.dragnlivestock.entities.mule.OMule;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.EquineMarkingOverlay;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.LightHorseArmorItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.time.LocalDate;
import java.time.Month;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOMount
extends AbstractChestedHorse {
    public LazyOptional<?> itemHandler = null;
    public static final float MAX_HEALTH = AbstractOMount.m_271722_(p_272504_ -> p_272504_ - 1);
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_HORSE_EATS);
    public static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("3c50e848-b2e3-404a-9879-7550b12dd09b");
    public static final UUID SPRINT_SPEED_MOD_UUID = UUID.fromString("c9379664-01b5-4e19-a7e9-11264453bdce");
    public static final UUID TROT_SPEED_MOD_UUID = UUID.fromString("b0c44eda-c7c8-4c2f-abc1-f351d8bfc972");
    public static final UUID WALK_SPEED_MOD_UUID = UUID.fromString("59b55c98-e39b-45e2-846c-f91f3e9ea861");
    public static final AttributeModifier SPRINT_SPEED_MOD = new AttributeModifier(SPRINT_SPEED_MOD_UUID, "Sprint speed mod", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier TROT_SPEED_MOD = new AttributeModifier(TROT_SPEED_MOD_UUID, "Trot speed mod", -0.4, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier WALK_SPEED_MOD = new AttributeModifier(WALK_SPEED_MOD_UUID, "Walk speed mod", -0.7, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final EntityDataAccessor<ItemStack> DECOR_ITEM = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<ItemStack> SADDLE_ITEM = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public boolean shouldEmote;
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LOCKED = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SNIPPED = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> FLOWER_ITEM = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Integer> FLOWER_TYPE = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> BRANDED = SynchedEntityData.m_135353_(AbstractOMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SimpleContainer getInventory() {
        return this.f_30520_;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public int m_8132_() {
        return 40;
    }

    public int m_8085_() {
        return 60;
    }

    public int m_30624_() {
        return this.f_30521_;
    }

    public void m_30649_(int temper) {
        this.f_30521_ = temper;
    }

    public int m_30653_(int p_30654_) {
        int i = Mth.m_14045_((int)(this.m_30624_() + p_30654_), (int)0, (int)this.m_7555_());
        this.m_30649_(i);
        return i;
    }

    public boolean isWearingHarness() {
        return this.isWearingPullingHarness() || this.isWearingRodeoHarness();
    }

    public boolean isWearingRodeoHarness() {
        return this.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)LOItems.RODEO_HARNESS.get()) && !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isWearingPullingHarness() {
        return this.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)LOItems.WAGON_HARNESS.get()) && !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isWearingMartingale() {
        return this.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)LOItems.MARTINGALE_HARNESS.get()) && !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public void m_274498_(Player player, Vec3 vec3) {
        Vec2 vec2 = this.m_274391_((LivingEntity)player);
        float degrees = Mth.m_14177_((float)(vec2.f_82471_ - this.m_146908_()));
        float playerXRot = vec2.f_82470_;
        this.m_146926_(vec2.f_82470_);
        this.f_19860_ = this.m_146909_();
        float yRot = this.m_146908_();
        float maxHeadYRot = 25.0f;
        this.f_20885_ = yRot + Mth.m_14036_((float)degrees, (float)(-maxHeadYRot), (float)maxHeadYRot);
        this.m_146926_(playerXRot);
        this.f_19860_ = this.m_146909_();
        if (((Boolean)LivestockOverhaulCommonConfig.OLD_HORSE_TURNING.get()).booleanValue()) {
            if (Math.abs(degrees) > maxHeadYRot) {
                float turnSpeed = 8.0f;
                float yaw = yRot + Mth.m_14036_((float)degrees, (float)(-turnSpeed), (float)turnSpeed);
                this.m_146922_(yaw);
                this.f_19859_ = yaw;
                this.f_20883_ = yaw;
            }
        } else {
            this.m_19915_(vec2.f_82471_, vec2.f_82470_);
            this.f_20883_ = this.f_20885_ = this.m_146908_();
            this.f_19859_ = this.f_20885_;
        }
        if (this.m_6109_()) {
            if (vec3.f_82481_ <= 0.0) {
                this.f_30524_ = 0;
            }
            if (this.m_20096_()) {
                this.m_30655_(false);
                if (this.f_30522_ > 0.0f && !this.m_30616_()) {
                    this.m_245980_(this.f_30522_, vec3);
                }
                this.f_30522_ = 0.0f;
            }
        }
    }

    public Vec3 m_274312_(Player player, Vec3 vec3) {
        if (this.m_20096_() && this.f_30522_ == 0.0f && this.m_30622_() && !this.f_30510_) {
            return Vec3.f_82478_;
        }
        float strafe = player.f_20900_ * 0.5f;
        float forward = player.f_20902_;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        return new Vec3((double)strafe, 0.0, (double)forward);
    }

    public boolean isGroundTied() {
        return this.m_6254_() && !this.m_20160_() && (Boolean)LivestockOverhaulCommonConfig.GROUND_TIE.get() != false;
    }

    public boolean isOnSand() {
        BlockState blockState = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        return blockState.m_204336_(LOTags.Blocks.SAND);
    }

    public boolean isOnSnow() {
        BlockState blockState = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        return blockState.m_60713_(Blocks.f_50125_) || blockState.m_60713_(Blocks.f_50127_) || blockState.m_60713_(Blocks.f_152499_);
    }

    public void applySlownessEffect() {
        MobEffectInstance slownessEffectInstance = new MobEffectInstance(MobEffects.f_19597_, 200, 1, false, false);
        this.m_7292_(slownessEffectInstance);
    }

    public boolean hasSlownessEffect() {
        return this.m_21023_(MobEffects.f_19597_);
    }

    public void removeSlownessEffect() {
        this.m_21195_(MobEffects.f_19597_);
    }

    public AbstractOMount(EntityType<? extends AbstractOMount> entityType, Level level) {
        super(entityType, level);
    }

    public abstract void playEmote(String var1, String var2);

    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_() && (this.isOwnedBy((LivingEntity)player) && this.isLocked() || !this.isLocked())) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new OMountMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public void m_30625_() {
        SimpleContainer simplecontainer = this.f_30520_;
        this.f_30520_ = new SimpleContainer(this.m_7506_());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.f_30520_.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.f_30520_.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.f_30520_.m_19164_((ContainerListener)this);
        this.m_7493_();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.f_30520_));
    }

    public void m_213583_(Player player) {
        this.openInventory(player);
    }

    public boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && this.m_30614_() && !this.m_6162_() && this.m_27593_();
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_30614_();
    }

    public boolean m_6254_() {
        return !((ItemStack)this.f_19804_.m_135370_(SADDLE_ITEM)).m_41619_();
    }

    public boolean isSaddle(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof SaddleItem;
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
    }

    public void setSaddleItem(ItemStack itemStack) {
        this.f_19804_.m_135381_(SADDLE_ITEM, (Object)itemStack);
    }

    public ItemStack getSaddleItem() {
        return (ItemStack)this.f_19804_.m_135370_(SADDLE_ITEM);
    }

    public boolean m_6010_(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof HorseArmorItem || itemStack.m_204117_(LOTags.Items.ARMOR_FOR_O_MOUNTS) || itemStack.m_41720_() instanceof LightHorseArmorItem;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.25;
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean hasGrowableHair() {
        return false;
    }

    protected boolean m_7310_(Entity p_20354_) {
        return super.m_7310_(p_20354_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack1;
        OHorse oHorse;
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) && player.m_6144_() && this.isOwnedBy((LivingEntity)player)) {
            if (this.isEquine((Entity)this)) {
                AbstractOMount equine = this;
                equine.setFlowerType(0);
                equine.setFlowerItem(Items.f_41852_.m_7968_());
            }
            if (this.m_30502_() && this.isOwnedBy((LivingEntity)player)) {
                this.m_5907_();
                this.f_30520_.m_19195_();
                this.m_30504_(false);
                this.m_7609_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (itemStack.m_150930_((Item)LOItems.MOUNT_KEY.get()) && player.m_6144_() && this.isOwnedBy((LivingEntity)player) && this.m_30614_()) {
            if (!this.isLocked()) {
                this.setLocked(true);
                if (((Boolean)LivestockOverhaulCommonConfig.DEBUG_LOGS.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)("Mount Locked, [DEBUG]Owned By: " + this.m_269323_())).m_130940_(ChatFormatting.GOLD), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"Mount Locked").m_130940_(ChatFormatting.GOLD), true);
                }
            } else {
                this.setLocked(false);
                if (((Boolean)LivestockOverhaulCommonConfig.DEBUG_LOGS.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)("Mount Unlocked, [DEBUG]Owned By: " + this.m_269323_())).m_130940_(ChatFormatting.GOLD), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"Mount Unlocked").m_130940_(ChatFormatting.GOLD), true);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.MANE_SCISSORS.get()) && this.hasGrowableHair() && (this.isOwnedBy((LivingEntity)player) || !this.m_30614_())) {
            oHorse = (OHorse)this;
            if (player.m_6144_() && ((Boolean)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH.get()).booleanValue()) {
                if (oHorse.getManeType() == 3 || oHorse.getManeType() == 2) {
                    oHorse.setManeType(0);
                } else if (oHorse.getManeType() == 0) {
                    oHorse.setManeType(3);
                }
            } else if (!player.m_6144_() && oHorse.getManeType() < 4 || !((Boolean)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH.get()).booleanValue()) {
                OHorse.Mane currentMane = OHorse.Mane.values()[oHorse.getManeType()];
                OHorse.Mane nextMane = currentMane.next();
                oHorse.maneGrowthTick = 0;
                oHorse.setManeType(nextMane.ordinal());
            }
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.TAIL_SCISSORS.get()) && this.hasGrowableHair() && !this.isUnicorn((Entity)this) && (this.isOwnedBy((LivingEntity)player) || !this.m_30614_())) {
            oHorse = (OHorse)this;
            if (player.m_6144_() && ((Boolean)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH.get()).booleanValue()) {
                if (oHorse.getTailType() == 3 || oHorse.getTailType() == 2) {
                    oHorse.setTailType(0);
                } else if (oHorse.getTailType() == 0) {
                    oHorse.setTailType(3);
                }
            } else if (!player.m_6144_() && oHorse.getTailType() < 4 || !((Boolean)LivestockOverhaulCommonConfig.HORSE_HAIR_GROWTH.get()).booleanValue()) {
                OHorse.Tail currentTail = OHorse.Tail.values()[oHorse.getTailType()];
                OHorse.Tail nextTail = currentTail.next();
                oHorse.tailGrowthTick = 0;
                oHorse.setTailType(nextTail.ordinal());
            }
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42201_) && this.isHorse((Entity)this) && (player.m_150110_().f_35937_ && ((Boolean)LivestockOverhaulCommonConfig.CREATIVE_BRANDING.get()).booleanValue() || !((Boolean)LivestockOverhaulCommonConfig.CREATIVE_BRANDING.get()).booleanValue()) && !(oHorse = (OHorse)this).isBranded() && (!oHorse.m_30614_() || player.m_150110_().f_35937_)) {
            oHorse.setIsBranded(true);
            this.m_5496_(SoundEvents.f_12031_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.UTILITY_KNIFE.get()) && (player.m_150110_().f_35937_ && ((Boolean)LivestockOverhaulCommonConfig.CREATIVE_SNIPPING.get()).booleanValue() || !((Boolean)LivestockOverhaulCommonConfig.CREATIVE_SNIPPING.get()).booleanValue()) && (this.isOwnedBy((LivingEntity)player) || player.m_150110_().f_35937_ || !this.m_30614_()) && !(this instanceof OGoat) && !(this instanceof FarmGoat) && !(this instanceof OCow) && player.m_6144_() && !this.isSnipped()) {
            this.setSnipped(true);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_42546_) && player.m_150110_().f_35937_ && player.m_6144_() && this.isSnipped()) {
            this.setSnipped(false);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_ && (this.isHorse((Entity)this) || this.isMule((Entity)this) || this.isCamel((Entity)this) || this instanceof FarmGoat)) {
            Enum nextBreed;
            Enum currentBreed;
            if (player.m_6144_() && this.getBreed() > 0) {
                this.setBreed(this.getBreed() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.isHorse((Entity)this)) {
                oHorse = (OHorse)this;
                currentBreed = HorseBreed.values()[oHorse.getBreed()];
                nextBreed = ((HorseBreed)currentBreed).next();
                oHorse.setBreed(nextBreed.ordinal());
            }
            if (this.isMule((Entity)this)) {
                OMule mule = (OMule)this;
                currentBreed = MuleBreed.values()[mule.getBreed()];
                nextBreed = ((MuleBreed)currentBreed).next();
                mule.setBreed(nextBreed.ordinal());
            }
            if (this.isCamel((Entity)this)) {
                OCamel camel = (OCamel)this;
                currentBreed = CamelBreed.Breed.values()[camel.getBreed()];
                nextBreed = ((CamelBreed.Breed)currentBreed).next();
                camel.setBreed(nextBreed.ordinal());
            }
            if (this instanceof FarmGoat) {
                FarmGoat goat = (FarmGoat)this;
                currentBreed = GoatBreed.Breed.values()[goat.getBreed()];
                nextBreed = ((GoatBreed.Breed)currentBreed).next();
                goat.setBreed(nextBreed.ordinal());
            }
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.isEquine((Entity)this) && this.isOwnedBy((LivingEntity)player)) {
            AbstractOMount mount = this;
            if (this.isEquine((Entity)this) && itemStack.m_204117_(LOTags.Items.HAIR_FLOWERS)) {
                if (mount.getFlowerType() == 0) {
                    mount.setFlowerType(1);
                } else if (mount.getFlowerType() == 1) {
                    mount.setFlowerType(2);
                } else if (mount.getFlowerType() == 2) {
                    mount.setFlowerType(0);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                mount.setFlowerItem(itemStack);
                this.m_5496_(SoundEvents.f_144144_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isHorse((Entity)this) && itemStack.m_150930_(Items.f_42716_) && this.isOwnedBy((LivingEntity)player)) {
            oHorse = (OHorse)this;
            if (oHorse.isUndead()) {
                oHorse.setDecompVariant(0);
                oHorse.setUndead(false);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123767_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isHorse((Entity)this) && itemStack.m_150930_(Items.f_42413_) && this.isOwnedBy((LivingEntity)player)) {
            oHorse = (OHorse)this;
            if (oHorse.isUndead()) {
                itemStack.m_41671_(this.m_9236_(), (LivingEntity)player);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
                if (oHorse.canDecompose()) {
                    oHorse.setCanDecompose(false);
                } else if (!oHorse.canDecompose()) {
                    oHorse.setCanDecompose(true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isHorse((Entity)this) && itemStack.m_150930_((Item)LOItems.HALLOW_HEART.get()) && this.isOwnedBy((LivingEntity)player)) {
            LocalDate date = LocalDate.now();
            Month month = date.getMonth();
            int day = date.getDayOfMonth();
            OHorse oHorse2 = (OHorse)this;
            if (month == Month.OCTOBER && day == 31 || month == Month.NOVEMBER && (day == 1 || day == 2) && !oHorse2.isHallow()) {
                AttributeInstance speedAttribute = oHorse2.m_21051_(Attributes.f_22279_);
                assert (speedAttribute != null);
                double speedValue = speedAttribute.m_22115_();
                speedAttribute.m_22100_(speedValue + 0.02);
                AttributeInstance healthAttribute = oHorse2.m_21051_(Attributes.f_22276_);
                assert (healthAttribute != null);
                double healthValue = healthAttribute.m_22115_();
                healthAttribute.m_22100_(healthValue + 10.0);
                oHorse2.setHallow(true);
                oHorse2.setUndead(true);
                oHorse2.setCanDecompose(false);
                oHorse2.setVariant(2);
                oHorse2.setOverlayVariant(0);
                oHorse2.setEyeVariant(10);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12404_, SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.m_6162_()) {
            if (this.m_30614_() && player.m_36341_()) {
                this.openInventory(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_20160_()) {
                if (this.m_7310_((Entity)this)) {
                    this.m_6835_(player);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                return super.m_6071_(player, hand);
            }
        }
        if (itemStack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (this.isSaddle(itemStack) && this.m_6741_() && !this.m_6254_()) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_220400_((Entity)this, GameEvent.f_157811_, this.m_20182_());
                ItemStack saddleItem = itemStack.m_41777_();
                this.f_30520_.m_6836_(this.saddleSlot(), saddleItem);
                itemStack.m_41774_(1);
                this.setSaddleItem(saddleItem);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!itemStack.m_41619_()) {
            boolean canSaddle;
            if (this.m_6898_(itemStack)) {
                return this.m_30580_(player, itemStack);
            }
            InteractionResult interactionResult = itemStack.m_41647_(player, (LivingEntity)this, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            if (!this.m_30614_()) {
                this.m_7564_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_30502_() && itemStack.m_150930_(Blocks.f_50087_.m_5456_()) && this.isOwnedBy((LivingEntity)player)) {
                this.m_30504_(true);
                this.m_7609_();
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_30625_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            boolean bl = canSaddle = !this.m_6162_() && !this.m_6254_() && this.isSaddle(itemStack);
            if (this.m_6010_(itemStack) || canSaddle) {
                this.openInventory(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (itemStack.m_204117_(LOTags.Items.SWEM_CANTAZARITE_POTION) && this.isHorse((Entity)this) && this.isOwnedBy((LivingEntity)player)) {
            if (!player.m_9236_().f_46443_) {
                AbstractOMount entity = this;
                ResourceLocation swemHorseId = new ResourceLocation("swem", "swem_horse");
                EntityType swemHorseType = EntityType.m_20632_((String)swemHorseId.toString()).orElse(null);
                if (swemHorseType != null) {
                    Entity newEntity = swemHorseType.m_20615_(entity.m_9236_());
                    if (newEntity != null) {
                        newEntity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_());
                        entity.m_9236_().m_7967_(newEntity);
                        entity.m_146870_();
                    }
                } else {
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        if (!(this instanceof FarmGoat)) {
            this.m_6835_(player);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_6835_(Player player) {
        this.m_30661_(false);
        this.m_30665_(false);
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            if (this.isLocked() && this.isOwnedBy((LivingEntity)player) || !this.isLocked() || !this.m_30614_()) {
                player.m_20329_((Entity)this);
            }
        }
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(LOCKED);
    }

    public void setLocked(boolean locked) {
        this.f_19804_.m_135381_(LOCKED, (Object)locked);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)false);
        this.f_19804_.m_135372_(DECOR_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(SADDLE_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(LOCKED, (Object)false);
        this.f_19804_.m_135372_(SNIPPED, (Object)false);
    }

    public ItemStack getDecorItem() {
        return (ItemStack)this.f_19804_.m_135370_(DECOR_ITEM);
    }

    public void setDecorItem(ItemStack decorItem) {
        this.f_19804_.m_135381_(DECOR_ITEM, (Object)decorItem);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (!this.getSaddleItem().m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.getSaddleItem().m_41739_(new CompoundTag()));
        }
        if (!this.getArmor().m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.getArmor().m_41739_(new CompoundTag()));
        }
        if (!this.getDecorItem().m_41619_()) {
            compoundTag.m_128365_("DecorItem", (Tag)this.getDecorItem().m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("Locked", this.isLocked());
        compoundTag.m_128379_("IsSnipped", this.isSnipped());
        if (this.m_30502_()) {
            ListTag listtag = new ListTag();
            for (int i = 2; i < this.f_30520_.m_6643_(); ++i) {
                ItemStack itemstack = this.f_30520_.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            compoundTag.m_128365_("Items", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("SaddleItem")) {
            ItemStack saddleItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"));
            this.setSaddleItem(saddleItem);
            this.f_30520_.m_6836_(this.saddleSlot(), saddleItem);
        }
        if (compoundTag.m_128441_("ArmorItem")) {
            ItemStack armorItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"));
            this.setArmorEquipment(armorItem);
            this.f_30520_.m_6836_(this.armorSlot(), armorItem);
        }
        if (compoundTag.m_128441_("DecorItem")) {
            ItemStack decorItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("DecorItem"));
            this.setDecorItem(decorItem);
            this.f_30520_.m_6836_(this.decorSlot(), decorItem);
        }
        if (compoundTag.m_128441_("Locked")) {
            this.setLocked(compoundTag.m_128471_("Locked"));
        }
        if (compoundTag.m_128441_("IsSnipped")) {
            this.setSnipped(compoundTag.m_128471_("IsSnipped"));
        }
        if (this.m_30502_()) {
            ListTag listtag = compoundTag.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.f_30520_.m_6643_()) continue;
                this.f_30520_.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        this.m_7493_();
    }

    public void m_5877_(SoundType soundType) {
        ItemStack itemStack;
        super.m_5877_(soundType);
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_(SoundEvents.f_11974_, soundType.m_56773_() * 0.6f, soundType.m_56774_());
        }
        if (this.m_6010_(itemStack = this.f_30520_.m_8020_(1))) {
            itemStack.onHorseArmorTick(this.m_9236_(), (Mob)this);
        }
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            Item protection2;
            Object horseArmorItem;
            int protection2;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof HorseArmorItem && (protection2 = (horseArmorItem = (HorseArmorItem)item).m_41368_()) > 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)protection2, AttributeModifier.Operation.ADDITION));
            }
            if ((protection2 = itemStack.m_41720_()) instanceof LightHorseArmorItem && (protection = ((LightHorseArmorItem)((Object)(horseArmorItem = (LightHorseArmorItem)protection2))).getProtection()) > 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Light armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddleItem(this.f_30520_.m_8020_(this.saddleSlot()));
            this.setArmorEquipment(this.f_30520_.m_8020_(this.armorSlot()));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
            this.setDecorItem(this.f_30520_.m_8020_(this.decorSlot()));
        }
    }

    public int saddleSlot() {
        return 0;
    }

    public int armorSlot() {
        return 1;
    }

    public int decorSlot() {
        return 2;
    }

    public void m_5757_(Container container) {
        ItemStack prevArmor = this.getArmor();
        super.m_5757_(container);
        ItemStack newArmor = this.getArmor();
        if (this.f_19797_ > 20 && this.m_6010_(newArmor) && prevArmor != newArmor) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        this.m_21051_(Attributes.f_22279_).m_22130_(SPRINT_SPEED_MOD);
        this.m_21051_(Attributes.f_22279_).m_22130_(TROT_SPEED_MOD);
        this.m_21051_(Attributes.f_22279_).m_22130_(WALK_SPEED_MOD);
        return super.m_7688_(livingEntity);
    }

    public boolean isOx(Entity entity) {
        return entity.m_6095_() == EntityTypes.O_COW_ENTITY.get();
    }

    public boolean isHorse(Entity entity) {
        return entity.m_6095_() == EntityTypes.O_HORSE_ENTITY.get();
    }

    public boolean isUnicorn(Entity entity) {
        return entity.m_6095_() == EntityTypes.UNICORN_ENTITY.get();
    }

    public boolean isMule(Entity entity) {
        return entity.m_6095_() == EntityTypes.O_MULE_ENTITY.get();
    }

    public boolean isDonkey(Entity entity) {
        return entity.m_6095_() == EntityTypes.O_DONKEY_ENTITY.get();
    }

    public boolean isCamel(Entity entity) {
        return entity.m_6095_() == EntityTypes.O_CAMEL_ENTITY.get();
    }

    public boolean isEquine(Entity entity) {
        return entity.m_6095_() == EntityTypes.O_HORSE_ENTITY.get() || entity.m_6095_() == EntityTypes.O_DONKEY_ENTITY.get() || entity.m_6095_() == EntityTypes.O_MULE_ENTITY.get() || entity.m_6095_() == EntityTypes.UNICORN_ENTITY.get();
    }

    public void handleSpeedRequest(int speedMod) {
        AttributeInstance movementSpeed = this.m_21051_(Attributes.f_22279_);
        if (speedMod == -1 && movementSpeed.m_22109_(SPRINT_SPEED_MOD)) {
            movementSpeed.m_22130_(SPRINT_SPEED_MOD);
        } else if (speedMod == -1 && !movementSpeed.m_22109_(WALK_SPEED_MOD)) {
            movementSpeed.m_22118_(WALK_SPEED_MOD);
        } else if (speedMod == 1 && movementSpeed.m_22109_(WALK_SPEED_MOD)) {
            movementSpeed.m_22130_(WALK_SPEED_MOD);
        } else if (speedMod == 1 && !movementSpeed.m_22109_(SPRINT_SPEED_MOD) && !this.isOx((Entity)this)) {
            movementSpeed.m_22118_(SPRINT_SPEED_MOD);
        }
    }

    public boolean m_5994_(Player player, ItemStack stack) {
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean flag = false;
        if (stack.m_204117_(LOTags.Items.O_HORSE_EATS)) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.m_30614_() && this.m_146764_() == 0 && this.m_5957_()) {
                flag = true;
                this.m_27595_(player);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            flag = true;
            if (!this.m_9236_().f_46443_) {
                this.m_30653_(j);
            }
        }
        if (flag) {
            SoundEvent soundevent;
            this.m_146850_(GameEvent.f_223708_);
            if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return flag;
    }

    public boolean isSnipped() {
        return (Boolean)this.f_19804_.m_135370_(SNIPPED);
    }

    public void setSnipped(boolean snipped) {
        this.f_19804_.m_135381_(SNIPPED, (Object)snipped);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)OHorseModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)EquineMarkingOverlay.overlayFromOrdinal((int)variant).resourceLocation.toString());
    }

    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public ResourceLocation getModelResource() {
        return HorseBreed.breedFromOrdinal((int)this.getBreed()).resourceLocation;
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public ItemStack getFlowerItem() {
        return (ItemStack)this.f_19804_.m_135370_(FLOWER_ITEM);
    }

    public void setFlowerItem(ItemStack decorItem) {
        this.f_19804_.m_135381_(FLOWER_ITEM, (Object)decorItem);
    }

    public int getFlowerType() {
        return (Integer)this.f_19804_.m_135370_(FLOWER_TYPE);
    }

    public void setFlowerType(int decompVariant) {
        this.f_19804_.m_135381_(FLOWER_TYPE, (Object)decompVariant);
    }

    public boolean isBranded() {
        return (Boolean)this.f_19804_.m_135370_(BRANDED);
    }

    public void setIsBranded(boolean canBeBranded) {
        this.f_19804_.m_135381_(BRANDED, (Object)canBeBranded);
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

