/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.wagon.base;

import com.dragn0007.dragnlivestock.client.ClientProxy;
import com.dragn0007.dragnlivestock.entities.cow.OCow;
import com.dragn0007.dragnlivestock.entities.wagon.base.AbstractGeckolibVehicle;
import com.dragn0007.dragnlivestock.util.LOTags;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractWagon
extends AbstractGeckolibVehicle {
    protected static final Random RANDOM = new Random();
    protected static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.m_135353_(AbstractWagon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.m_135353_(AbstractWagon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final double GRAVITY = 0.04;
    protected static final double HORIZONTAL_TETHER = 0.25;
    protected final double maxSpeed;
    protected final double acceleration;
    protected final float turnRate;
    protected final int maxHealth;
    protected double speed = 0.0;
    public UUID owner;
    protected final Vec3[] animalPositions;
    protected final Mob[] animals;
    protected final UUID[] animalUuids;

    public AbstractWagon(EntityType<? extends AbstractWagon> type, Level level, double maxSpeed, double acceleration, float turnRate, int maxHealth, Vec3[] animalPositions, double wheelWidth, double wheelLength, Vec3[] riders) {
        super(type, level, wheelWidth, wheelLength, riders);
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.turnRate = turnRate;
        this.maxHealth = maxHealth;
        this.animalPositions = animalPositions;
        this.animals = new Mob[animalPositions.length];
        this.animalUuids = new UUID[this.animals.length];
    }

    @Override
    public void m_8119_() {
        if (this.f_19803_ && this.m_9236_().f_46443_) {
            ClientProxy.createWagonSound(this);
        }
        if (!this.m_9236_().f_46443_) {
            this.validateDraughtAnimals();
        }
        super.m_8119_();
    }

    protected void validateDraughtAnimals() {
        Mob animal;
        int i;
        if (this.f_19803_ || this.m_9236_().m_46467_() % 100L == 0L) {
            for (i = 0; i < this.animals.length; ++i) {
                animal = this.tryGetDraught(i);
                if (animal == null) continue;
                this.setAnimal(animal, i);
            }
        }
        for (i = 0; i < this.animals.length; ++i) {
            animal = this.getAnimal(i);
            if ((animal == null || animal.m_21523_() || !this.isAnimalInRange(i)) && animal == null) continue;
            animal.m_21557_(true);
            if (animal.m_21523_()) {
                this.setAnimal(null, i);
                animal.m_21557_(false);
                continue;
            }
            if (this.isAnimalInRange(i)) continue;
            animal.m_146884_(this.rotateY(this.animalPositions[i], this.m_146908_()).m_82549_(this.m_20182_()));
        }
    }

    @Override
    public void tickRidden() {
        Mob animal;
        int i;
        this.handleSteering();
        this.handleAcceleration();
        Vec3 forward = this.m_20156_().m_82542_(1.0, 0.0, 1.0);
        Vec3 velocity = forward.m_82490_(this.speed);
        Vec3 move = this.m_20272_(velocity);
        for (i = 0; i < this.animals.length; ++i) {
            Vec3 m;
            animal = this.getAnimal(i);
            if (animal == null || !((m = animal.m_20272_(velocity)).m_165925_() < move.m_165925_())) continue;
            move = m;
        }
        move = move.m_82542_(1.0, 0.0, 1.0);
        if (!this.m_20068_()) {
            move = move.m_82520_(0.0, -0.04, 0.0);
        }
        for (i = 0; i < this.animals.length; ++i) {
            animal = this.getAnimal(i);
            if (animal == null) continue;
            animal.m_20256_(move.m_82520_(0.0, animal.m_20184_().f_82480_, 0.0));
            animal.m_6478_(MoverType.SELF, animal.m_20184_());
        }
        this.m_20256_(move.m_82520_(0.0, this.m_20184_().f_82480_, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_146926_(this.rotlerp(this.m_146909_(), this.calculateTargetXRot(), 3.0f));
    }

    protected void handleAcceleration() {
        float forward = this.getForwardImpulse();
        boolean isFull = true;
        for (int i = 0; i < this.animals.length; ++i) {
            if (this.getAnimal(i) != null) continue;
            isFull = false;
            break;
        }
        double targetSpeed = isFull ? (double)forward * this.maxSpeed : 0.0;
        double diff = targetSpeed - this.speed;
        double accel = this.maxSpeed / (this.acceleration * 20.0);
        this.speed += (double)Mth.m_14205_((double)(forward == 0.0f ? diff : (double)forward)) * Math.min(Math.abs(accel), Math.abs(diff));
    }

    protected void handleSteering() {
        float f = (float)(this.speed / this.maxSpeed);
        float steer = -this.getLeftImpulse() * this.turnRate * f;
        if (steer == 0.0f) {
            return;
        }
        Vec3[] displacements = new Vec3[this.animals.length];
        for (int i = 0; i < this.animals.length; ++i) {
            displacements[i] = this.collideSteering(i, steer);
            if (!displacements[i].equals((Object)Vec3.f_82478_)) continue;
            return;
        }
        this.m_146922_(Mth.m_14177_((float)(this.m_146908_() + steer)));
        float yRot = this.m_146908_();
        for (int i = 0; i < this.animals.length; ++i) {
            Mob animal = this.getAnimal(i);
            this.setAnimalPos(animal, animal.m_20182_().m_82549_(displacements[i]), yRot);
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_6084_()) {
            return InteractionResult.PASS;
        }
        boolean isClientSide = this.m_9236_().f_46443_;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ItemTags.f_13168_)) {
            if (isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (stack.m_150930_(Items.f_42647_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.OAK);
            } else if (stack.m_150930_(Items.f_42795_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.ACACIA);
            } else if (stack.m_150930_(Items.f_42753_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.BIRCH);
            } else if (stack.m_150930_(Items.f_271154_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.CHERRY);
            } else if (stack.m_150930_(Items.f_42797_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.CRIMSON);
            } else if (stack.m_150930_(Items.f_42796_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.DARK_OAK);
            } else if (stack.m_150930_(Items.f_42794_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.JUNGLE);
            } else if (stack.m_150930_(Items.f_220174_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.MANGROVE);
            } else if (stack.m_150930_(Items.f_42700_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.SPRUCE);
            } else if (stack.m_150930_(Items.f_42798_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                this.setWoodType(Type.WARPED);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (player.m_36341_()) {
            if (stack.m_204117_(ItemTags.f_271207_)) {
                if (!isClientSide && player.m_20148_().equals(this.owner)) {
                    this.onDestroyed(true);
                }
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (this.tryHitching(player) || this.tryMountMob(player)) {
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (stack.m_150930_(Items.f_42655_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                for (Entity passenger : this.m_20197_()) {
                    if (!(passenger instanceof Mob)) continue;
                    Mob mob = (Mob)passenger;
                    mob.m_8127_();
                    player.m_21120_(hand).m_41774_(1);
                    if (!mob.m_6573_(player)) break;
                    mob.m_21463_((Entity)player, true);
                    break;
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6096_(player, hand);
    }

    protected boolean tryHitching(Player player) {
        Mob animal = this.m_9236_().m_6443_(Mob.class, new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0), h -> h.m_21524_() == player && h.m_6095_().m_204039_(LOTags.Entity_Types.DRAUGHT_ANIMALS)).stream().findFirst().orElse(null);
        if (!this.m_9236_().f_46443_ && animal != null) {
            for (int i = 0; i < this.animalPositions.length; ++i) {
                if (this.getAnimal(i) != null) continue;
                this.hitch(animal, i);
                break;
            }
            animal.m_21455_(true, !player.m_7500_());
        }
        return animal != null;
    }

    protected boolean tryMountMob(Player player) {
        OCow entity;
        Mob mob = this.m_9236_().m_6443_(Mob.class, new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0), h -> h.m_21524_() == player && !h.m_6095_().m_204039_(LOTags.Entity_Types.CANNOT_MOUNT_WAGON)).stream().findFirst().orElse(null);
        if (mob != null && !this.m_9236_().f_46443_ && this.m_7310_((Entity)mob) && (!(mob instanceof OCow) || mob instanceof OCow && (entity = (OCow)mob).getBreed() != 10)) {
            mob.m_20329_((Entity)this);
        }
        return mob != null;
    }

    protected void hitch(Mob animal, int index) {
        this.setAnimal(animal, index);
        this.initDraught(animal, index);
    }

    protected void initDraught(Mob animal, int index) {
        if (animal == null) {
            return;
        }
        animal.m_20153_();
        animal.m_20256_(Vec3.f_82478_);
        float rot = this.m_146908_();
        this.setAnimalPos(animal, this.rotateY(this.animalPositions[index], rot).m_82549_(this.m_20182_()), rot);
    }

    protected boolean isAnimalInRange(int index) {
        Mob animal = this.getAnimal(index);
        if (animal == null) {
            return false;
        }
        return animal.m_6084_() && animal.m_20182_().m_82546_(this.rotateY(this.animalPositions[index], this.m_146908_()).m_82549_(this.m_20182_())).m_165925_() < 0.25;
    }

    protected void setAnimalPos(Mob animal, Vec3 pos, float rot) {
        if (animal == null) {
            return;
        }
        animal.m_146922_(rot);
        animal.m_5618_(rot);
        animal.m_5616_(rot);
        animal.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    protected Vec3 collideSteering(int index, float angle) {
        Vec3 collidedDisplacement;
        Vec3 local;
        Mob animal = this.getAnimal(index);
        if (animal == null) {
            return Vec3.f_82478_;
        }
        Vec3 desired = this.rotateY(this.animalPositions[index], this.m_146908_() + angle);
        Vec3 displacement = desired.m_82546_(local = animal.m_20182_().m_82546_(this.m_20182_()).m_82542_(1.0, 0.0, 1.0));
        if (!displacement.equals((Object)(collidedDisplacement = animal.m_20272_(displacement)).m_82542_(1.0, 0.0, 1.0))) {
            return Vec3.f_82478_;
        }
        return collidedDisplacement;
    }

    @Nullable
    protected Mob getAnimal(int index) {
        EntityAccess entityAccess;
        UUID uuid = this.animalUuids[index];
        Mob animal = this.animals[index];
        if (uuid == null) {
            return null;
        }
        if (animal == null && (entityAccess = this.m_9236_().m_142646_().m_142694_(uuid)) instanceof Mob) {
            Mob mob;
            animal = mob = (Mob)entityAccess;
        }
        return animal != null && animal.m_6084_() ? animal : null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        double width = this.m_20205_();
        double offset = Math.sqrt(width * width + width * width) / 2.0 + 0.05;
        double pWidth = passenger.m_20205_();
        double pOffset = Math.sqrt(pWidth * pWidth + pWidth * pWidth) / 2.0;
        float yRot = this.m_146908_();
        Vec3 wOffset = new Vec3(0.0, (double)passenger.m_20192_(), 0.0);
        Vec3 pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(offset + pOffset, 0.0, 0.0), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)(pWidth *= (double)0.8f), (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(-offset - pOffset, 0.0, 0.0), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(0.0, 0.0, offset + pOffset), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(0.0, 0.0, -offset - pOffset), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        return super.m_7688_(passenger);
    }

    public boolean isEmpty(AABB aabb) {
        return BlockPos.m_121921_((AABB)aabb).noneMatch(pos -> {
            BlockState state = this.m_9236_().m_8055_(pos);
            return !state.m_60795_() && state.m_60828_((BlockGetter)this.m_9236_(), pos) && Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)this.m_9236_(), pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    protected Mob tryGetDraught(int index) {
        UUID uuid = this.animalUuids[index];
        if (uuid == null) {
            return null;
        }
        Mob animal = this.getAnimal(index);
        if (animal != null) {
            return animal;
        }
        return this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(5.0)).stream().filter(h -> h.m_20148_().equals(uuid)).findFirst().orElse(null);
    }

    protected void setAnimal(Mob animal, int index) {
        Mob old = this.animals[0];
        if (old != null && old != animal) {
            old.m_21557_(false);
        }
        if (animal != null) {
            animal.m_21557_(true);
        }
        this.animals[index] = animal;
        this.animalUuids[index] = animal != null ? animal.m_20148_() : null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12630_, SoundSource.MASTER);
            double w = this.m_20205_();
            double h = this.m_20206_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50741_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, w, h, w, 0.0);
            this.setHealth(this.getHealth() - amount);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            if (this.getHealth() <= 0.0f) {
                this.onDestroyed(false);
            }
            return true;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        return true;
    }

    protected void onDestroyed(boolean dropItem) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (Mob animal : this.animals) {
            if (animal == null) continue;
            animal.m_21557_(false);
        }
        this.m_20153_();
        this.m_146870_();
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        if (dropItem) {
            ItemStack pickResult = this.m_142340_();
            if (pickResult != null) {
                this.m_19983_(pickResult);
            }
        } else {
            this.m_19983_(new ItemStack((ItemLike)this.getWoodType().planks.m_5456_(), RANDOM.nextInt(7)));
            this.m_19983_(new ItemStack((ItemLike)Items.f_42416_, RANDOM.nextInt(3)));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
        ListTag animals = new ListTag();
        for (int i = 0; i < this.animals.length; ++i) {
            Mob animal = this.animals[i];
            if (animal == null) continue;
            animals.add((Object)NbtUtils.m_129226_((UUID)animal.m_20148_()));
        }
        tag.m_128365_("animals", (Tag)animals);
        tag.m_128405_("woodType", this.getWoodType().ordinal());
    }

    protected void m_7378_(CompoundTag tag) {
        ListTag animals = tag.m_128437_("animals", 11);
        for (int i = 0; i < animals.size(); ++i) {
            this.animalUuids[i] = NbtUtils.m_129233_((Tag)animals.get(i));
        }
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
        this.setWoodType(Type.values()[tag.m_128451_("woodType")]);
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_HEALTH)).floatValue();
    }

    protected void setHealth(float health) {
        this.f_19804_.m_135381_(DATA_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)health, (float)0.0f, (float)this.maxHealth)));
    }

    public Type getWoodType() {
        return Type.values()[(Integer)this.f_19804_.m_135370_(DATA_TYPE)];
    }

    public void setWoodType(Type type) {
        this.f_19804_.m_135381_(DATA_TYPE, (Object)type.ordinal());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TYPE, (Object)0);
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)Float.valueOf(this.maxHealth));
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return !this.m_6095_().m_204039_(EntityTypeTags.f_273841_);
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public static enum Type {
        OAK(Blocks.f_50705_),
        SPRUCE(Blocks.f_50741_),
        BIRCH(Blocks.f_50742_),
        JUNGLE(Blocks.f_50743_),
        ACACIA(Blocks.f_50744_),
        CHERRY(Blocks.f_271304_),
        CRIMSON(Blocks.f_50655_),
        DARK_OAK(Blocks.f_50745_),
        WARPED(Blocks.f_50656_),
        MANGROVE(Blocks.f_220865_);

        protected final Block planks;

        private Type(Block planks) {
            this.planks = planks;
        }

        public Block getPlanks() {
            return this.planks;
        }
    }
}

