/*
 * Decompiled with CFR 0.152.
 */
package com.fnkee.flimsytorches.blocks;

import com.fnkee.flimsytorches.config.ConfigWriter;
import com.fnkee.flimsytorches.setup.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FlimsyTorchBlock
extends TorchBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)255);
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);

    public FlimsyTorchBlock(BlockBehaviour.Properties properties, ParticleOptions particleData, int level) {
        super(properties, particleData);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE, LEVEL});
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        int torchLevel = (Integer)state.m_61143_((Property)LEVEL);
        switch (torchLevel) {
            case 1: {
                if (age < (Integer)ConfigWriter.SMOLDERING_BURN_AGE.get()) break;
                level.m_7731_(pos, ((Block)ModBlocks.BURNT_OUT_TORCH.get()).m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
            case 2: {
                if (age < (Integer)ConfigWriter.USED_BURN_AGE.get()) break;
                level.m_7731_(pos, ((Block)ModBlocks.SMOLDERING_TORCH.get()).m_49966_(), 3);
                return;
            }
            case 3: {
                if (age < (Integer)ConfigWriter.FLIMSY_BURN_AGE.get()) break;
                level.m_7731_(pos, ((Block)ModBlocks.USED_TORCH.get()).m_49966_(), 3);
                return;
            }
        }
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(torchLevel)), 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        int torchLevel = (Integer)state.m_61143_((Property)LEVEL);
        double offsetY = switch (torchLevel) {
            case 1 -> 0.45;
            case 2 -> 0.575;
            case 3 -> 0.7;
            default -> 0.7;
        };
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + offsetY;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        level.m_7106_(this.f_57488_, x, y, z, 0.0, 0.0, 0.0);
    }
}

