/*
 * Decompiled with CFR 0.152.
 */
package com.fnkee.flimsytorches.entities.ai;

import com.fnkee.flimsytorches.config.ConfigWriter;
import com.fnkee.flimsytorches.setup.ModBlocks;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class ReplaceTorchGoal
extends Goal {
    private final Villager villager;
    private BlockPos targetTorchPos;
    private int cooldown = 0;
    private int ticksTryingToReach = 0;
    private static final int MAX_RETRY_TICKS = 200;

    public ReplaceTorchGoal(Villager villager) {
        this.villager = villager;
    }

    public boolean m_8036_() {
        int distance;
        BlockState state;
        if (this.villager.m_5803_() || this.villager.m_6274_().m_21954_(Activity.f_37984_) || this.villager.m_6274_().m_21954_(Activity.f_37981_) || this.villager.m_6274_().m_21954_(Activity.f_37985_)) {
            return false;
        }
        if (--this.cooldown > 0) {
            return false;
        }
        this.cooldown = (Integer)ConfigWriter.VILLAGER_REPLACE_INTERVAL.get();
        BlockPos villagerPos = this.villager.m_20183_();
        int closestDistance = Integer.MAX_VALUE;
        BlockPos closestTorch = null;
        if (((Boolean)ConfigWriter.ALLOW_BURNT_OUT_REPLACEMENT.get()).booleanValue()) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)villagerPos.m_7918_(-12, -1, -12), (BlockPos)villagerPos.m_7918_(12, 3, 12))) {
                state = this.villager.m_9236_().m_8055_(pos);
                if (!state.m_60713_((Block)ModBlocks.BURNT_OUT_TORCH.get()) && !state.m_60713_((Block)ModBlocks.BURNT_OUT_WALL_TORCH.get()) || (distance = pos.m_123333_((Vec3i)villagerPos)) >= closestDistance) continue;
                closestDistance = distance;
                closestTorch = pos.m_7949_();
            }
            if (closestTorch != null) {
                this.targetTorchPos = closestTorch;
                return true;
            }
        }
        if (((Boolean)ConfigWriter.ALLOW_SMOLDERING_REPLACEMENT.get()).booleanValue()) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)villagerPos.m_7918_(-7, -1, -7), (BlockPos)villagerPos.m_7918_(7, 3, 7))) {
                state = this.villager.m_9236_().m_8055_(pos);
                if (!state.m_60713_((Block)ModBlocks.SMOLDERING_TORCH.get()) && !state.m_60713_((Block)ModBlocks.SMOLDERING_WALL_TORCH.get()) || (distance = pos.m_123333_((Vec3i)villagerPos)) >= closestDistance) continue;
                closestDistance = distance;
                closestTorch = pos.m_7949_();
            }
            if (closestTorch != null) {
                this.targetTorchPos = closestTorch;
                return true;
            }
        }
        if (((Boolean)ConfigWriter.ALLOW_USED_REPLACEMENT.get()).booleanValue()) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)villagerPos.m_7918_(-4, -1, -4), (BlockPos)villagerPos.m_7918_(4, 3, 4))) {
                state = this.villager.m_9236_().m_8055_(pos);
                if (!state.m_60713_((Block)ModBlocks.USED_TORCH.get()) && !state.m_60713_((Block)ModBlocks.USED_WALL_TORCH.get()) || (distance = pos.m_123333_((Vec3i)villagerPos)) >= closestDistance) continue;
                closestDistance = distance;
                closestTorch = pos.m_7949_();
            }
            if (closestTorch != null) {
                this.targetTorchPos = closestTorch;
                return true;
            }
        }
        return false;
    }

    public void m_8056_() {
        this.ticksTryingToReach = 0;
        if (this.targetTorchPos == null) {
            return;
        }
        BlockPos torchPos = this.targetTorchPos;
        Level level = this.villager.m_9236_();
        int radius = 1;
        Iterator iterator = BlockPos.m_121940_((BlockPos)torchPos.m_7918_(-radius, -3, -radius), (BlockPos)torchPos.m_7918_(radius, 1, radius)).iterator();
        while (iterator.hasNext()) {
            boolean canPath;
            BlockPos nearby;
            BlockPos groundPos = nearby = (BlockPos)iterator.next();
            BlockPos headPos = groundPos.m_7494_();
            BlockState headState = level.m_8055_(headPos);
            boolean hasSpace = headState.m_60795_();
            BlockPathTypes pathType = WalkNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)groundPos.m_122032_());
            if (!hasSpace || pathType != BlockPathTypes.WALKABLE || !(canPath = this.villager.m_21573_().m_26519_((double)groundPos.m_123341_() + 0.5, (double)groundPos.m_123342_(), (double)groundPos.m_123343_() + 0.5, 0.5))) continue;
            torchPos = groundPos;
            return;
        }
        this.targetTorchPos = null;
    }

    public boolean m_8045_() {
        if (this.targetTorchPos == null) {
            return false;
        }
        if (!this.villager.m_21573_().m_26571_()) {
            ++this.ticksTryingToReach;
            return this.ticksTryingToReach <= 200;
        }
        this.ticksTryingToReach = 0;
        double distSqr = this.villager.m_20183_().m_123331_((Vec3i)this.targetTorchPos);
        boolean closeEnough = distSqr <= 9.0;
        BlockState state = this.villager.m_9236_().m_8055_(this.targetTorchPos);
        return closeEnough && (state.m_60713_((Block)ModBlocks.BURNT_OUT_TORCH.get()) || state.m_60713_((Block)ModBlocks.BURNT_OUT_WALL_TORCH.get()) || state.m_60713_((Block)ModBlocks.SMOLDERING_TORCH.get()) || state.m_60713_((Block)ModBlocks.SMOLDERING_WALL_TORCH.get()) || state.m_60713_((Block)ModBlocks.USED_TORCH.get()) || state.m_60713_((Block)ModBlocks.USED_WALL_TORCH.get()));
    }

    public void m_8037_() {
        if (this.targetTorchPos != null && this.villager.m_20183_().m_123314_((Vec3i)this.targetTorchPos, 4.0)) {
            Level level = this.villager.m_9236_();
            BlockState burntTorch = level.m_8055_(this.targetTorchPos);
            if (burntTorch.m_60713_((Block)ModBlocks.BURNT_OUT_TORCH.get()) && (Boolean)ConfigWriter.ALLOW_BURNT_OUT_REPLACEMENT.get() != false || burntTorch.m_60713_((Block)ModBlocks.SMOLDERING_TORCH.get()) && (Boolean)ConfigWriter.ALLOW_SMOLDERING_REPLACEMENT.get() != false || burntTorch.m_60713_((Block)ModBlocks.USED_TORCH.get()) && ((Boolean)ConfigWriter.ALLOW_USED_REPLACEMENT.get()).booleanValue()) {
                level.m_46597_(this.targetTorchPos, ((Block)ModBlocks.FLIMSY_TORCH.get()).m_49966_());
                level.m_5594_(null, this.targetTorchPos, SoundType.f_56736_.m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (burntTorch.m_60713_((Block)ModBlocks.BURNT_OUT_WALL_TORCH.get()) && (Boolean)ConfigWriter.ALLOW_BURNT_OUT_REPLACEMENT.get() != false || burntTorch.m_60713_((Block)ModBlocks.SMOLDERING_WALL_TORCH.get()) && (Boolean)ConfigWriter.ALLOW_SMOLDERING_REPLACEMENT.get() != false || burntTorch.m_60713_((Block)ModBlocks.USED_WALL_TORCH.get()) && ((Boolean)ConfigWriter.ALLOW_USED_REPLACEMENT.get()).booleanValue()) {
                Direction facing = (Direction)burntTorch.m_61143_((Property)BlockStateProperties.f_61374_);
                level.m_46597_(this.targetTorchPos, (BlockState)((Block)ModBlocks.FLIMSY_WALL_TORCH.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
                level.m_5594_(null, this.targetTorchPos, SoundType.f_56736_.m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.targetTorchPos = null;
        }
    }

    public void m_8041_() {
        this.ticksTryingToReach = 0;
        this.targetTorchPos = null;
    }
}

