/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.ratatouille.mixin.client.render;

import dev.doctor4t.ratatouille.client.lib.render.systems.rendering.ExtendedShader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.client.render.Shader$1"})
abstract class ShaderImportProcessorMixin {
    @Unique
    private String capturedImport;

    ShaderImportProcessorMixin() {
    }

    @Inject(method={"loadImport"}, at={@At(value="HEAD")})
    private void captureImport(boolean inline, String name, CallbackInfoReturnable<String> info) {
        this.capturedImport = name;
    }

    @ModifyVariable(method={"loadImport"}, at=@At(value="STORE"), ordinal=0, argsOnly=true)
    private String modifyImportId(String id, boolean inline) {
        if (!inline && this.capturedImport.contains(String.valueOf(':'))) {
            return ExtendedShader.rewriteAsId(id, this.capturedImport);
        }
        return id;
    }

    @Inject(method={"loadImport"}, at={@At(value="RETURN")})
    private void uncaptureImport(boolean inline, String name, CallbackInfoReturnable<String> info) {
        this.capturedImport = null;
    }
}

