/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile;

import dev.doctor4t.ratatouille.client.lib.render.handlers.RenderHandler;
import dev.doctor4t.ratatouille.client.lib.render.helpers.Easing;
import dev.doctor4t.ratatouille.client.lib.render.setup.RatatouilleRenderLayers;
import dev.doctor4t.ratatouille.client.lib.render.systems.rendering.VFXBuilders;
import doctor4t.defile.Defile;
import doctor4t.defile.cca.DefileComponents;
import doctor4t.defile.cca.PlayerInklingComponent;
import doctor4t.defile.cca.WorldBlackRainComponent;
import doctor4t.defile.cca.WorldEclipseAnimationComponent;
import doctor4t.defile.client.gui.InklingCosmeticsScreen;
import doctor4t.defile.client.particle.contracts.SplashParticleInitialData;
import doctor4t.defile.client.render.entity.model.InklingCrownModel;
import doctor4t.defile.client.render.entity.model.SplashBottomModel;
import doctor4t.defile.client.render.entity.model.SplashBottomRimModel;
import doctor4t.defile.client.render.entity.model.SplashModel;
import doctor4t.defile.client.render.entity.model.SplashRimModel;
import doctor4t.defile.index.DefileBlocks;
import doctor4t.defile.index.DefileItems;
import doctor4t.defile.index.DefileParticles;
import doctor4t.defile.index.DefileSounds;
import doctor4t.defile.packet.EntityAndPosPacket;
import doctor4t.defile.packet.UseTotemOfUncleansingPacket;
import doctor4t.defile.wakes.WakesClient;
import doctor4t.defile.wakes.duck.ProducesWake;
import doctor4t.defile.wakes.utils.WakesUtils;
import java.awt.Color;
import ladysnake.satin.api.event.ShaderEffectRenderCallback;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.api.managed.uniform.Uniform1f;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5601;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class DefileClient
implements ClientModInitializer {
    public static final float MAX_LAUNCH_STRENGTH = 2.0f;
    public static final class_2960 DARKNESS_TEXTURE = Defile.id("textures/environment/darkness.png");
    public static final class_2960 FOLLY_TEXTURE = Defile.id("textures/environment/folly.png");
    public static final class_1921 DARKNESS = RatatouilleRenderLayers.TRANSPARENT_TEXTURE_TRIANGLE.apply(DARKNESS_TEXTURE);
    public static final class_1921 FOLLY = RatatouilleRenderLayers.TRANSPARENT_TEXTURE_TRIANGLE.apply(FOLLY_TEXTURE);
    private static final ManagedShaderEffect GREYSCALE_PROGRAM = ShaderEffectManager.getInstance().manage(Defile.id("shaders/post/greyscale.json"));
    private static final Uniform1f greyscaleSaturation = GREYSCALE_PROGRAM.findUniform1f("Saturation");
    private static final Uniform1f greyscaleFolly = GREYSCALE_PROGRAM.findUniform1f("Folly");
    private static final Uniform1f greyscaleDarkness = GREYSCALE_PROGRAM.findUniform1f("Darkness");
    public static float launchStrength = 0.0f;
    public static boolean openCosmeticsScreen = false;
    public static WorldBlackRainComponent CACHED_BLACK_RAIN_COMPONENT;
    public static WorldEclipseAnimationComponent CACHED_ECLIPSE_COMPONENT;

    public static float getEclipseRadius(class_1937 world) {
        return class_3532.method_16439((float)Easing.EXPO_OUT.ease(Math.min((float)DefileClient.getCachedEclipseComponentOrFresh(world).getTicks() + class_310.method_1551().method_1488(), 180.0f) / 180.0f, 0.0f, 1.0f, 1.0f), (float)0.0f, (float)100.0f);
    }

    public static WorldBlackRainComponent getCachedBlackRainComponentOrFresh(class_1937 world) {
        if (CACHED_BLACK_RAIN_COMPONENT == null) {
            CACHED_BLACK_RAIN_COMPONENT = (WorldBlackRainComponent)DefileComponents.BLACK_RAIN.get((Object)world);
        }
        return CACHED_BLACK_RAIN_COMPONENT;
    }

    public static WorldEclipseAnimationComponent getCachedEclipseComponentOrFresh(class_1937 world) {
        if (CACHED_ECLIPSE_COMPONENT == null) {
            CACHED_ECLIPSE_COMPONENT = (WorldEclipseAnimationComponent)DefileComponents.ECLIPSE_ANIMATION.get((Object)world);
        }
        return CACHED_ECLIPSE_COMPONENT;
    }

    public static void refreshCache(class_310 client) {
        if (client.field_1687 != null) {
            CACHED_BLACK_RAIN_COMPONENT = (WorldBlackRainComponent)DefileComponents.BLACK_RAIN.get((Object)client.field_1687);
            CACHED_ECLIPSE_COMPONENT = (WorldEclipseAnimationComponent)DefileComponents.ECLIPSE_ANIMATION.get((Object)client.field_1687);
        }
    }

    public void onInitializeClient() {
        WakesClient.initializeClient();
        DefileParticles.registerFactories();
        BlockRenderLayerMap.INSTANCE.putBlock(DefileBlocks.FUNERAL_INK, class_1921.method_23581());
        EntityModelLayerRegistry.registerModelLayer((class_5601)InklingCrownModel.MODEL_LAYER, InklingCrownModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SplashModel.MODEL_LAYER, SplashModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SplashBottomModel.MODEL_LAYER, SplashBottomModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SplashRimModel.MODEL_LAYER, SplashRimModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SplashBottomRimModel.MODEL_LAYER, SplashBottomRimModel::getTexturedModelData);
        class_310 minecraftClient = class_310.method_1551();
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stackInHand = player.method_5998(hand);
            if (stackInHand.method_31574(DefileItems.TOTEM_OF_UNCLEANSING) && ((PlayerInklingComponent)DefileComponents.INKLING.get((Object)player)).isInkling()) {
                openCosmeticsScreen = true;
            }
            return class_1271.method_22430((Object)stackInHand);
        });
        WorldRenderEvents.LAST.register(context -> {
            if (openCosmeticsScreen) {
                minecraftClient.method_1507((class_437)new InklingCosmeticsScreen());
                openCosmeticsScreen = false;
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UseTotemOfUncleansingPacket.ID, (client, handler, buf, responseSender) -> {
            UseTotemOfUncleansingPacket packet = new UseTotemOfUncleansingPacket(buf);
            class_1297 entity = packet.getEntity((class_1937)client.field_1687);
            client.execute(() -> {
                if (entity != null) {
                    client.field_1713.method_3051(entity, (class_2394)DefileParticles.TOTEM_INK, 30);
                    client.field_1687.method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), DefileSounds.ITEM_TOTEM_OF_UNCLEANSING_USE, entity.method_5634(), 1.0f, 1.0f, false);
                    if (entity == client.field_1724) {
                        client.field_1773.method_3189(new class_1799((class_1935)DefileItems.TOTEM_OF_UNCLEANSING));
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)EntityAndPosPacket.DIVE_SPLASH_ID, (client, handler, buf, responseSender) -> {
            EntityAndPosPacket packet = new EntityAndPosPacket(buf);
            class_1297 entity = packet.getEntity((class_1937)client.field_1687);
            class_243 entityPos = packet.getPos();
            if (entity != null) {
                client.execute(() -> {
                    boolean isRising = false;
                    SplashParticleInitialData data = new SplashParticleInitialData(0.5, 1.25);
                    float pitch = 1.0f;
                    boolean b = entity instanceof class_1657;
                    if (b) {
                        PlayerInklingComponent component;
                        isRising = (component = (PlayerInklingComponent)DefileComponents.INKLING.get((Object)entity)).isDiving();
                        component.setDiving(!isRising);
                        entity.method_18382();
                    } else if (entity instanceof class_1542) {
                        data = new SplashParticleInitialData(0.2f, 2.0);
                        pitch = 1.2f;
                    }
                    client.field_1687.method_8486(entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), isRising ? DefileSounds.ENTITY_INK_RISE : DefileSounds.ENTITY_INK_DIVE, b ? class_3419.field_15248 : class_3419.field_15254, 1.0f, (float)((double)pitch + entity.method_37908().method_8409().method_43059() / 20.0), false);
                    entity.method_18800(0.0, -1.0, 0.0);
                    ProducesWake wakeProducer = (ProducesWake)entity;
                    wakeProducer.setProducingHeight((float)entityPos.method_10214());
                    WakesUtils.placeFallSplash(entity);
                    client.field_1687.method_8406(isRising ? DefileParticles.RISE_SPLASH.setData(data) : DefileParticles.SPLASH.setData(data), entityPos.method_10216(), Math.floor(entityPos.method_10214()) - (double)0.1f, entityPos.method_10215(), 0.0, 0.0, 0.0);
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)EntityAndPosPacket.DIVE_INKSPLOSION_ID, (client, handler, buf, responseSender) -> {
            EntityAndPosPacket packet = new EntityAndPosPacket(buf);
            class_1297 entity = packet.getEntity((class_1937)client.field_1687);
            class_243 entityPos = packet.getPos();
            if (entity != null) {
                client.execute(() -> {
                    if (entity != null) {
                        PlayerInklingComponent component = (PlayerInklingComponent)DefileComponents.INKLING.get((Object)entity);
                        component.setDiving(component.isInkling());
                        entity.method_18382();
                        client.field_1687.method_8486(entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), DefileSounds.ENTITY_INK_EXPLODE, class_3419.field_15248, 1.0f, (float)(1.0 + entity.method_37908().method_8409().method_43059() / 20.0), false);
                        for (int i = 0; i < 500; ++i) {
                            client.field_1687.method_8406((class_2394)DefileParticles.FUNERAL_FALLING_INK, entityPos.method_10216() + (double)client.field_1687.field_9229.method_43057() - 0.5, entityPos.method_10214() + (double)(client.field_1687.field_9229.method_43057() * 1.8f), entityPos.method_10215() + (double)client.field_1687.field_9229.method_43057() - 0.5, (double)((client.field_1687.field_9229.method_43057() - 0.5f) * 0.6f), (double)((client.field_1687.field_9229.method_43057() - 0.5f) * 0.6f), (double)((client.field_1687.field_9229.method_43057() - 0.5f) * 0.6f));
                        }
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)EntityAndPosPacket.REMOVE_INKMORPHOSIS_ID, (client, handler, buf, responseSender) -> {
            EntityAndPosPacket packet = new EntityAndPosPacket(buf);
            class_1297 entity = packet.getEntity((class_1937)client.field_1687);
            class_243 entityPos = packet.getPos();
            if (entity != null) {
                client.execute(() -> {
                    PlayerInklingComponent component = (PlayerInklingComponent)DefileComponents.INKLING.get((Object)entity);
                    component.setDiving(false);
                    entity.method_18382();
                    client.field_1687.method_8486(entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), DefileSounds.ENTITY_INK_EXPLODE, class_3419.field_15248, 1.0f, (float)(1.0 + entity.method_37908().method_8409().method_43059() / 20.0), false);
                    for (int i = 0; i < 500; ++i) {
                        client.field_1687.method_8406((class_2394)DefileParticles.FUNERAL_FALLING_INK, entityPos.method_10216() + (double)client.field_1687.field_9229.method_43057() - 0.5, entityPos.method_10214() + (double)(client.field_1687.field_9229.method_43057() * 1.8f), entityPos.method_10215() + (double)client.field_1687.field_9229.method_43057() - 0.5, (double)((client.field_1687.field_9229.method_43057() - 0.5f) * 0.2f), (double)((client.field_1687.field_9229.method_43057() - 0.5f) * 0.2f), (double)((client.field_1687.field_9229.method_43057() - 0.5f) * 0.2f));
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)EntityAndPosPacket.WAKES_SPLASH, (client, handler, buf, responseSender) -> {
            EntityAndPosPacket packet = new EntityAndPosPacket(buf);
            class_1297 entity = packet.getEntity((class_1937)client.field_1687);
            class_243 entityPos = packet.getPos();
            if (entity != null) {
                client.execute(() -> {
                    ProducesWake wakeProducer = (ProducesWake)entity;
                    if (wakeProducer != null) {
                        wakeProducer.setProducingHeight((float)entityPos.method_10214());
                        WakesUtils.placeFallSplash(entity);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Defile.CLIENTBOUND_THUNDER_PACKET, (client, handler, buf, responseSender) -> client.execute(() -> {
            DefileClient.getCachedBlackRainComponentOrFresh((class_1937)client.field_1687).setThunderGradient(1.0f);
            DefileClient.refreshCache(client);
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)DefileSounds.WEATHER_BLACK_RAIN_THUNDER, (float)((float)(1.0 - client.field_1687.field_9229.method_43059() / 10.0)), (float)(client.field_1690.method_1630(class_3419.field_15252) * 2.0f)));
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Defile.CLIENTBOUND_ECLIPSE_PACKET, (client, handler, buf, responseSender) -> client.execute(() -> {
            DefileClient.getCachedBlackRainComponentOrFresh((class_1937)client.field_1687).setThunderGradient(1.0f);
            DefileClient.refreshCache(client);
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)DefileSounds.WEATHER_ECLIPSE, (float)1.0f, (float)2.0f));
        }));
        ShaderEffectRenderCallback.EVENT.register(tickDelta -> {
            class_638 world = minecraftClient.field_1687;
            if (world != null) {
                WorldBlackRainComponent component = DefileClient.getCachedBlackRainComponentOrFresh((class_1937)world);
                float grad = component.getGradient();
                if (DefileClient.isWithinEclipse()) {
                    grad = 1.0f;
                }
                greyscaleSaturation.set(1.0f - grad);
                greyscaleFolly.set(component.getThunderGradient());
                greyscaleDarkness.set(0.5f + (1.0f - grad) * 0.5f);
                if (grad > 0.0f) {
                    GREYSCALE_PROGRAM.render(tickDelta);
                }
            }
        });
        WorldRenderEvents.BEFORE_ENTITIES.register(context -> {
            class_638 world = context.world();
            WorldEclipseAnimationComponent eclipseComponent = DefileClient.getCachedEclipseComponentOrFresh((class_1937)world);
            if (eclipseComponent.shouldTick()) {
                class_4587 matrices = context.matrixStack();
                matrices.method_22903();
                VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setPosColorTexLightmapDefaultFormat();
                float radius = DefileClient.getEclipseRadius((class_1937)world);
                class_746 player = minecraftClient.field_1724;
                class_243 subtract = eclipseComponent.getPosition().method_1020(player.method_5836(minecraftClient.method_1488()));
                matrices.method_22904(subtract.method_10216(), subtract.method_10214(), subtract.method_10215());
                builder.setColor(new Color(0xFFFFFF)).setAlpha(1.0f).renderSphere(RenderHandler.DELAYED_RENDER.getBuffer(DARKNESS), matrices, -radius, 50, 50);
                builder.setColor(new Color(0xFFFFFF)).setAlpha(1.0f).renderSphere(RenderHandler.DELAYED_RENDER.getBuffer(DARKNESS), matrices, radius, 50, 50);
                builder.setColor(new Color(0xFFFFFF)).setAlpha(1.0f).renderSphere(RenderHandler.EARLY_DELAYED_RENDER.getBuffer(FOLLY), matrices, Math.min(-radius + 1.0f, 0.0f), 50, 50);
                matrices.method_22909();
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(DefileClient::refreshCache);
    }

    public static boolean isWithinEclipse() {
        class_638 world = class_310.method_1551().field_1687;
        WorldEclipseAnimationComponent eclipseComponent = DefileClient.getCachedEclipseComponentOrFresh((class_1937)world);
        return eclipseComponent.getTicks() > 0 && class_310.method_1551().field_1724.method_5836(class_310.method_1551().method_1488()).method_1020(eclipseComponent.getPosition()).method_1027() <= (double)(DefileClient.getEclipseRadius((class_1937)world) * DefileClient.getEclipseRadius((class_1937)world));
    }
}

