/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.cca;

import dev.emi.stepheightentityattribute.StepHeightEntityAttributeMain;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import doctor4t.defile.Defile;
import doctor4t.defile.cca.DefileComponents;
import doctor4t.defile.command.DefileCommand;
import doctor4t.defile.index.DefileParticles;
import doctor4t.defile.index.DefileStatusEffects;
import doctor4t.defile.packet.EntityAndPosPacket;
import doctor4t.defile.world.Inksplosion;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_259;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_4050;

public class PlayerInklingComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final class_2960 INKLING_TEXTURE = Defile.id("textures/entity/inkling/inkling_base.png");
    private static final class_1322 STEP_HEIGHT_MODIFIER = new class_1322(UUID.fromString("3f1829ef-bd95-4e03-83a2-f568ba3286bd"), "Inkling step height", 3.0, class_1322.class_1323.field_6328);
    public static final int MAX_LAUNCH_TICKS = 100;
    private final class_1657 player;
    private boolean diving;
    private int divingTicks;
    private int outOfInkTimer;
    private int lastDiveX = 0;
    private int lastDiveY = 0;
    private int lastDiveZ = 0;
    private int launchTicks = 0;
    private boolean inkling = false;

    public PlayerInklingComponent(class_1657 player) {
        this.player = player;
    }

    private void sync() {
        DefileComponents.INKLING.sync((Object)this.player);
    }

    public boolean isInkling() {
        return this.inkling;
    }

    private void correctInkling() {
        boolean shouldBeInkling = this.player.method_6059(DefileStatusEffects.INKMORPHOSIS);
        if (this.inkling != shouldBeInkling) {
            this.inkling = shouldBeInkling;
            this.sync();
        }
    }

    public boolean isDiving() {
        return this.isInkling() && this.diving;
    }

    public void setDiving(boolean diving) {
        Object object;
        if (diving) {
            this.player.method_23327(this.player.method_23317(), (double)Math.round(this.player.method_23318()) + 0.1, this.player.method_23321());
        }
        this.setOutOfInkTimer(0);
        this.diving = diving;
        this.player.method_18382();
        class_1324 stepHeightAttribute = this.player.method_5996(StepHeightEntityAttributeMain.STEP_HEIGHT);
        if (diving) {
            if (!stepHeightAttribute.method_6196(STEP_HEIGHT_MODIFIER)) {
                stepHeightAttribute.method_26837(STEP_HEIGHT_MODIFIER);
            }
        } else if (stepHeightAttribute.method_6196(STEP_HEIGHT_MODIFIER)) {
            stepHeightAttribute.method_6202(STEP_HEIGHT_MODIFIER);
        }
        if ((object = this.player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)object;
            for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
                boolean isSplash = Defile.isCollidingWithFuneralInk((class_1297)this.player);
                EntityAndPosPacket packet = new EntityAndPosPacket((class_1297)this.player);
                class_2540 buf = PacketByteBufs.create();
                packet.method_11052(buf);
                ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)(isSplash ? EntityAndPosPacket.DIVE_SPLASH_ID : EntityAndPosPacket.DIVE_INKSPLOSION_ID), (class_2540)buf);
            }
        }
        this.sync();
    }

    public int getDivingTicks() {
        return this.divingTicks;
    }

    public void setDivingTicks(int divingTicks) {
        this.divingTicks = divingTicks;
        this.sync();
    }

    public int getDivingTicksAnimationLength() {
        return 3;
    }

    public int getOutOfInkTimer() {
        return this.outOfInkTimer;
    }

    public void setOutOfInkTimer(int outOfInkTimer) {
        this.outOfInkTimer = outOfInkTimer;
    }

    public int getLaunchTicks() {
        return this.launchTicks;
    }

    public void setLaunchTicks(int launchTicks) {
        this.launchTicks = launchTicks;
        this.sync();
    }

    public void switchDiveState() {
        if (this.isDiving()) {
            this.rise();
        } else {
            this.dive();
        }
    }

    public void dive() {
        this.setDiving(true);
        this.setDivingTicks(this.getDivingTicksAnimationLength());
    }

    public void rise() {
        this.setDiving(false);
        this.setDivingTicks(this.getDivingTicksAnimationLength());
        this.player.method_18380(class_4050.field_18081);
    }

    public void launch() {
        this.rise();
        this.setLaunchTicks(100);
    }

    public void readFromNbt(class_2487 nbt) {
        this.diving = nbt.method_10577("Diving");
        this.divingTicks = nbt.method_10550("DivingTicks");
        this.launchTicks = nbt.method_10550("LaunchTicks");
        this.inkling = nbt.method_10577("Inkling");
    }

    public void writeToNbt(class_2487 nbt) {
        nbt.method_10556("Diving", this.diving);
        nbt.method_10569("DivingTicks", this.divingTicks);
        nbt.method_10569("LaunchTicks", this.launchTicks);
        nbt.method_10556("Inkling", this.inkling);
    }

    public void tick() {
        if (this.divingTicks > 0) {
            --this.divingTicks;
        }
        if (this.launchTicks > 0) {
            --this.launchTicks;
        }
    }

    public void clientTick() {
        this.tick();
        if (this.isInkling()) {
            boolean collidingWithFuneralInk = Defile.isCollidingWithFuneralInk((class_1297)this.player);
            if (this.isDiving()) {
                if (!collidingWithFuneralInk && this.player.method_24828()) {
                    this.player.method_37908().method_8406((class_2394)DefileParticles.FUNERAL_INK_SPLAT, this.player.method_23322(0.3), this.player.method_23318() + (double)0.01f, this.player.method_23325(0.3), (double)((this.player.method_37908().field_9229.method_43057() - 0.5f) * 0.3f), (double)(this.player.method_37908().field_9229.method_43057() * 0.3f), (double)((this.player.method_37908().field_9229.method_43057() - 0.5f) * 0.3f));
                }
            } else if (!collidingWithFuneralInk && !this.player.method_5799() && this.player.method_24828()) {
                this.player.method_37908().method_8406((class_2394)DefileParticles.FUNERAL_FALLING_INK, this.player.method_23322(0.3), this.player.method_23318() + (double)0.01f, this.player.method_23325(0.3), 0.0, 0.0, 0.0);
            }
        }
    }

    public void serverTick() {
        this.tick();
        this.correctInkling();
        if (this.isInkling()) {
            this.player.method_7344().method_7580(20);
            if (this.isDiving()) {
                this.player.method_20803(0);
                if ((double)(this.player.method_23312().method_10264() + 1) > this.player.method_23318() && this.player.method_36601().method_26202((class_1922)this.player.method_37908(), this.player.method_24515(), class_3726.method_16195((class_1297)this.player)).equals(class_259.method_1077())) {
                    this.player.method_20620(this.player.method_23317(), this.player.method_23318() + (double)0.1f, this.player.method_23321());
                }
                this.player.method_7344().method_7581(20.0f);
                if (this.isMovingWhileDiving()) {
                    Inksplosion inksplosion = new Inksplosion(this.player.method_37908(), (class_1297)this.player, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), DefileCommand.getInkSpreadPower());
                    inksplosion.tick();
                    this.lastDiveX = this.player.method_31477();
                    this.lastDiveY = this.player.method_31478();
                    this.lastDiveZ = this.player.method_31479();
                }
                if (Defile.isCollidingWithFuneralInk((class_1297)this.player)) {
                    this.setOutOfInkTimer(0);
                    this.player.method_24830(true);
                } else if (this.outOfInkTimer++ > 20) {
                    this.rise();
                }
            } else {
                this.player.method_7344().method_7581(0.0f);
            }
        }
    }

    private boolean isMovingWhileDiving() {
        return this.isDiving() && (this.lastDiveX != this.player.method_31477() || this.lastDiveY != this.player.method_31478() || this.lastDiveZ != this.player.method_31479());
    }

    public void resetPlayer() {
        if (this.isDiving()) {
            this.rise();
        } else {
            class_1937 class_19372 = this.player.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
                    EntityAndPosPacket packet = new EntityAndPosPacket((class_1297)this.player);
                    class_2540 buf = PacketByteBufs.create();
                    packet.method_11052(buf);
                    ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)EntityAndPosPacket.REMOVE_INKMORPHOSIS_ID, (class_2540)buf);
                }
            }
        }
    }
}

