/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.cca;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import doctor4t.defile.Defile;
import doctor4t.defile.cca.DefileComponents;
import doctor4t.defile.cca.WorldEclipseAnimationComponent;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class WorldBlackRainComponent
implements AutoSyncedComponent,
ClientTickingComponent,
ServerTickingComponent {
    private final class_1937 world;
    private int ticks = 0;
    private float gradient = 0.0f;
    private float thunderGradient = 0.0f;

    public WorldBlackRainComponent(class_1937 world) {
        this.world = world;
    }

    private void sync() {
        DefileComponents.BLACK_RAIN.sync((Object)this.world);
    }

    public boolean isRaining() {
        return this.getTicks() > 0;
    }

    public boolean isRainingVisually() {
        return this.getGradient() > 0.0f;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
        this.sync();
    }

    public float getGradient() {
        return this.gradient;
    }

    public void setGradient(float gradient) {
        ((WorldEclipseAnimationComponent)DefileComponents.ECLIPSE_ANIMATION.get((Object)this.world)).reset();
        this.gradient = gradient;
        this.sync();
    }

    public float getThunderGradient() {
        return this.thunderGradient;
    }

    public void setThunderGradient(float thunderGradient) {
        this.thunderGradient = thunderGradient;
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.gradient >= 1.0f) {
                for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
                    ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)Defile.CLIENTBOUND_THUNDER_PACKET, (class_2540)PacketByteBufs.create());
                }
            }
        }
    }

    public boolean isThundering() {
        return this.isRaining() && this.getGradient() >= 1.0f && this.thunderGradient > 0.0f;
    }

    public void readFromNbt(class_2487 tag) {
        this.ticks = tag.method_10550("Ticks");
        this.gradient = tag.method_10583("Gradient");
        this.thunderGradient = tag.method_10583("ThunderGradient");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("Ticks", this.ticks);
        tag.method_10548("Gradient", this.gradient);
        tag.method_10548("ThunderGradient", this.thunderGradient);
    }

    public void clientTick() {
        this.tickRain();
    }

    public void serverTick() {
        this.tickRain();
        if (this.isRaining()) {
            ((class_3218)this.world).method_27910(0, 0, false, false);
            if (this.world.field_9229.method_43048(200) == 0 && this.getThunderGradient() <= 0.0f) {
                this.setThunderGradient(1.0f);
            }
        }
    }

    private void tickRain() {
        float inc = 0.01f;
        if (this.ticks > 0) {
            if (this.gradient <= 1.0f) {
                this.gradient = class_3532.method_15363((float)(this.getGradient() + inc), (float)0.0f, (float)1.0f);
            }
            --this.ticks;
        } else if (this.gradient >= 0.0f) {
            this.gradient = class_3532.method_15363((float)(this.getGradient() - inc), (float)0.0f, (float)1.0f);
        }
        if (this.thunderGradient >= 0.0f) {
            this.thunderGradient = Math.max(this.thunderGradient - 0.1f, 0.0f);
        }
    }
}

