/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.cca;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import doctor4t.defile.Defile;
import doctor4t.defile.cca.DefileComponents;
import doctor4t.defile.cca.WorldBlackRainComponent;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class WorldEclipseAnimationComponent
implements AutoSyncedComponent,
ClientTickingComponent,
ServerTickingComponent {
    public static final int MAX_ECLIPSE_TICKS = 180;
    private final class_1937 world;
    private int ticks = 0;
    private class_243 position = class_243.field_1353;
    private boolean shouldTick = false;

    public WorldEclipseAnimationComponent(class_1937 world) {
        this.world = world;
    }

    private void sync() {
        DefileComponents.ECLIPSE_ANIMATION.sync((Object)this.world);
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
        this.sync();
    }

    public class_243 getPosition() {
        return this.position;
    }

    public void setPosition(class_243 position) {
        this.position = position;
        this.sync();
    }

    public void start() {
        this.setShouldTick(true);
        this.setTicks(0);
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
                ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)Defile.CLIENTBOUND_ECLIPSE_PACKET, (class_2540)PacketByteBufs.create());
            }
        }
    }

    public void reset() {
        this.setShouldTick(false);
        this.setTicks(0);
    }

    public void readFromNbt(class_2487 tag) {
        this.shouldTick = tag.method_10577("ShouldTick");
        this.ticks = tag.method_10550("Ticks");
        this.position = new class_243(tag.method_10574("PosX"), tag.method_10574("PosY"), tag.method_10574("PosZ"));
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("ShouldTick", this.shouldTick);
        tag.method_10569("Ticks", this.ticks);
        tag.method_10549("PosX", this.position.method_10216());
        tag.method_10549("PosY", this.position.method_10214());
        tag.method_10549("PosZ", this.position.method_10215());
    }

    public void clientTick() {
        if (this.shouldTick()) {
            ++this.ticks;
        }
    }

    public void setShouldTick(boolean shouldTick) {
        this.shouldTick = shouldTick;
        this.sync();
    }

    public boolean shouldTick() {
        return this.shouldTick;
    }

    public void serverTick() {
        if (this.shouldTick() && this.ticks++ >= 180) {
            WorldBlackRainComponent component = (WorldBlackRainComponent)DefileComponents.BLACK_RAIN.get((Object)this.world);
            component.setGradient(1.0f);
            component.setThunderGradient(1.0f);
            component.setTicks(144000);
            this.reset();
        }
    }
}

