/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.wakes.render;

import com.mojang.blaze3d.systems.RenderSystem;
import doctor4t.defile.wakes.config.WakesConfig;
import doctor4t.defile.wakes.config.enums.Resolution;
import doctor4t.defile.wakes.render.WakeTexture;
import doctor4t.defile.wakes.simulation.Brick;
import doctor4t.defile.wakes.simulation.WakeHandler;
import doctor4t.defile.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import org.joml.Matrix4f;

public class WakeRenderer
implements WorldRenderEvents.AfterTranslucent {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res));
    }

    public void afterTranslucent(WorldRenderContext context) {
        WakeHandler wakeHandler;
        if (wakeTextures == null) {
            this.initTextures();
        }
        if ((wakeHandler = WakeHandler.getInstance()) == null || wakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(context.frustum(), Brick.class);
        Matrix4f matrix = context.matrixStack().method_23760().method_23761();
        RenderSystem.enableBlend();
        context.lightmapTextureManager().method_3316();
        Resolution resolution = WakesConfig.wakeResolution;
        if (resolution.res != WakeNode.res) {
            return;
        }
        for (Brick brick : bricks) {
            wakeTextures.get((Object)resolution).render(matrix, context.camera(), brick);
            brick.addTimeDelta(context.tickDelta());
        }
    }
}

