/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.wakes.render.enums;

import doctor4t.defile.wakes.WakesClient;
import doctor4t.defile.wakes.config.WakesConfig;
import java.util.Locale;
import net.minecraft.class_3542;

public enum WakeColor implements class_3542
{
    TRANSPARENT(0, 0, 0, 0),
    BLACK(0, 0, 0, 180),
    DARK_GRAY(40, 40, 40, 40),
    GRAY(80, 80, 80, 100),
    FOLLY_RED(255, 0, 90, 255),
    RED(189, 42, 42, 255),
    ORANGE(214, 111, 51, 255),
    YELLOW(227, 225, 84, 255),
    GREEN(115, 189, 42, 255),
    CAMO(8, 135, 57, 255),
    TURQUOISE(42, 189, 140, 255),
    BLUE(65, 51, 214, 255),
    PURPLE(149, 51, 214, 255),
    PINK(214, 51, 192, 255);

    public final int abgr;

    private WakeColor(int red, int green, int blue, int alpha) {
        this.abgr = alpha << 24 | blue << 16 | green << 8 | red;
    }

    private static double invertedLogisticCurve(float x) {
        float k = WakesConfig.shaderLightPassthrough;
        return WakesClient.areShadersEnabled ? (double)k * (4.0 * Math.pow(x - 0.5f, 3.0) + 0.5) : (double)x;
    }

    public static int getColor(float waveEqAvg, int tint, int lightColor, float opacity) {
        double clampedRange = 100.0 / (1.0 + Math.exp(-0.1 * (double)waveEqAvg)) - 50.0;
        for (WakesConfig.ColorInterval interval : WakesConfig.colorIntervals) {
            if (!((double)interval.lower <= clampedRange) || !(clampedRange <= (double)interval.upper)) continue;
            return interval.color.blend(tint, lightColor, opacity, interval.color == FOLLY_RED);
        }
        return WakeColor.TRANSPARENT.abgr;
    }

    private int blend(int tint, int lightColor, float opacity, boolean isHighlight) {
        float srcA = (float)(this.abgr >>> 24 & 0xFF) / 255.0f;
        int a = (int)(opacity * 255.0f * srcA);
        int b = 90;
        int g = 0;
        int r = 255;
        if (!isHighlight) {
            b = (int)((float)(this.abgr >> 16 & 0xFF) * (1.0f - srcA) + (float)(tint & 0xFF) * srcA);
            g = (int)((float)(this.abgr >> 8 & 0xFF) * (1.0f - srcA) + (float)(tint >> 8 & 0xFF) * srcA);
            r = (int)((float)(this.abgr & 0xFF) * (1.0f - srcA) + (float)(tint >> 16 & 0xFF) * srcA);
        }
        b = (int)((double)b * WakeColor.invertedLogisticCurve((float)(lightColor >> 16 & 0xFF) / 255.0f));
        g = (int)((double)g * WakeColor.invertedLogisticCurve((float)(lightColor >> 8 & 0xFF) / 255.0f));
        r = (int)((double)r * WakeColor.invertedLogisticCurve((float)(lightColor & 0xFF) / 255.0f));
        return a << 24 | b << 16 | g << 8 | r;
    }

    public String method_15434() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

