/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.wakes.simulation;

import doctor4t.defile.wakes.config.WakesConfig;
import doctor4t.defile.wakes.render.enums.WakeColor;
import doctor4t.defile.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import org.lwjgl.system.MemoryUtil;

public class Brick {
    public final int capacity;
    public final int dim;
    public final class_243 pos;
    private final WakeNode[][] nodes;
    public int occupied = 0;
    public Brick NORTH;
    public Brick EAST;
    public Brick SOUTH;
    public Brick WEST;
    public long imgPtr = -1L;
    public int texRes;
    public boolean hasPopulatedPixels = false;

    public Brick(int x, float y, int z, int width) {
        this.dim = width;
        this.capacity = this.dim * this.dim;
        this.nodes = new WakeNode[this.dim][this.dim];
        this.pos = new class_243((double)x, (double)y, (double)z);
        this.initTexture(WakesConfig.wakeResolution.res);
    }

    public void initTexture(int res) {
        long size = 4L * (long)this.dim * (long)this.dim * (long)res * (long)res;
        this.imgPtr = this.imgPtr == -1L ? MemoryUtil.nmemAlloc((long)size) : MemoryUtil.nmemRealloc((long)this.imgPtr, (long)size);
        this.texRes = res;
        this.hasPopulatedPixels = false;
    }

    public void deallocTexture() {
        MemoryUtil.nmemFree((long)this.imgPtr);
    }

    public boolean tick() {
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                if (this.get(x, z) == null || this.get(x, z).tick()) continue;
                this.clear(x, z);
            }
        }
        this.populatePixels();
        return this.occupied != 0;
    }

    public void query(class_4604 frustum, ArrayList<WakeNode> output) {
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                class_238 b;
                WakeNode node = this.get(x, z);
                if (node == null || !frustum.method_23093(b = node.toBox())) continue;
                output.add(node);
            }
        }
    }

    public WakeNode get(int x, int z) {
        if (x >= 0 && x < this.dim) {
            if (z < 0 && this.NORTH != null) {
                return this.NORTH.nodes[Math.floorMod(z, this.dim)][x];
            }
            if (z >= this.dim && this.SOUTH != null) {
                return this.SOUTH.nodes[Math.floorMod(z, this.dim)][x];
            }
            if (z >= 0 && z < this.dim) {
                return this.nodes[z][x];
            }
        }
        if (z >= 0 && z < this.dim) {
            if (x < 0 && this.WEST != null) {
                return this.WEST.nodes[z][Math.floorMod(x, this.dim)];
            }
            if (x >= this.dim && this.EAST != null) {
                return this.EAST.nodes[z][Math.floorMod(x, this.dim)];
            }
        }
        return null;
    }

    public void insert(WakeNode node) {
        int x = Math.floorMod(node.x, this.dim);
        int z = Math.floorMod(node.z, this.dim);
        if (this.nodes[z][x] != null) {
            this.nodes[z][x].revive(node);
            return;
        }
        this.set(x, z, node);
        for (WakeNode neighbor : this.getAdjacentNodes(x, z)) {
            neighbor.updateAdjacency(node);
        }
    }

    protected void set(int x, int z, WakeNode node) {
        boolean wasNull = this.nodes[z][x] == null;
        this.nodes[z][x] = node;
        if (node == null) {
            if (!wasNull) {
                --this.occupied;
            }
        } else if (wasNull) {
            ++this.occupied;
        }
    }

    public void clear(int x, int z) {
        this.set(x, z, null);
    }

    private List<WakeNode> getAdjacentNodes(int x, int z) {
        return Stream.of(this.get(x, z + 1), this.get(x + 1, z), this.get(x, z - 1), this.get(x - 1, z)).filter(Objects::nonNull).toList();
    }

    public void updateAdjacency(Brick brick) {
        if (brick.pos.field_1352 == this.pos.field_1352 && brick.pos.field_1350 == this.pos.field_1350 - (double)this.dim) {
            this.NORTH = brick;
            brick.SOUTH = this;
            return;
        }
        if (brick.pos.field_1352 == this.pos.field_1352 + (double)this.dim && brick.pos.field_1350 == this.pos.field_1350) {
            this.EAST = brick;
            brick.WEST = this;
            return;
        }
        if (brick.pos.field_1352 == this.pos.field_1352 && brick.pos.field_1350 == this.pos.field_1350 + (double)this.dim) {
            this.SOUTH = brick;
            brick.NORTH = this;
            return;
        }
        if (brick.pos.field_1352 == this.pos.field_1352 - (double)this.dim && brick.pos.field_1350 == this.pos.field_1350) {
            this.WEST = brick;
            brick.EAST = this;
        }
    }

    public void addTimeDelta(float dt) {
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                WakeNode node = this.get(x, z);
                if (node == null) continue;
                node.t += dt;
            }
        }
    }

    public void populatePixels() {
        class_638 world = class_310.method_1551().field_1687;
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                WakeNode node = this.get(x, z);
                int lightCol = 0xF000F0;
                int inkCol = 0;
                float opacity = 0.0f;
                if (node != null) {
                    inkCol = 984581;
                    float f = node.t / (float)WakesConfig.wakeVisibilityDuration;
                    opacity = (float)(Math.exp(-f * f) * (double)WakesConfig.wakeOpacity);
                }
                long nodeOffset = (long)this.texRes * 4L * ((long)z * (long)this.dim * (long)this.texRes + (long)x);
                for (int r = 0; r < this.texRes; ++r) {
                    for (int c = 0; c < this.texRes; ++c) {
                        int color = 0;
                        if (node != null) {
                            float avg = (node.u[0][r + 1][c + 1] + node.u[1][r + 1][c + 1] + node.u[2][r + 1][c + 1]) / 3.0f;
                            color = WakeColor.getColor(avg, inkCol, lightCol, opacity);
                        }
                        long pixelOffset = 4L * ((long)r * (long)this.dim * (long)this.texRes + (long)c);
                        MemoryUtil.memPutInt((long)(this.imgPtr + nodeOffset + pixelOffset), (int)color);
                    }
                }
            }
        }
        this.hasPopulatedPixels = true;
    }
}

