/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.wakes.simulation;

import doctor4t.defile.wakes.simulation.Brick;
import doctor4t.defile.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_238;
import net.minecraft.class_4604;

public class QuadTree {
    public static final int BRICK_WIDTH = 4;
    private static final int MAX_DEPTH = (int)(26.0 - Math.log(4.0) / Math.log(2.0));
    private static final int ROOT_X = (int)(-Math.pow(2.0, 25.0));
    private static final int ROOT_Z = (int)(-Math.pow(2.0, 25.0));
    private static final int ROOT_WIDTH = (int)Math.pow(2.0, 26.0);
    public final float yLevel;
    private final QuadTree ROOT;
    private final DecentralizedBounds bounds;
    private final int depth;
    private List<QuadTree> children;
    private Brick brick;

    public QuadTree(float y) {
        this(ROOT_X, y, ROOT_Z, ROOT_WIDTH, 0, null);
    }

    private QuadTree(int x, float y, int z, int width, int depth, QuadTree root) {
        this.bounds = new DecentralizedBounds(x, y, z, width);
        this.depth = depth;
        this.ROOT = root == null ? this : root;
        this.yLevel = y;
    }

    private boolean hasLeaf() {
        return this.depth == MAX_DEPTH && this.brick != null;
    }

    private void initLeaf() {
        if (this.depth >= MAX_DEPTH) {
            this.brick = new Brick(this.bounds.x, this.yLevel, this.bounds.z, this.bounds.width);
            this.ROOT.updateAdjacency(this);
        }
    }

    protected void updateAdjacency(QuadTree leaf) {
        if (this == leaf) {
            return;
        }
        if (!this.bounds.neighbors(leaf.bounds) && !this.bounds.intersects(leaf.bounds)) {
            return;
        }
        if (this.brick != null) {
            this.brick.updateAdjacency(leaf.brick);
            return;
        }
        if (this.children != null) {
            for (QuadTree tree : this.children) {
                tree.updateAdjacency(leaf);
            }
        }
    }

    public boolean tick() {
        if (this.hasLeaf()) {
            return this.brick.tick();
        }
        if (this.children == null) {
            return false;
        }
        int aliveChildren = 0;
        for (QuadTree tree : this.children) {
            if (!tree.tick()) continue;
            ++aliveChildren;
        }
        if (aliveChildren == 0) {
            this.prune();
        }
        return aliveChildren > 0;
    }

    public boolean insert(WakeNode node) {
        if (!this.bounds.contains(node.x, node.z)) {
            return false;
        }
        if (this.depth == MAX_DEPTH) {
            if (this.brick == null) {
                this.initLeaf();
            }
            this.brick.insert(node);
            return true;
        }
        if (this.children == null) {
            this.subdivide();
        }
        for (QuadTree tree : this.children) {
            if (!tree.insert(node)) continue;
            return true;
        }
        return false;
    }

    public <T> void query(class_4604 frustum, ArrayList<T> output, Class<T> type) {
        if (!frustum.method_23093(this.bounds.toBox((int)this.yLevel))) {
            return;
        }
        if (this.hasLeaf() && this.brick.occupied > 0) {
            if (type.equals(Brick.class)) {
                output.add(type.cast(this.brick));
            }
            if (type.equals(WakeNode.class)) {
                ArrayList<WakeNode> nodes = new ArrayList<WakeNode>();
                this.brick.query(frustum, nodes);
                for (WakeNode node : nodes) {
                    output.add(type.cast(node));
                }
            }
            return;
        }
        if (this.children == null) {
            return;
        }
        for (QuadTree tree : this.children) {
            tree.query(frustum, output, type);
        }
    }

    private void subdivide() {
        if (this.depth == MAX_DEPTH) {
            return;
        }
        int x = this.bounds.x;
        int z = this.bounds.z;
        int w = this.bounds.width >> 1;
        this.children = new ArrayList<QuadTree>();
        this.children.add(0, new QuadTree(x, this.yLevel, z, w, this.depth + 1, this.ROOT));
        this.children.add(1, new QuadTree(x + w, this.yLevel, z, w, this.depth + 1, this.ROOT));
        this.children.add(2, new QuadTree(x, this.yLevel, z + w, w, this.depth + 1, this.ROOT));
        this.children.add(3, new QuadTree(x + w, this.yLevel, z + w, w, this.depth + 1, this.ROOT));
    }

    public void prune() {
        if (this.children != null) {
            for (QuadTree tree : this.children) {
                tree.prune();
                if (!tree.hasLeaf()) continue;
                tree.brick.deallocTexture();
            }
            this.children.set(0, null);
            this.children.set(1, null);
            this.children.set(2, null);
            this.children.set(3, null);
        }
        this.children = null;
    }

    public record DecentralizedBounds(int x, float y, int z, int width) {
        public boolean contains(int x, int z) {
            return this.x <= x && x < this.x + this.width && this.z <= z && z < this.z + this.width;
        }

        public boolean intersects(DecentralizedBounds other) {
            return this.x <= other.x + other.width && this.x + this.width >= other.x && this.z <= other.z + other.width && this.z + this.width >= other.z;
        }

        public boolean neighbors(DecentralizedBounds other) {
            return this.x != other.x + other.width && this.x + this.width != other.x && this.z != other.z + other.width && this.z + this.width != other.z;
        }

        public class_238 toBox(int y) {
            return new class_238((double)this.x, (double)y - 0.5, (double)this.z, (double)(this.x + this.width), (double)y + 0.5, (double)(this.z + this.width));
        }
    }
}

