/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.wakes.simulation;

import doctor4t.defile.index.DefileBlocks;
import doctor4t.defile.wakes.config.WakesConfig;
import doctor4t.defile.wakes.simulation.WakeHandler;
import doctor4t.defile.wakes.utils.WakesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class WakeNode {
    public static final float WATER_OFFSET = 0.8888889f;
    public static int res = WakesConfig.wakeResolution.res;
    private static float alpha;
    private static float beta;
    public final int x;
    public final int y;
    public final int z;
    public float[][][] u;
    public float[][] initialValues;
    public WakeNode NORTH = null;
    public WakeNode EAST = null;
    public WakeNode SOUTH = null;
    public WakeNode WEST = null;
    public int age = 0;
    public float t = 0.0f;
    public int floodLevel;
    private boolean dead = false;

    public WakeNode(class_243 position, int initialStrength) {
        this.initValues();
        this.x = (int)Math.floor(position.field_1352);
        this.y = (int)Math.floor(position.field_1351);
        this.z = (int)Math.floor(position.field_1350);
        int sx = (int)Math.floor((double)res * (position.field_1352 - (double)this.x));
        int sz = (int)Math.floor((double)res * (position.field_1350 - (double)this.z));
        for (int z = -1; z < 2; ++z) {
            for (int x = -1; x < 2; ++x) {
                this.u[0][sz + 1 + z][sx + 1 + x] = initialStrength;
            }
        }
        this.floodLevel = WakesConfig.floodFillDistance;
    }

    private WakeNode(int x, int y, int z, int floodLevel) {
        this.initValues();
        this.x = x;
        this.y = y;
        this.z = z;
        this.floodLevel = floodLevel;
    }

    private WakeNode(long pos, int y) {
        this.initValues();
        int[] xz = WakesUtils.longAsPos(pos);
        this.x = xz[0];
        this.y = y;
        this.z = xz[1];
        this.floodLevel = WakesConfig.floodFillDistance;
    }

    public static void calculateWaveDevelopmentFactors() {
        float time = 20.0f;
        alpha = (float)Math.pow(14.4f / time, 2.0);
        beta = (float)(Math.log(10.0f * WakesConfig.waveDecayFactor + 10.0f) / Math.log(20.0));
    }

    private void initValues() {
        this.u = new float[3][res + 2][res + 2];
        this.initialValues = new float[res + 2][res + 2];
    }

    public void setInitialValue(long pos, int val) {
        float resFactor = (float)res / 16.0f;
        int[] xz = WakesUtils.longAsPos(pos);
        if (xz[0] < 0) {
            xz[0] = xz[0] + res;
        }
        if (xz[1] < 0) {
            xz[1] = xz[1] + res;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.initialValues[xz[1] + i + 1][xz[0] + j + 1] = (float)val * resFactor;
            }
        }
    }

    public boolean tick() {
        int x;
        int z;
        alpha = (float)Math.pow(0.7199999690055847, 2.0);
        beta = (float)(Math.log(10.0f * WakesConfig.waveDecayFactor + 10.0f) / Math.log(20.0));
        int maxAge = WakesConfig.maxNodeAge;
        if (this.isDead()) {
            return false;
        }
        if (this.age++ >= maxAge || res != WakesConfig.wakeResolution.res) {
            this.markDead();
            return false;
        }
        for (int i = 2; i >= 1; --i) {
            if (this.NORTH != null) {
                this.u[i][0] = this.NORTH.u[i][res];
            }
            if (this.SOUTH != null) {
                this.u[i][WakeNode.res + 1] = this.SOUTH.u[i][1];
            }
            for (int z2 = 0; z2 < res + 2 && (this.EAST != null || this.WEST != null); ++z2) {
                if (this.EAST != null) {
                    this.u[i][z2][WakeNode.res + 1] = this.EAST.u[i][z2][1];
                }
                if (this.WEST == null) continue;
                this.u[i][z2][0] = this.WEST.u[i][z2][res];
            }
        }
        for (z = 1; z < res + 1; ++z) {
            for (x = 1; x < res + 1; ++x) {
                float[] fArray = this.u[0][z];
                int n = x;
                fArray[n] = fArray[n] + this.initialValues[z][x];
                this.initialValues[z][x] = 0.0f;
                this.u[2][z][x] = this.u[1][z][x];
                this.u[1][z][x] = this.u[0][z][x];
            }
        }
        for (z = 1; z < res + 1; ++z) {
            x = 1;
            while (x < res + 1) {
                this.u[0][z][x] = (float)((double)alpha * (0.5 * (double)this.u[1][z - 1][x] + 0.25 * (double)this.u[1][z - 1][x + 1] + 0.5 * (double)this.u[1][z][x + 1] + 0.25 * (double)this.u[1][z + 1][x + 1] + 0.5 * (double)this.u[1][z + 1][x] + 0.25 * (double)this.u[1][z + 1][x - 1] + 0.5 * (double)this.u[1][z][x - 1] + 0.25 * (double)this.u[1][z - 1][x - 1] - (double)(3.0f * this.u[1][z][x])) + (double)(2.0f * this.u[1][z][x]) - (double)this.u[2][z][x]);
                float[] fArray = this.u[0][z];
                int n = x++;
                fArray[n] = fArray[n] * beta;
            }
        }
        this.floodFill();
        return true;
    }

    public void floodFill() {
        WakeHandler wh = WakeHandler.getInstance();
        assert (wh != null);
        if (this.floodLevel > 0 && this.age > WakesConfig.ticksBeforeFill) {
            if (this.NORTH == null) {
                wh.insert(new WakeNode(this.x, this.y, this.z - 1, this.floodLevel - 1));
            } else {
                this.NORTH.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.EAST == null) {
                wh.insert(new WakeNode(this.x + 1, this.y, this.z, this.floodLevel - 1));
            } else {
                this.EAST.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.SOUTH == null) {
                wh.insert(new WakeNode(this.x, this.y, this.z + 1, this.floodLevel - 1));
            } else {
                this.SOUTH.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.WEST == null) {
                wh.insert(new WakeNode(this.x - 1, this.y, this.z, this.floodLevel - 1));
            } else {
                this.WEST.updateFloodLevel(this.floodLevel - 1);
            }
            this.floodLevel = 0;
        }
    }

    public void updateAdjacency(WakeNode node) {
        if (node.x == this.x && node.z == this.z - 1) {
            this.NORTH = node;
            node.SOUTH = this;
            return;
        }
        if (node.x == this.x + 1 && node.z == this.z) {
            this.EAST = node;
            node.WEST = this;
            return;
        }
        if (node.x == this.x && node.z == this.z + 1) {
            this.SOUTH = node;
            node.NORTH = this;
            return;
        }
        if (node.x == this.x - 1 && node.z == this.z) {
            this.WEST = node;
            node.EAST = this;
        }
    }

    public void updateFloodLevel(int newLevel) {
        this.age = 0;
        if (newLevel > this.floodLevel) {
            this.floodLevel = newLevel;
        }
    }

    public boolean validPos(class_1937 world) {
        return world.method_8320(this.blockPos()).method_27852(DefileBlocks.FUNERAL_INK);
    }

    public class_238 toBox() {
        return new class_238((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)((float)this.y + 0.111111104f), (double)(this.z + 1));
    }

    public void revive(WakeNode node) {
        this.age = 0;
        this.t = 0.0f;
        this.floodLevel = WakesConfig.floodFillDistance;
        this.initialValues = node.initialValues;
    }

    public void markDead() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public class_2338 blockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WakeNode wakeNode = (WakeNode)o;
        return this.x == wakeNode.x && this.z == wakeNode.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return String.format("WakeNode{%d, %d, %d}", this.x, this.y, this.z);
    }

    public static class Factory {
        public static Set<WakeNode> splashNodes(class_1297 entity, int y) {
            int res = WakeNode.res;
            int w = (int)(0.8 * (double)entity.method_17681() * (double)res / 2.0);
            int x = (int)(entity.method_23317() * (double)res);
            int z = (int)(entity.method_23321() * (double)res);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            for (int i = -w; i < w; ++i) {
                for (int j = -w; j < w; ++j) {
                    if (i * i + j * j >= w * w) continue;
                    pixelsAffected.add(WakesUtils.posAsLong(x + i, z + j));
                }
            }
            return Factory.pixelsToNodes(pixelsAffected, y, WakesConfig.splashStrength, Math.abs(entity.method_18798().field_1351));
        }

        public static Set<WakeNode> nodeTrail(double fromX, double fromZ, double toX, double toZ, int y, float waveStrength, double velocity) {
            int res = WakeNode.res;
            int x1 = (int)(fromX * (double)res);
            int z1 = (int)(fromZ * (double)res);
            int x2 = (int)(toX * (double)res);
            int z2 = (int)(toZ * (double)res);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            WakesUtils.bresenhamLine(x1, z1, x2, z2, pixelsAffected);
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity);
        }

        public static Set<WakeNode> thickNodeTrail(double fromX, double fromZ, double toX, double toZ, int y, float waveStrength, double velocity, float width) {
            int res = WakeNode.res;
            int x1 = (int)(fromX * (double)res);
            int z1 = (int)(fromZ * (double)res);
            int x2 = (int)(toX * (double)res);
            int z2 = (int)(toZ * (double)res);
            int w = (int)(0.8 * (double)width * (double)res / 2.0);
            float len = (float)Math.sqrt(Math.pow(z1 - z2, 2.0) + Math.pow(x2 - x1, 2.0));
            float nx = (float)(z1 - z2) / len;
            float nz = (float)(x2 - x1) / len;
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            for (int i = -w; i < w; ++i) {
                WakesUtils.bresenhamLine((int)((float)x1 + nx * (float)i), (int)((float)z1 + nz * (float)i), (int)((float)x2 + nx * (float)i), (int)((float)z2 + nz * (float)i), pixelsAffected);
            }
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity);
        }

        public static Set<WakeNode> nodeLine(double x, int y, double z, float waveStrength, class_243 velocity, float width) {
            int res = WakeNode.res;
            class_243 dir = velocity.method_1029();
            double nx = -dir.field_1350;
            double nz = dir.field_1352;
            int w = (int)(0.8 * (double)width * (double)res / 2.0);
            int x1 = (int)(x * (double)res - nx * (double)w);
            int z1 = (int)(z * (double)res - nz * (double)w);
            int x2 = (int)(x * (double)res + nx * (double)w);
            int z2 = (int)(z * (double)res + nz * (double)w);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            WakesUtils.bresenhamLine(x1, z1, x2, z2, pixelsAffected);
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity.method_37267());
        }

        private static Set<WakeNode> pixelsToNodes(ArrayList<Long> pixelsAffected, int y, float waveStrength, double velocity) {
            int res = WakeNode.res;
            int power = (int)(Math.log(res) / Math.log(2.0));
            HashMap pixelsInNodes = new HashMap();
            for (Long pixel : pixelsAffected) {
                int[] pos = WakesUtils.longAsPos(pixel);
                long k = WakesUtils.posAsLong(pos[0] >> power, pos[1] >> power);
                pos[0] = pos[0] % res;
                pos[1] = pos[1] % res;
                long v = WakesUtils.posAsLong(pos[0], pos[1]);
                if (pixelsInNodes.containsKey(k)) {
                    ((HashSet)pixelsInNodes.get(k)).add(v);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(v);
                pixelsInNodes.put(k, set);
            }
            HashSet<WakeNode> nodesAffected = new HashSet<WakeNode>();
            for (Long nodePos : pixelsInNodes.keySet()) {
                WakeNode node = new WakeNode(nodePos, y);
                for (Long subPos : (HashSet)pixelsInNodes.get(nodePos)) {
                    node.setInitialValue(subPos, (int)((double)waveStrength * velocity));
                }
                nodesAffected.add(node);
            }
            return nodesAffected;
        }
    }
}

