/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.wakes.utils;

import doctor4t.defile.wakes.config.WakesConfig;
import doctor4t.defile.wakes.config.enums.EffectSpawningRule;
import doctor4t.defile.wakes.duck.ProducesWake;
import doctor4t.defile.wakes.simulation.WakeHandler;
import doctor4t.defile.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_745;
import net.minecraft.class_746;

public class WakesUtils {
    public static void placeFallSplash(class_1297 entity) {
        WakeHandler instance = WakeHandler.getInstance();
        if (instance == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.splashNodes(entity, (int)Math.floor(((ProducesWake)entity).producingWaterLevel().floatValue()))) {
            instance.insert(node);
        }
    }

    public static void placeWakeTrail(class_1297 entity) {
        WakeHandler wakeHandler = WakeHandler.getInstance();
        if (wakeHandler == null) {
            return;
        }
        ProducesWake producer = (ProducesWake)entity;
        double velocity = producer.getHorizontalVelocity();
        int y = (int)Math.floor(producer.producingWaterLevel().floatValue());
        class_243 prevPos = producer.getPrevPos();
        if (prevPos == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.thickNodeTrail(prevPos.field_1352, prevPos.field_1350, entity.method_23317(), entity.method_23321(), y, WakesConfig.initialStrength, velocity, entity.method_17681())) {
            wakeHandler.insert(node);
        }
    }

    public static EffectSpawningRule getEffectRuleFromSource(class_1297 source) {
        Map<String, EffectSpawningRule> effectRule = WakesConfig.effectSpawningRules;
        if (source instanceof class_1690) {
            class_1690 boat = (class_1690)source;
            List passengers = boat.method_5685();
            if (passengers.contains(class_310.method_1551().field_1724)) {
                return effectRule.get("boat");
            }
            if (passengers.stream().anyMatch(class_1297::method_31747)) {
                return effectRule.get("boat").mask(effectRule.get("other_players"));
            }
            return effectRule.get("boat");
        }
        if (source instanceof class_1657) {
            class_1657 player = (class_1657)source;
            if (player.method_7325()) {
                return EffectSpawningRule.DISABLED;
            }
            if (player instanceof class_746) {
                return effectRule.get("player");
            }
            if (player instanceof class_745) {
                return effectRule.get("other_players");
            }
            return EffectSpawningRule.DISABLED;
        }
        if (source instanceof class_1309) {
            return effectRule.get("mobs");
        }
        if (source instanceof class_1542) {
            return effectRule.get("items");
        }
        return EffectSpawningRule.DISABLED;
    }

    public static void bresenhamLine(int x1, int y1, int x2, int y2, ArrayList<Long> points) {
        int dy = y2 - y1;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y2 < y1) {
                int temp = y1;
                y1 = y2;
                y2 = temp;
            }
            for (int y = y1; y < y2 + 1; ++y) {
                points.add(WakesUtils.posAsLong(x1, y));
            }
        } else {
            float k = (float)dy / (float)dx;
            int adjust = k >= 0.0f ? 1 : -1;
            int offset = 0;
            if (k <= 1.0f && k >= -1.0f) {
                int delta = Math.abs(dy) * 2;
                int threshold = Math.abs(dx);
                int thresholdInc = Math.abs(dx) * 2;
                int y = y1;
                if (x2 < x1) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                    y = y2;
                }
                for (int x = x1; x < x2 + 1; ++x) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    y += adjust;
                    threshold += thresholdInc;
                }
            } else {
                int delta = Math.abs(dx) * 2;
                int threshold = Math.abs(dy);
                int thresholdInc = Math.abs(dy) * 2;
                int x = x1;
                if (y2 < y1) {
                    int temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                for (int y = y1; y < y2 + 1; ++y) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    x += adjust;
                    threshold += thresholdInc;
                }
            }
        }
    }

    public static long posAsLong(int x, int y) {
        int xs = x >> 31 & 1;
        int ys = y >> 31 & 1;
        long pos = (long)(x &= Integer.MAX_VALUE) << 32 | (long)(y &= Integer.MAX_VALUE);
        pos ^= ((long)(-xs) ^ pos) & Long.MIN_VALUE;
        pos ^= ((long)(-ys) ^ pos) & 0x80000000L;
        return pos;
    }

    public static int[] longAsPos(long pos) {
        return new int[]{(int)(pos >> 32), (int)pos};
    }

    public static int[] abgrInt2rgbaArr(int n) {
        int[] arr = new int[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n2 = i;
                arr[n2] = arr[n2] | (n >> i * 8 + j & 1) << 7 - j;
            }
        }
        return arr;
    }

    public static int rgbaArr2abgrInt(int[] arr) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                n |= (arr[i] >> j & 1) << i * 8 + j;
            }
        }
        return n;
    }
}

