/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.render.test;

import doctor4t.defile.Defile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public final class DataHelper {
    public static class_243 fromBlockPos(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_1160 fromBlockPosVec3f(class_2338 pos) {
        return new class_1160((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
    }

    public static class_243 randPos(class_2338 pos, class_5819 rand, double min, double max) {
        double x = class_3532.method_15366((class_5819)rand, (double)min, (double)max) + (double)pos.method_10263();
        double y = class_3532.method_15366((class_5819)rand, (double)min, (double)max) + (double)pos.method_10264();
        double z = class_3532.method_15366((class_5819)rand, (double)min, (double)max) + (double)pos.method_10260();
        return new class_243(x, y, z);
    }

    public static class_2960 prefix(String path) {
        return Defile.id(path);
    }

    public static <T, K extends Collection<T>> K reverseOrder(Supplier<K> reversed, Collection<T> items) {
        ArrayList<T> original = new ArrayList<T>(items);
        Collection newCollection = (Collection)reversed.get();
        for (int i = items.size() - 1; i >= 0; --i) {
            newCollection.add(original.get(i));
        }
        return (K)newCollection;
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    public static void writeNbt(class_2487 nbt, class_2371<class_1799> stacks, String key) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 itemStack = (class_1799)stacks.get(i);
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            itemStack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbt.method_10566(key, (class_2520)nbtList);
    }

    public static void readNbt(class_2487 nbt, class_2371<class_1799> stacks, String key) {
        class_2499 nbtList = nbt.method_10554(key, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571("Slot") & 0xFF;
            if (j >= stacks.size()) continue;
            stacks.set(j, (Object)class_1799.method_7915((class_2487)nbtCompound));
        }
    }

    public static int[] nextInts(class_5819 rand, int count, int range) {
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            int nextInt;
            do {
                nextInt = rand.method_43048(range);
            } while (!Arrays.stream(ints).noneMatch(j -> j == nextInt));
            ints[i] = nextInt;
        }
        return ints;
    }

    public static <T> boolean hasDuplicate(T[] things) {
        HashSet thingSet = new HashSet();
        return !Arrays.stream(things).allMatch(thingSet::add);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iterable = src.iterator();
        while (iterable.hasNext()) {
            T item = iterable.next();
            if (!pred.test(item)) continue;
            iterable.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Collection<T> getAll(Collection<? extends T> src, T ... items) {
        return List.copyOf(DataHelper.getAll(src, t -> Arrays.stream(items).anyMatch(tAgain -> tAgain.getClass().isInstance(t))));
    }

    public static <T> Collection<T> getAll(Collection<T> src, Predicate<T> pred) {
        return src.stream().filter(pred).collect(Collectors.toList());
    }

    public static class_243 circlePosition(class_243 pos, float distance, float current, float total) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle);
        double dz2 = (double)distance * Math.sin(angle);
        class_243 vector = new class_243(dx2, 0.0, dz2);
        double x = vector.field_1352 * (double)distance;
        double z = vector.field_1350 * (double)distance;
        return pos.method_1019(new class_243(x, 0.0, z));
    }

    public static class_243 rotatedCirclePosition(class_243 pos, float distance, float current, float total, long gameTime, float time, float tickDelta) {
        return DataHelper.rotatedCirclePosition(pos, distance, distance, current, total, gameTime, time, tickDelta);
    }

    public static class_243 rotatedCirclePosition(class_243 pos, float distanceX, float distanceZ, float current, float total, long gameTime, float time, float tickDelta) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distanceX * Math.cos(angle += (double)(((float)gameTime % time + tickDelta) / time) * (Math.PI * 2));
        double dz2 = (double)distanceZ * Math.sin(angle);
        class_243 vector2f = new class_243(dx2, 0.0, dz2);
        double x = vector2f.field_1352 * (double)distanceX;
        double z = vector2f.field_1350 * (double)distanceZ;
        return pos.method_1031(x, 0.0, z);
    }

    public static ArrayList<class_243> blockOutlinePositions(class_1937 world, class_2338 pos) {
        ArrayList<class_243> arrayList = new ArrayList<class_243>();
        double d0 = 0.5625;
        class_5819 random = world.field_9229;
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = pos.method_10093(direction);
            if (world.method_8320(blockpos).method_26216((class_1922)world, blockpos)) continue;
            class_2350.class_2351 direction$axis = direction.method_10166();
            double d1 = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + d0 * (double)direction.method_10148() : (double)random.method_43057();
            double d2 = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + d0 * (double)direction.method_10164() : (double)random.method_43057();
            double d3 = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + d0 * (double)direction.method_10165() : (double)random.method_43057();
            arrayList.add(new class_243((double)pos.method_10263() + d1, (double)pos.method_10264() + d2, (double)pos.method_10260() + d3));
        }
        return arrayList;
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static float distance(float ... a) {
        return (float)Math.sqrt(DataHelper.distSqr(a));
    }
}

